/*
 * Decompiled with CFR 0.152.
 */
package android.app.ondeviceintelligence;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.ondeviceintelligence.IProcessingSignal;
import android.os.PersistableBundle;
import android.os.RemoteException;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
@FlaggedApi(value="android.app.ondeviceintelligence.flags.enable_on_device_intelligence")
public class ProcessingSignal {
    private final Object mLock = new Object();
    private static final int MAX_QUEUE_SIZE = 10;
    @GuardedBy(value={"mLock"})
    private final ArrayDeque<PersistableBundle> mActionParamsQueue = new ArrayDeque(10);
    @GuardedBy(value={"mLock"})
    private IProcessingSignal mRemote;
    private OnProcessingSignalCallback mOnProcessingSignalCallback;
    private Executor mExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSignal(@NonNull PersistableBundle actionParams) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mActionParamsQueue.size() > 10) {
                throw new RuntimeException("Maximum actions that can be queued are : 10");
            }
            this.mActionParamsQueue.add(actionParams);
            OnProcessingSignalCallback callback = this.mOnProcessingSignalCallback;
            IProcessingSignal remote = this.mRemote;
            if (callback != null) {
                while (!this.mActionParamsQueue.isEmpty()) {
                    PersistableBundle params = this.mActionParamsQueue.removeFirst();
                    this.mExecutor.execute(() -> callback.onSignalReceived(params));
                }
            }
            if (remote != null) {
                while (!this.mActionParamsQueue.isEmpty()) {
                    try {
                        remote.sendSignal(this.mActionParamsQueue.removeFirst());
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnProcessingSignalCallback(@NonNull Executor executor, @Nullable OnProcessingSignalCallback callback) {
        Objects.requireNonNull(executor);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOnProcessingSignalCallback == callback) {
                return;
            }
            this.mOnProcessingSignalCallback = callback;
            this.mExecutor = executor;
            if (callback == null || this.mActionParamsQueue.isEmpty()) {
                return;
            }
            while (!this.mActionParamsQueue.isEmpty()) {
                PersistableBundle params = this.mActionParamsQueue.removeFirst();
                this.mExecutor.execute(() -> callback.onSignalReceived(params));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRemote(IProcessingSignal remote) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRemote = remote;
            if (this.mActionParamsQueue.isEmpty() || remote == null) {
                return;
            }
            while (!this.mActionParamsQueue.isEmpty()) {
                try {
                    remote.sendSignal(this.mActionParamsQueue.removeFirst());
                }
                catch (RemoteException e) {
                    throw new RuntimeException("Failed to send action to remote signal", e);
                }
            }
        }
    }

    public static IProcessingSignal createTransport() {
        return new Transport();
    }

    public static ProcessingSignal fromTransport(IProcessingSignal transport) {
        if (transport instanceof Transport) {
            return ((Transport)transport).mProcessingSignal;
        }
        return null;
    }

    public static interface OnProcessingSignalCallback {
        public void onSignalReceived(@NonNull PersistableBundle var1);
    }

    private static class Transport
    extends IProcessingSignal.Stub {
        final ProcessingSignal mProcessingSignal = new ProcessingSignal();

        private Transport() {
        }

        @Override
        public void sendSignal(PersistableBundle actionParams) {
            this.mProcessingSignal.sendSignal(actionParams);
        }
    }
}

