/*
 * Decompiled with CFR 0.152.
 */
package android.app.role;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.compat.CompatChanges;
import android.app.role.IOnRoleHoldersChangedListener;
import android.app.role.IRoleManager;
import android.app.role.OnRoleHoldersChangedListener;
import android.app.role.RoleControllerManager;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Process;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.UserHandle;
import android.permission.jarjar.android.permission.flags.Flags;
import android.permission.jarjar.com.android.internal.annotations.GuardedBy;
import android.permission.jarjar.com.android.internal.util.Preconditions;
import android.permission.jarjar.com.android.modules.utils.build.SdkLevel;
import android.util.ArrayMap;
import android.util.SparseArray;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class RoleManager {
    public static final String ROLE_ASSISTANT = "android.app.role.ASSISTANT";
    public static final String ROLE_BROWSER = "android.app.role.BROWSER";
    public static final String ROLE_DIALER = "android.app.role.DIALER";
    public static final String ROLE_SMS = "android.app.role.SMS";
    public static final String ROLE_EMERGENCY = "android.app.role.EMERGENCY";
    public static final String ROLE_HOME = "android.app.role.HOME";
    public static final String ROLE_CALL_REDIRECTION = "android.app.role.CALL_REDIRECTION";
    public static final String ROLE_CALL_SCREENING = "android.app.role.CALL_SCREENING";
    public static final String ROLE_NOTES = "android.app.role.NOTES";
    @FlaggedApi(value="android.permission.flags.wallet_role_enabled")
    @RequiresApi(value=35)
    public static final String ROLE_WALLET = "android.app.role.WALLET";
    @SystemApi
    public static final String ROLE_SYSTEM_WELLBEING = "android.app.role.SYSTEM_WELLBEING";
    @SystemApi
    public static final String ROLE_SYSTEM_SUPERVISION = "android.app.role.SYSTEM_SUPERVISION";
    @SystemApi
    public static final String ROLE_SYSTEM_ACTIVITY_RECOGNIZER = "android.app.role.SYSTEM_ACTIVITY_RECOGNIZER";
    @SystemApi
    public static final String ROLE_DEVICE_POLICY_MANAGEMENT = "android.app.role.DEVICE_POLICY_MANAGEMENT";
    @SystemApi
    public static final String ROLE_FINANCED_DEVICE_KIOSK = "android.app.role.FINANCED_DEVICE_KIOSK";
    @SystemApi
    public static final String ROLE_SYSTEM_CALL_STREAMING = "android.app.role.SYSTEM_CALL_STREAMING";
    @SystemApi
    @FlaggedApi(value="com.android.permission.flags.cross_user_role_enabled")
    public static final String ROLE_RESERVED_FOR_TESTING_PROFILE_GROUP_EXCLUSIVITY = "android.app.role.RESERVED_FOR_TESTING_PROFILE_GROUP_EXCLUSIVITY";
    @SystemApi
    public static final int MANAGE_HOLDERS_FLAG_DONT_KILL_APP = 1;
    public static final long ROLE_MANAGER_USER_HANDLE_AWARE = 303742236L;
    public static final String ACTION_REQUEST_ROLE = "android.app.role.action.REQUEST_ROLE";
    public static final String PERMISSION_MANAGE_ROLES_FROM_CONTROLLER = "com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER";
    @SystemApi
    @FlaggedApi(value="android.content.pm.sdk_dependency_installer")
    public static final String ROLE_SYSTEM_DEPENDENCY_INSTALLER = "android.app.role.SYSTEM_DEPENDENCY_INSTALLER";
    @NonNull
    private final Context mContext;
    @NonNull
    private final IRoleManager mService;
    @GuardedBy(value={"mListenersLock"})
    @NonNull
    private final SparseArray<ArrayMap<OnRoleHoldersChangedListener, OnRoleHoldersChangedListenerDelegate>> mListeners = new SparseArray();
    @NonNull
    private final Object mListenersLock = new Object();
    @GuardedBy(value={"mRoleControllerManagerLock"})
    @Nullable
    private RoleControllerManager mRoleControllerManager;
    private final Object mRoleControllerManagerLock = new Object();

    public RoleManager(@NonNull Context context, @NonNull IRoleManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @NonNull
    public Intent createRequestRoleIntent(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Intent intent = new Intent(ACTION_REQUEST_ROLE);
        intent.setPackage(this.mContext.getPackageManager().getPermissionControllerPackageName());
        intent.putExtra("android.intent.extra.ROLE_NAME", roleName);
        return intent;
    }

    public boolean isRoleAvailable(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        UserHandle user = this.getContextUserIfAppropriate();
        try {
            return this.mService.isRoleAvailableAsUser(roleName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isRoleHeld(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        UserHandle user = this.getContextUserIfAppropriate();
        try {
            return this.mService.isRoleHeldAsUser(roleName, this.mContext.getPackageName(), user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public List<String> getRoleHolders(@NonNull String roleName) {
        return this.getRoleHoldersAsUser(roleName, this.getContextUserIfAppropriate());
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public List<String> getRoleHoldersAsUser(@NonNull String roleName, @NonNull UserHandle user) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Objects.requireNonNull(user, "user cannot be null");
        try {
            return this.mService.getRoleHoldersAsUser(roleName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void addRoleHolderAsUser(@NonNull String roleName, @NonNull String packageName, int flags, @NonNull UserHandle user, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
        Objects.requireNonNull(user, "user cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        try {
            this.mService.addRoleHolderAsUser(roleName, packageName, flags, user.getIdentifier(), RoleManager.createRemoteCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void removeRoleHolderAsUser(@NonNull String roleName, @NonNull String packageName, int flags, @NonNull UserHandle user, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
        Objects.requireNonNull(user, "user cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        try {
            this.mService.removeRoleHolderAsUser(roleName, packageName, flags, user.getIdentifier(), RoleManager.createRemoteCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void clearRoleHoldersAsUser(@NonNull String roleName, int flags, @NonNull UserHandle user, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Objects.requireNonNull(user, "user cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        try {
            this.mService.clearRoleHoldersAsUser(roleName, flags, user.getIdentifier(), RoleManager.createRemoteCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Nullable
    @RequiresPermission(value="android.permission.MANAGE_DEFAULT_APPLICATIONS")
    @RequiresApi(value=34)
    public String getDefaultApplication(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        try {
            return this.mService.getDefaultApplicationAsUser(roleName, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_DEFAULT_APPLICATIONS")
    @RequiresApi(value=34)
    public void setDefaultApplication(@NonNull String roleName, @Nullable String packageName, int flags, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        try {
            this.mService.setDefaultApplicationAsUser(roleName, packageName, flags, this.mContext.getUser().getIdentifier(), RoleManager.createRemoteCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.MANAGE_ROLE_HOLDERS", "android.permission.MANAGE_DEFAULT_APPLICATIONS"}, conditional=true)
    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.permission.flags.cross_user_role_enabled")
    @Nullable
    public UserHandle getActiveUserForRole(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        try {
            int userId = this.mService.getActiveUserForRoleAsUser(roleName, this.mContext.getUser().getIdentifier());
            return userId == -10000 ? null : UserHandle.of(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.MANAGE_ROLE_HOLDERS", "android.permission.MANAGE_DEFAULT_APPLICATIONS"}, conditional=true)
    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.permission.flags.cross_user_role_enabled")
    @SuppressLint(value={"UserHandle"})
    public void setActiveUserForRole(@NonNull String roleName, @NonNull UserHandle user, int flags) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Objects.requireNonNull(user, "user cannot be null");
        try {
            this.mService.setActiveUserForRoleAsUser(roleName, user.getIdentifier(), flags, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    private static RemoteCallback createRemoteCallback(@NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        return new RemoteCallback(result -> executor.execute(() -> {
            boolean successful = result != null;
            long token = Binder.clearCallingIdentity();
            try {
                callback.accept(successful);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_ROLE_HOLDERS")
    @SuppressLint(value={"SamShouldBeLast"})
    public void addOnRoleHoldersChangedListenerAsUser(@NonNull Executor executor, @NonNull OnRoleHoldersChangedListener listener, @NonNull UserHandle user) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(user, "user cannot be null");
        int userId = user.getIdentifier();
        Object object = this.mListenersLock;
        synchronized (object) {
            ArrayMap<OnRoleHoldersChangedListener, OnRoleHoldersChangedListenerDelegate> listeners = this.mListeners.get(userId);
            if (listeners == null) {
                listeners = new ArrayMap();
                this.mListeners.put(userId, listeners);
            } else if (listeners.containsKey(listener)) {
                return;
            }
            OnRoleHoldersChangedListenerDelegate listenerDelegate = new OnRoleHoldersChangedListenerDelegate(executor, listener);
            try {
                this.mService.addOnRoleHoldersChangedListenerAsUser(listenerDelegate, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            listeners.put(listener, listenerDelegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_ROLE_HOLDERS")
    @SuppressLint(value={"SamShouldBeLast"})
    public void removeOnRoleHoldersChangedListenerAsUser(@NonNull OnRoleHoldersChangedListener listener, @NonNull UserHandle user) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(user, "user cannot be null");
        int userId = user.getIdentifier();
        Object object = this.mListenersLock;
        synchronized (object) {
            ArrayMap<OnRoleHoldersChangedListener, OnRoleHoldersChangedListenerDelegate> listeners = this.mListeners.get(userId);
            if (listeners == null) {
                return;
            }
            OnRoleHoldersChangedListenerDelegate listenerDelegate = listeners.get(listener);
            if (listenerDelegate == null) {
                return;
            }
            try {
                this.mService.removeOnRoleHoldersChangedListenerAsUser(listenerDelegate, user.getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.mListeners.remove(userId);
            }
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public boolean isBypassingRoleQualification() {
        try {
            return this.mService.isBypassingRoleQualification();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.BYPASS_ROLE_QUALIFICATION")
    public void setBypassingRoleQualification(boolean bypassRoleQualification) {
        try {
            this.mService.setBypassingRoleQualification(bypassRoleQualification);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=35)
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    @FlaggedApi(value="android.permission.flags.system_server_role_controller_enabled")
    public boolean isRoleFallbackEnabled(@NonNull String roleName) {
        try {
            return this.mService.isRoleFallbackEnabledAsUser(roleName, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=35)
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    @FlaggedApi(value="android.permission.flags.system_server_role_controller_enabled")
    public void setRoleFallbackEnabled(@NonNull String roleName, boolean fallbackEnabled) {
        try {
            this.mService.setRoleFallbackEnabledAsUser(roleName, fallbackEnabled, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER")
    public void setRoleNamesFromController(@NonNull List<String> roleNames) {
        Objects.requireNonNull(roleNames, "roleNames cannot be null");
        UserHandle user = this.getContextUserIfAppropriate();
        try {
            this.mService.setRoleNamesFromControllerAsUser(roleNames, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER")
    public boolean addRoleHolderFromController(@NonNull String roleName, @NonNull String packageName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
        UserHandle user = this.getContextUserIfAppropriate();
        try {
            return this.mService.addRoleHolderFromControllerAsUser(roleName, packageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER")
    public boolean removeRoleHolderFromController(@NonNull String roleName, @NonNull String packageName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
        UserHandle user = this.getContextUserIfAppropriate();
        try {
            return this.mService.removeRoleHolderFromControllerAsUser(roleName, packageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @NonNull
    @RequiresPermission(value="com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER")
    public List<String> getHeldRolesFromController(@NonNull String packageName) {
        Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
        UserHandle user = this.getContextUserIfAppropriate();
        try {
            return this.mService.getHeldRolesFromControllerAsUser(packageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private UserHandle getContextUserIfAppropriate() {
        return CompatChanges.isChangeEnabled(303742236L) ? this.mContext.getUser() : Process.myUserHandle();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresApi(value=31)
    @Nullable
    public String getBrowserRoleHolder(int userId) {
        try {
            return this.mService.getBrowserRoleHolder(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresApi(value=31)
    @Nullable
    @RequiresPermission(value="android.permission.SET_PREFERRED_APPLICATIONS")
    public boolean setBrowserRoleHolder(@Nullable String packageName, int userId) {
        try {
            return this.mService.setBrowserRoleHolder(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresApi(value=31)
    @Nullable
    public String getSmsRoleHolder(int userId) {
        try {
            return this.mService.getSmsRoleHolder(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.permission.flags.get_emergency_role_holder_api_enabled")
    @RequiresApi(value=35)
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @Nullable
    public String getEmergencyRoleHolder(int userId) {
        try {
            return this.mService.getEmergencyRoleHolder(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void isRoleVisible(@NonNull String roleName, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        if (SdkLevel.isAtLeastV() && Flags.systemServerRoleControllerEnabled()) {
            boolean visible;
            int userId = this.getContextUserIfAppropriate().getIdentifier();
            try {
                visible = this.mService.isRoleVisibleAsUser(roleName, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            executor.execute(() -> {
                long token = Binder.clearCallingIdentity();
                try {
                    callback.accept(visible);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            });
        } else {
            this.getRoleControllerManager().isRoleVisible(roleName, executor, callback);
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void isApplicationVisibleForRole(@NonNull String roleName, @NonNull String packageName, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        if (SdkLevel.isAtLeastV() && Flags.systemServerRoleControllerEnabled()) {
            boolean visible;
            int userId = this.getContextUserIfAppropriate().getIdentifier();
            try {
                visible = this.mService.isApplicationVisibleForRoleAsUser(roleName, packageName, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            executor.execute(() -> {
                long token = Binder.clearCallingIdentity();
                try {
                    callback.accept(visible);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            });
        } else {
            this.getRoleControllerManager().isApplicationVisibleForRole(roleName, packageName, executor, callback);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.permission.flags.cross_user_role_enabled")
    @NonNull
    public List<String> getDefaultHoldersForTest(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        try {
            return this.mService.getDefaultHoldersForTestAsUser(roleName, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.permission.flags.cross_user_role_enabled")
    public void setDefaultHoldersForTest(@NonNull String roleName, @NonNull List<String> packageNames) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Objects.requireNonNull(packageNames, "packageNames cannot be null");
        try {
            this.mService.setDefaultHoldersForTestAsUser(roleName, packageNames, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.permission.flags.cross_user_role_enabled")
    public boolean isRoleVisibleForTest(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        try {
            return this.mService.isRoleVisibleForTestAsUser(roleName, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.permission.flags.cross_user_role_enabled")
    public void setRoleVisibleForTest(@NonNull String roleName, boolean visible) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        try {
            this.mService.setRoleVisibleForTestAsUser(roleName, visible, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private RoleControllerManager getRoleControllerManager() {
        Object object = this.mRoleControllerManagerLock;
        synchronized (object) {
            if (this.mRoleControllerManager == null) {
                this.mRoleControllerManager = new RoleControllerManager(this.mContext);
            }
            return this.mRoleControllerManager;
        }
    }

    private static class OnRoleHoldersChangedListenerDelegate
    extends IOnRoleHoldersChangedListener.Stub {
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final OnRoleHoldersChangedListener mListener;

        OnRoleHoldersChangedListenerDelegate(@NonNull Executor executor, @NonNull OnRoleHoldersChangedListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRoleHoldersChanged(@NonNull String roleName, int userId) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mListener.onRoleHoldersChanged(roleName, UserHandle.of(userId)));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ManageHoldersFlags {
    }
}

