/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.EnforcePermission;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.app.PendingIntent;
import android.app.usage.BroadcastResponseStatsList;
import android.app.usage.UsageEvents;
import android.app.usage.UsageEventsQuery;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.PersistableBundle;
import android.os.RemoteException;

public interface IUsageStatsManager
extends IInterface {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/usage/IUsageStatsManager.aidl:33:1:33:69")
    public ParceledListSlice queryUsageStats(int var1, long var2, long var4, String var6, int var7) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/usage/IUsageStatsManager.aidl:36:1:36:69")
    public ParceledListSlice queryConfigurationStats(int var1, long var2, long var4, String var6) throws RemoteException;

    public ParceledListSlice queryEventStats(int var1, long var2, long var4, String var6) throws RemoteException;

    public UsageEvents queryEvents(long var1, long var3, String var5) throws RemoteException;

    public UsageEvents queryEventsForPackage(long var1, long var3, String var5) throws RemoteException;

    public UsageEvents queryEventsForUser(long var1, long var3, int var5, String var6) throws RemoteException;

    public UsageEvents queryEventsForPackageForUser(long var1, long var3, int var5, String var6, String var7) throws RemoteException;

    @RequiresPermission(value="android.permission.PACKAGE_USAGE_STATS")
    public UsageEvents queryEventsWithFilter(UsageEventsQuery var1, String var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/usage/IUsageStatsManager.aidl:47:1:47:69")
    public void setAppInactive(String var1, boolean var2, int var3) throws RemoteException;

    public boolean isAppStandbyEnabled() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/usage/IUsageStatsManager.aidl:50:1:50:69")
    public boolean isAppInactive(String var1, int var2, String var3) throws RemoteException;

    public void onCarrierPrivilegedAppsChanged() throws RemoteException;

    public void reportChooserSelection(String var1, int var2, String var3, String[] var4, String var5) throws RemoteException;

    public int getAppStandbyBucket(String var1, String var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.CHANGE_APP_IDLE_STATE")
    public void setAppStandbyBucket(String var1, int var2, int var3) throws RemoteException;

    public ParceledListSlice getAppStandbyBuckets(String var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CHANGE_APP_IDLE_STATE")
    public void setAppStandbyBuckets(ParceledListSlice var1, int var2) throws RemoteException;

    public int getAppMinStandbyBucket(String var1, String var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.CHANGE_APP_LAUNCH_TIME_ESTIMATE")
    public void setEstimatedLaunchTime(String var1, long var2, int var4) throws RemoteException;

    @EnforcePermission(value="android.permission.CHANGE_APP_LAUNCH_TIME_ESTIMATE")
    public void setEstimatedLaunchTimes(ParceledListSlice var1, int var2) throws RemoteException;

    public void registerAppUsageObserver(int var1, String[] var2, long var3, PendingIntent var5, String var6) throws RemoteException;

    public void unregisterAppUsageObserver(int var1, String var2) throws RemoteException;

    public void registerUsageSessionObserver(int var1, String[] var2, long var3, long var5, PendingIntent var7, PendingIntent var8, String var9) throws RemoteException;

    public void unregisterUsageSessionObserver(int var1, String var2) throws RemoteException;

    public void registerAppUsageLimitObserver(int var1, String[] var2, long var3, long var5, PendingIntent var7, String var8) throws RemoteException;

    public void unregisterAppUsageLimitObserver(int var1, String var2) throws RemoteException;

    public void reportUsageStart(IBinder var1, String var2, String var3) throws RemoteException;

    public void reportPastUsageStart(IBinder var1, String var2, long var3, String var5) throws RemoteException;

    public void reportUsageStop(IBinder var1, String var2, String var3) throws RemoteException;

    public void reportUserInteraction(String var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.REPORT_USAGE_STATS")
    public void reportUserInteractionWithBundle(String var1, int var2, PersistableBundle var3) throws RemoteException;

    public int getUsageSource() throws RemoteException;

    public void forceUsageSourceSettingRead() throws RemoteException;

    public long getLastTimeAnyComponentUsed(String var1, String var2) throws RemoteException;

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RESPONSE_STATS")
    public BroadcastResponseStatsList queryBroadcastResponseStats(String var1, long var2, String var4, int var5) throws RemoteException;

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RESPONSE_STATS")
    public void clearBroadcastResponseStats(String var1, long var2, String var4, int var5) throws RemoteException;

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RESPONSE_STATS")
    public void clearBroadcastEvents(String var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.DUMP")
    public boolean isPackageExemptedFromBroadcastResponseStats(String var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public String getAppStandbyConstant(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUsageStatsManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.app.usage.IUsageStatsManager";
        static final int TRANSACTION_queryUsageStats = 1;
        static final int TRANSACTION_queryConfigurationStats = 2;
        static final int TRANSACTION_queryEventStats = 3;
        static final int TRANSACTION_queryEvents = 4;
        static final int TRANSACTION_queryEventsForPackage = 5;
        static final int TRANSACTION_queryEventsForUser = 6;
        static final int TRANSACTION_queryEventsForPackageForUser = 7;
        static final int TRANSACTION_queryEventsWithFilter = 8;
        static final int TRANSACTION_setAppInactive = 9;
        static final int TRANSACTION_isAppStandbyEnabled = 10;
        static final int TRANSACTION_isAppInactive = 11;
        static final int TRANSACTION_onCarrierPrivilegedAppsChanged = 12;
        static final int TRANSACTION_reportChooserSelection = 13;
        static final int TRANSACTION_getAppStandbyBucket = 14;
        static final int TRANSACTION_setAppStandbyBucket = 15;
        static final int TRANSACTION_getAppStandbyBuckets = 16;
        static final int TRANSACTION_setAppStandbyBuckets = 17;
        static final int TRANSACTION_getAppMinStandbyBucket = 18;
        static final int TRANSACTION_setEstimatedLaunchTime = 19;
        static final int TRANSACTION_setEstimatedLaunchTimes = 20;
        static final int TRANSACTION_registerAppUsageObserver = 21;
        static final int TRANSACTION_unregisterAppUsageObserver = 22;
        static final int TRANSACTION_registerUsageSessionObserver = 23;
        static final int TRANSACTION_unregisterUsageSessionObserver = 24;
        static final int TRANSACTION_registerAppUsageLimitObserver = 25;
        static final int TRANSACTION_unregisterAppUsageLimitObserver = 26;
        static final int TRANSACTION_reportUsageStart = 27;
        static final int TRANSACTION_reportPastUsageStart = 28;
        static final int TRANSACTION_reportUsageStop = 29;
        static final int TRANSACTION_reportUserInteraction = 30;
        static final int TRANSACTION_reportUserInteractionWithBundle = 31;
        static final int TRANSACTION_getUsageSource = 32;
        static final int TRANSACTION_forceUsageSourceSettingRead = 33;
        static final int TRANSACTION_getLastTimeAnyComponentUsed = 34;
        static final int TRANSACTION_queryBroadcastResponseStats = 35;
        static final int TRANSACTION_clearBroadcastResponseStats = 36;
        static final int TRANSACTION_clearBroadcastEvents = 37;
        static final int TRANSACTION_isPackageExemptedFromBroadcastResponseStats = 38;
        static final int TRANSACTION_getAppStandbyConstant = 39;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IUsageStatsManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IUsageStatsManager) {
                return (IUsageStatsManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "queryUsageStats";
                }
                case 2: {
                    return "queryConfigurationStats";
                }
                case 3: {
                    return "queryEventStats";
                }
                case 4: {
                    return "queryEvents";
                }
                case 5: {
                    return "queryEventsForPackage";
                }
                case 6: {
                    return "queryEventsForUser";
                }
                case 7: {
                    return "queryEventsForPackageForUser";
                }
                case 8: {
                    return "queryEventsWithFilter";
                }
                case 9: {
                    return "setAppInactive";
                }
                case 10: {
                    return "isAppStandbyEnabled";
                }
                case 11: {
                    return "isAppInactive";
                }
                case 12: {
                    return "onCarrierPrivilegedAppsChanged";
                }
                case 13: {
                    return "reportChooserSelection";
                }
                case 14: {
                    return "getAppStandbyBucket";
                }
                case 15: {
                    return "setAppStandbyBucket";
                }
                case 16: {
                    return "getAppStandbyBuckets";
                }
                case 17: {
                    return "setAppStandbyBuckets";
                }
                case 18: {
                    return "getAppMinStandbyBucket";
                }
                case 19: {
                    return "setEstimatedLaunchTime";
                }
                case 20: {
                    return "setEstimatedLaunchTimes";
                }
                case 21: {
                    return "registerAppUsageObserver";
                }
                case 22: {
                    return "unregisterAppUsageObserver";
                }
                case 23: {
                    return "registerUsageSessionObserver";
                }
                case 24: {
                    return "unregisterUsageSessionObserver";
                }
                case 25: {
                    return "registerAppUsageLimitObserver";
                }
                case 26: {
                    return "unregisterAppUsageLimitObserver";
                }
                case 27: {
                    return "reportUsageStart";
                }
                case 28: {
                    return "reportPastUsageStart";
                }
                case 29: {
                    return "reportUsageStop";
                }
                case 30: {
                    return "reportUserInteraction";
                }
                case 31: {
                    return "reportUserInteractionWithBundle";
                }
                case 32: {
                    return "getUsageSource";
                }
                case 33: {
                    return "forceUsageSourceSettingRead";
                }
                case 34: {
                    return "getLastTimeAnyComponentUsed";
                }
                case 35: {
                    return "queryBroadcastResponseStats";
                }
                case 36: {
                    return "clearBroadcastResponseStats";
                }
                case 37: {
                    return "clearBroadcastEvents";
                }
                case 38: {
                    return "isPackageExemptedFromBroadcastResponseStats";
                }
                case 39: {
                    return "getAppStandbyConstant";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.queryUsageStats(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.queryConfigurationStats(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.queryEventStats(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    UsageEvents _result = this.queryEvents(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    UsageEvents _result = this.queryEventsForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    UsageEvents _result = this.queryEventsForUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 7: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    UsageEvents _result = this.queryEventsForPackageForUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    UsageEventsQuery _arg0 = data.readTypedObject(UsageEventsQuery.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    UsageEvents _result = this.queryEventsWithFilter(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAppInactive(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    boolean _result = this.isAppStandbyEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAppInactive(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    this.onCarrierPrivilegedAppsChanged();
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String[] _arg3 = data.createStringArray();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.reportChooserSelection(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getAppStandbyBucket(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAppStandbyBucket(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getAppStandbyBuckets(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 17: {
                    ParceledListSlice _arg0 = data.readTypedObject(ParceledListSlice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAppStandbyBuckets(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getAppMinStandbyBucket(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setEstimatedLaunchTime(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    ParceledListSlice _arg0 = data.readTypedObject(ParceledListSlice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setEstimatedLaunchTimes(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    String[] _arg1 = data.createStringArray();
                    long _arg2 = data.readLong();
                    PendingIntent _arg3 = data.readTypedObject(PendingIntent.CREATOR);
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerAppUsageObserver(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.unregisterAppUsageObserver(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    String[] _arg1 = data.createStringArray();
                    long _arg2 = data.readLong();
                    long _arg3 = data.readLong();
                    PendingIntent _arg4 = data.readTypedObject(PendingIntent.CREATOR);
                    PendingIntent _arg5 = data.readTypedObject(PendingIntent.CREATOR);
                    String _arg6 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerUsageSessionObserver(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.unregisterUsageSessionObserver(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    String[] _arg1 = data.createStringArray();
                    long _arg2 = data.readLong();
                    long _arg3 = data.readLong();
                    PendingIntent _arg4 = data.readTypedObject(PendingIntent.CREATOR);
                    String _arg5 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerAppUsageLimitObserver(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.unregisterAppUsageLimitObserver(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.reportUsageStart(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.reportPastUsageStart(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.reportUsageStop(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportUserInteraction(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.reportUserInteractionWithBundle(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    int _result = this.getUsageSource();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 33: {
                    this.forceUsageSourceSettingRead();
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    long _result = this.getLastTimeAnyComponentUsed(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 35: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    BroadcastResponseStatsList _result = this.queryBroadcastResponseStats(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearBroadcastResponseStats(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearBroadcastEvents(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isPackageExemptedFromBroadcastResponseStats(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getAppStandbyConstant(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setAppStandbyBucket_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CHANGE_APP_IDLE_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setAppStandbyBuckets_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CHANGE_APP_IDLE_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setEstimatedLaunchTime_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CHANGE_APP_LAUNCH_TIME_ESTIMATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setEstimatedLaunchTimes_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CHANGE_APP_LAUNCH_TIME_ESTIMATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 38;
        }

        private static class Proxy
        implements IUsageStatsManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice queryUsageStats(int bucketType, long beginTime, long endTime, String callingPackage, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(bucketType);
                    _data.writeLong(beginTime);
                    _data.writeLong(endTime);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice queryConfigurationStats(int bucketType, long beginTime, long endTime, String callingPackage) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(bucketType);
                    _data.writeLong(beginTime);
                    _data.writeLong(endTime);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice queryEventStats(int bucketType, long beginTime, long endTime, String callingPackage) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(bucketType);
                    _data.writeLong(beginTime);
                    _data.writeLong(endTime);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UsageEvents queryEvents(long beginTime, long endTime, String callingPackage) throws RemoteException {
                UsageEvents _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(beginTime);
                    _data.writeLong(endTime);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(UsageEvents.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UsageEvents queryEventsForPackage(long beginTime, long endTime, String callingPackage) throws RemoteException {
                UsageEvents _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(beginTime);
                    _data.writeLong(endTime);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(UsageEvents.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UsageEvents queryEventsForUser(long beginTime, long endTime, int userId, String callingPackage) throws RemoteException {
                UsageEvents _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(beginTime);
                    _data.writeLong(endTime);
                    _data.writeInt(userId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(UsageEvents.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UsageEvents queryEventsForPackageForUser(long beginTime, long endTime, int userId, String pkg, String callingPackage) throws RemoteException {
                UsageEvents _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(beginTime);
                    _data.writeLong(endTime);
                    _data.writeInt(userId);
                    _data.writeString(pkg);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(UsageEvents.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UsageEvents queryEventsWithFilter(UsageEventsQuery query, String callingPackage) throws RemoteException {
                UsageEvents _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(query, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(UsageEvents.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAppInactive(String packageName, boolean inactive, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeBoolean(inactive);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAppStandbyEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAppInactive(String packageName, int userId, String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCarrierPrivilegedAppsChanged() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportChooserSelection(String packageName, int userId, String contentType, String[] annotations, String action) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeString(contentType);
                    _data.writeStringArray(annotations);
                    _data.writeString(action);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAppStandbyBucket(String packageName, String callingPackage, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAppStandbyBucket(String packageName, int bucket, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(bucket);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getAppStandbyBuckets(String callingPackage, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAppStandbyBuckets(ParceledListSlice appBuckets, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(appBuckets, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAppMinStandbyBucket(String packageName, String callingPackage, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEstimatedLaunchTime(String packageName, long estimatedLaunchTime, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeLong(estimatedLaunchTime);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEstimatedLaunchTimes(ParceledListSlice appLaunchTimes, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(appLaunchTimes, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAppUsageObserver(int observerId, String[] packages, long timeLimitMs, PendingIntent callback, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(observerId);
                    _data.writeStringArray(packages);
                    _data.writeLong(timeLimitMs);
                    _data.writeTypedObject(callback, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAppUsageObserver(int observerId, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(observerId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerUsageSessionObserver(int sessionObserverId, String[] observed, long timeLimitMs, long sessionThresholdTimeMs, PendingIntent limitReachedCallbackIntent, PendingIntent sessionEndCallbackIntent, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionObserverId);
                    _data.writeStringArray(observed);
                    _data.writeLong(timeLimitMs);
                    _data.writeLong(sessionThresholdTimeMs);
                    _data.writeTypedObject(limitReachedCallbackIntent, 0);
                    _data.writeTypedObject(sessionEndCallbackIntent, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterUsageSessionObserver(int sessionObserverId, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionObserverId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAppUsageLimitObserver(int observerId, String[] packages, long timeLimitMs, long timeUsedMs, PendingIntent callback, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(observerId);
                    _data.writeStringArray(packages);
                    _data.writeLong(timeLimitMs);
                    _data.writeLong(timeUsedMs);
                    _data.writeTypedObject(callback, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAppUsageLimitObserver(int observerId, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(observerId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportUsageStart(IBinder activity, String token, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(activity);
                    _data.writeString(token);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportPastUsageStart(IBinder activity, String token, long timeAgoMs, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(activity);
                    _data.writeString(token);
                    _data.writeLong(timeAgoMs);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportUsageStop(IBinder activity, String token, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(activity);
                    _data.writeString(token);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportUserInteraction(String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportUserInteractionWithBundle(String packageName, int userId, PersistableBundle eventExtras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeTypedObject(eventExtras, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getUsageSource() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceUsageSourceSettingRead() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getLastTimeAnyComponentUsed(String packageName, String callingPackage) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BroadcastResponseStatsList queryBroadcastResponseStats(String packageName, long id2, String callingPackage, int userId) throws RemoteException {
                BroadcastResponseStatsList _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeLong(id2);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BroadcastResponseStatsList.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearBroadcastResponseStats(String packageName, long id2, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeLong(id2);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearBroadcastEvents(String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPackageExemptedFromBroadcastResponseStats(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getAppStandbyConstant(String key) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IUsageStatsManager {
        @Override
        public ParceledListSlice queryUsageStats(int bucketType, long beginTime, long endTime, String callingPackage, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice queryConfigurationStats(int bucketType, long beginTime, long endTime, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice queryEventStats(int bucketType, long beginTime, long endTime, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public UsageEvents queryEvents(long beginTime, long endTime, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public UsageEvents queryEventsForPackage(long beginTime, long endTime, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public UsageEvents queryEventsForUser(long beginTime, long endTime, int userId, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public UsageEvents queryEventsForPackageForUser(long beginTime, long endTime, int userId, String pkg, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public UsageEvents queryEventsWithFilter(UsageEventsQuery query, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void setAppInactive(String packageName, boolean inactive, int userId) throws RemoteException {
        }

        @Override
        public boolean isAppStandbyEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isAppInactive(String packageName, int userId, String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public void onCarrierPrivilegedAppsChanged() throws RemoteException {
        }

        @Override
        public void reportChooserSelection(String packageName, int userId, String contentType, String[] annotations, String action) throws RemoteException {
        }

        @Override
        public int getAppStandbyBucket(String packageName, String callingPackage, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void setAppStandbyBucket(String packageName, int bucket, int userId) throws RemoteException {
        }

        @Override
        public ParceledListSlice getAppStandbyBuckets(String callingPackage, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setAppStandbyBuckets(ParceledListSlice appBuckets, int userId) throws RemoteException {
        }

        @Override
        public int getAppMinStandbyBucket(String packageName, String callingPackage, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void setEstimatedLaunchTime(String packageName, long estimatedLaunchTime, int userId) throws RemoteException {
        }

        @Override
        public void setEstimatedLaunchTimes(ParceledListSlice appLaunchTimes, int userId) throws RemoteException {
        }

        @Override
        public void registerAppUsageObserver(int observerId, String[] packages, long timeLimitMs, PendingIntent callback, String callingPackage) throws RemoteException {
        }

        @Override
        public void unregisterAppUsageObserver(int observerId, String callingPackage) throws RemoteException {
        }

        @Override
        public void registerUsageSessionObserver(int sessionObserverId, String[] observed, long timeLimitMs, long sessionThresholdTimeMs, PendingIntent limitReachedCallbackIntent, PendingIntent sessionEndCallbackIntent, String callingPackage) throws RemoteException {
        }

        @Override
        public void unregisterUsageSessionObserver(int sessionObserverId, String callingPackage) throws RemoteException {
        }

        @Override
        public void registerAppUsageLimitObserver(int observerId, String[] packages, long timeLimitMs, long timeUsedMs, PendingIntent callback, String callingPackage) throws RemoteException {
        }

        @Override
        public void unregisterAppUsageLimitObserver(int observerId, String callingPackage) throws RemoteException {
        }

        @Override
        public void reportUsageStart(IBinder activity, String token, String callingPackage) throws RemoteException {
        }

        @Override
        public void reportPastUsageStart(IBinder activity, String token, long timeAgoMs, String callingPackage) throws RemoteException {
        }

        @Override
        public void reportUsageStop(IBinder activity, String token, String callingPackage) throws RemoteException {
        }

        @Override
        public void reportUserInteraction(String packageName, int userId) throws RemoteException {
        }

        @Override
        public void reportUserInteractionWithBundle(String packageName, int userId, PersistableBundle eventExtras) throws RemoteException {
        }

        @Override
        public int getUsageSource() throws RemoteException {
            return 0;
        }

        @Override
        public void forceUsageSourceSettingRead() throws RemoteException {
        }

        @Override
        public long getLastTimeAnyComponentUsed(String packageName, String callingPackage) throws RemoteException {
            return 0L;
        }

        @Override
        public BroadcastResponseStatsList queryBroadcastResponseStats(String packageName, long id2, String callingPackage, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void clearBroadcastResponseStats(String packageName, long id2, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public void clearBroadcastEvents(String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public boolean isPackageExemptedFromBroadcastResponseStats(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public String getAppStandbyConstant(String key) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

