/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.PendingIntent;
import android.app.usage.AppLaunchEstimateInfo;
import android.app.usage.AppStandbyInfo;
import android.app.usage.BroadcastResponseStats;
import android.app.usage.ConfigurationStats;
import android.app.usage.EventStats;
import android.app.usage.IUsageStatsManager;
import android.app.usage.UsageEvents;
import android.app.usage.UsageEventsQuery;
import android.app.usage.UsageStats;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.PersistableBundle;
import android.os.PowerWhitelistManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class UsageStatsManager {
    public static final int INTERVAL_DAILY = 0;
    public static final int INTERVAL_WEEKLY = 1;
    public static final int INTERVAL_MONTHLY = 2;
    public static final int INTERVAL_YEARLY = 3;
    public static final int INTERVAL_BEST = 4;
    public static final int INTERVAL_COUNT = 4;
    @SystemApi
    public static final int STANDBY_BUCKET_EXEMPTED = 5;
    public static final int STANDBY_BUCKET_ACTIVE = 10;
    public static final int STANDBY_BUCKET_WORKING_SET = 20;
    public static final int STANDBY_BUCKET_FREQUENT = 30;
    public static final int STANDBY_BUCKET_RARE = 40;
    public static final int STANDBY_BUCKET_RESTRICTED = 45;
    @SystemApi
    public static final int STANDBY_BUCKET_NEVER = 50;
    public static final int REASON_MAIN_MASK = 65280;
    public static final int REASON_MAIN_DEFAULT = 256;
    public static final int REASON_MAIN_TIMEOUT = 512;
    public static final int REASON_MAIN_USAGE = 768;
    public static final int REASON_MAIN_FORCED_BY_USER = 1024;
    public static final int REASON_MAIN_PREDICTED = 1280;
    public static final int REASON_MAIN_FORCED_BY_SYSTEM = 1536;
    public static final int REASON_SUB_MASK = 255;
    public static final int REASON_SUB_DEFAULT_UNDEFINED = 0;
    public static final int REASON_SUB_DEFAULT_APP_UPDATE = 1;
    public static final int REASON_SUB_DEFAULT_APP_RESTORED = 2;
    public static final int REASON_SUB_USAGE_SYSTEM_INTERACTION = 1;
    public static final int REASON_SUB_USAGE_NOTIFICATION_SEEN = 2;
    public static final int REASON_SUB_USAGE_USER_INTERACTION = 3;
    public static final int REASON_SUB_USAGE_MOVE_TO_FOREGROUND = 4;
    public static final int REASON_SUB_USAGE_MOVE_TO_BACKGROUND = 5;
    public static final int REASON_SUB_USAGE_SYSTEM_UPDATE = 6;
    public static final int REASON_SUB_USAGE_ACTIVE_TIMEOUT = 7;
    public static final int REASON_SUB_USAGE_SYNC_ADAPTER = 8;
    public static final int REASON_SUB_USAGE_SLICE_PINNED = 9;
    public static final int REASON_SUB_USAGE_SLICE_PINNED_PRIV = 10;
    public static final int REASON_SUB_USAGE_EXEMPTED_SYNC_SCHEDULED_NON_DOZE = 11;
    public static final int REASON_SUB_USAGE_EXEMPTED_SYNC_SCHEDULED_DOZE = 12;
    public static final int REASON_SUB_USAGE_EXEMPTED_SYNC_START = 13;
    public static final int REASON_SUB_USAGE_UNEXEMPTED_SYNC_SCHEDULED = 14;
    public static final int REASON_SUB_USAGE_FOREGROUND_SERVICE_START = 15;
    public static final int REASON_SUB_PREDICTED_RESTORED = 1;
    public static final int REASON_SUB_FORCED_SYSTEM_FLAG_UNDEFINED = 0;
    public static final int REASON_SUB_FORCED_SYSTEM_FLAG_BACKGROUND_RESOURCE_USAGE = 1;
    public static final int REASON_SUB_FORCED_SYSTEM_FLAG_ABUSE = 2;
    public static final int REASON_SUB_FORCED_SYSTEM_FLAG_BUGGY = 4;
    public static final int REASON_SUB_FORCED_USER_FLAG_INTERACTION = 2;
    @SystemApi
    public static final String EXTRA_OBSERVER_ID = "android.app.usage.extra.OBSERVER_ID";
    @SystemApi
    public static final String EXTRA_TIME_LIMIT = "android.app.usage.extra.TIME_LIMIT";
    @SystemApi
    public static final String EXTRA_TIME_USED = "android.app.usage.extra.TIME_USED";
    @FlaggedApi(value="android.app.usage.user_interaction_type_api")
    public static final String EXTRA_EVENT_CATEGORY = "android.app.usage.extra.EVENT_CATEGORY";
    @FlaggedApi(value="android.app.usage.user_interaction_type_api")
    public static final String EXTRA_EVENT_ACTION = "android.app.usage.extra.EVENT_ACTION";
    @SystemApi
    public static final int USAGE_SOURCE_TASK_ROOT_ACTIVITY = 1;
    @SystemApi
    public static final int USAGE_SOURCE_CURRENT_ACTIVITY = 2;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private static final UsageEvents sEmptyResults = new UsageEvents();
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final Context mContext;
    @UnsupportedAppUsage
    private final IUsageStatsManager mService;

    public UsageStatsManager(Context context, IUsageStatsManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public List<UsageStats> queryUsageStats(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryUsageStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName(), this.mContext.getUserId());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public List<ConfigurationStats> queryConfigurations(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryConfigurationStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public List<EventStats> queryEventStats(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryEventStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public UsageEvents queryEvents(long beginTime, long endTime) {
        try {
            UsageEvents iter = this.mService.queryEvents(beginTime, endTime, this.mContext.getOpPackageName());
            if (iter != null) {
                return iter;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sEmptyResults;
    }

    @FlaggedApi(value="android.app.usage.filter_based_event_query_api")
    @Nullable
    @RequiresPermission(value="android.permission.PACKAGE_USAGE_STATS")
    public UsageEvents queryEvents(@NonNull UsageEventsQuery query) {
        try {
            UsageEvents iter = this.mService.queryEventsWithFilter(query, this.mContext.getOpPackageName());
            if (iter != null) {
                return iter;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sEmptyResults;
    }

    public UsageEvents queryEventsForSelf(long beginTime, long endTime) {
        try {
            UsageEvents events = this.mService.queryEventsForPackage(beginTime, endTime, this.mContext.getOpPackageName());
            if (events != null) {
                return events;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sEmptyResults;
    }

    public Map<String, UsageStats> queryAndAggregateUsageStats(long beginTime, long endTime) {
        List<UsageStats> stats = this.queryUsageStats(4, beginTime, endTime);
        if (stats.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayMap<String, UsageStats> aggregatedStats = new ArrayMap<String, UsageStats>();
        int statCount = stats.size();
        for (int i = 0; i < statCount; ++i) {
            UsageStats newStat = stats.get(i);
            UsageStats existingStat = aggregatedStats.get(newStat.getPackageName());
            if (existingStat == null) {
                aggregatedStats.put(newStat.mPackageName, newStat);
                continue;
            }
            existingStat.add(newStat);
        }
        return aggregatedStats;
    }

    public boolean isAppStandbyEnabled() {
        try {
            return this.mService.isAppStandbyEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isAppInactive(String packageName) {
        try {
            return this.mService.isAppInactive(packageName, this.mContext.getUserId(), this.mContext.getOpPackageName());
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void setAppInactive(String packageName, boolean inactive) {
        try {
            this.mService.setAppInactive(packageName, inactive, this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getAppStandbyBucket() {
        try {
            return this.mService.getAppStandbyBucket(this.mContext.getOpPackageName(), this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            return 10;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.PACKAGE_USAGE_STATS")
    public int getAppStandbyBucket(String packageName) {
        try {
            return this.mService.getAppStandbyBucket(packageName, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            return 10;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CHANGE_APP_IDLE_STATE")
    public void setAppStandbyBucket(String packageName, int bucket) {
        try {
            this.mService.setAppStandbyBucket(packageName, bucket, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.PACKAGE_USAGE_STATS")
    public Map<String, Integer> getAppStandbyBuckets() {
        try {
            ParceledListSlice slice = this.mService.getAppStandbyBuckets(this.mContext.getOpPackageName(), this.mContext.getUserId());
            List bucketList = slice.getList();
            ArrayMap<String, Integer> bucketMap = new ArrayMap<String, Integer>();
            int n = bucketList.size();
            for (int i = 0; i < n; ++i) {
                AppStandbyInfo bucketInfo = (AppStandbyInfo)bucketList.get(i);
                bucketMap.put(bucketInfo.mPackageName, bucketInfo.mStandbyBucket);
            }
            return bucketMap;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CHANGE_APP_IDLE_STATE")
    public void setAppStandbyBuckets(Map<String, Integer> appBuckets) {
        if (appBuckets == null) {
            return;
        }
        ArrayList<AppStandbyInfo> bucketInfoList = new ArrayList<AppStandbyInfo>(appBuckets.size());
        for (Map.Entry<String, Integer> bucketEntry : appBuckets.entrySet()) {
            bucketInfoList.add(new AppStandbyInfo(bucketEntry.getKey(), bucketEntry.getValue()));
        }
        ParceledListSlice slice = new ParceledListSlice(bucketInfoList);
        try {
            this.mService.setAppStandbyBuckets(slice, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.PACKAGE_USAGE_STATS")
    public int getAppMinStandbyBucket(String packageName) {
        try {
            return this.mService.getAppMinStandbyBucket(packageName, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CHANGE_APP_LAUNCH_TIME_ESTIMATE")
    public void setEstimatedLaunchTimeMillis(@NonNull String packageName, long estimatedLaunchTimeMillis) {
        if (packageName == null) {
            throw new NullPointerException("package name cannot be null");
        }
        if (estimatedLaunchTimeMillis <= 0L) {
            throw new IllegalArgumentException("estimated launch time must be positive");
        }
        try {
            this.mService.setEstimatedLaunchTime(packageName, estimatedLaunchTimeMillis, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CHANGE_APP_LAUNCH_TIME_ESTIMATE")
    public void setEstimatedLaunchTimesMillis(@NonNull Map<String, Long> estimatedLaunchTimesMillis) {
        if (estimatedLaunchTimesMillis == null) {
            throw new NullPointerException("estimatedLaunchTimesMillis cannot be null");
        }
        ArrayList<AppLaunchEstimateInfo> estimateList = new ArrayList<AppLaunchEstimateInfo>(estimatedLaunchTimesMillis.size());
        for (Map.Entry<String, Long> estimateEntry : estimatedLaunchTimesMillis.entrySet()) {
            String pkgName = estimateEntry.getKey();
            if (pkgName == null) {
                throw new NullPointerException("package name cannot be null");
            }
            Long estimatedLaunchTime = estimateEntry.getValue();
            if (estimatedLaunchTime == null || estimatedLaunchTime <= 0L) {
                throw new IllegalArgumentException("estimated launch time must be positive");
            }
            estimateList.add(new AppLaunchEstimateInfo(pkgName, estimatedLaunchTime));
        }
        ParceledListSlice slice = new ParceledListSlice(estimateList);
        try {
            this.mService.setEstimatedLaunchTimes(slice, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_APP_USAGE")
    public void registerAppUsageObserver(int observerId, @NonNull String[] observedEntities, long timeLimit, @NonNull TimeUnit timeUnit, @NonNull PendingIntent callbackIntent) {
        try {
            this.mService.registerAppUsageObserver(observerId, observedEntities, timeUnit.toMillis(timeLimit), callbackIntent, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_APP_USAGE")
    public void unregisterAppUsageObserver(int observerId) {
        try {
            this.mService.unregisterAppUsageObserver(observerId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_APP_USAGE")
    public void registerUsageSessionObserver(int sessionObserverId, @NonNull String[] observedEntities, @NonNull Duration timeLimit, @NonNull Duration sessionThresholdTime, @NonNull PendingIntent limitReachedCallbackIntent, @Nullable PendingIntent sessionEndCallbackIntent) {
        try {
            this.mService.registerUsageSessionObserver(sessionObserverId, observedEntities, timeLimit.toMillis(), sessionThresholdTime.toMillis(), limitReachedCallbackIntent, sessionEndCallbackIntent, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_APP_USAGE")
    public void unregisterUsageSessionObserver(int sessionObserverId) {
        try {
            this.mService.unregisterUsageSessionObserver(sessionObserverId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.SUSPEND_APPS", "android.permission.OBSERVE_APP_USAGE"})
    public void registerAppUsageLimitObserver(int observerId, @NonNull String[] observedEntities, @NonNull Duration timeLimit, @NonNull Duration timeUsed, @Nullable PendingIntent callbackIntent) {
        try {
            this.mService.registerAppUsageLimitObserver(observerId, observedEntities, timeLimit.toMillis(), timeUsed.toMillis(), callbackIntent, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.SUSPEND_APPS", "android.permission.OBSERVE_APP_USAGE"})
    public void unregisterAppUsageLimitObserver(int observerId) {
        try {
            this.mService.unregisterAppUsageLimitObserver(observerId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REPORT_USAGE_STATS")
    public void reportUserInteraction(@NonNull String packageName, int userId) {
        try {
            this.mService.reportUserInteraction(packageName, userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.app.usage.user_interaction_type_api")
    @RequiresPermission(value="android.permission.REPORT_USAGE_STATS")
    public void reportUserInteraction(@NonNull String packageName, int userId, @NonNull PersistableBundle extras) {
        try {
            this.mService.reportUserInteractionWithBundle(packageName, userId, extras);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void reportUsageStart(@NonNull Activity activity, @NonNull String token) {
        try {
            this.mService.reportUsageStart(activity.getActivityToken(), token, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void reportUsageStart(@NonNull Activity activity, @NonNull String token, long timeAgoMs) {
        try {
            this.mService.reportPastUsageStart(activity.getActivityToken(), token, timeAgoMs, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void reportUsageStop(@NonNull Activity activity, @NonNull String token) {
        try {
            this.mService.reportUsageStop(activity.getActivityToken(), token, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public int getUsageSource() {
        try {
            return this.mService.getUsageSource();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void forceUsageSourceSettingRead() {
        try {
            this.mService.forceUsageSourceSettingRead();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static String reasonToString(int standbyReason) {
        int subReason = standbyReason & 0xFF;
        StringBuilder sb = new StringBuilder();
        block0 : switch (standbyReason & 0xFF00) {
            case 256: {
                sb.append("d");
                switch (subReason) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        sb.append("-au");
                        break;
                    }
                    case 2: {
                        sb.append("-ar");
                    }
                }
                break;
            }
            case 1536: {
                sb.append("s");
                if (subReason <= 0) break;
                sb.append("-").append(Integer.toBinaryString(subReason));
                break;
            }
            case 1024: {
                sb.append("f");
                if (subReason <= 0) break;
                sb.append("-").append(Integer.toBinaryString(subReason));
                break;
            }
            case 1280: {
                sb.append("p");
                switch (subReason) {
                    case 1: {
                        sb.append("-r");
                    }
                }
                break;
            }
            case 512: {
                sb.append("t");
                break;
            }
            case 768: {
                sb.append("u");
                switch (subReason) {
                    case 1: {
                        sb.append("-si");
                        break block0;
                    }
                    case 2: {
                        sb.append("-ns");
                        break block0;
                    }
                    case 3: {
                        sb.append("-ui");
                        break block0;
                    }
                    case 4: {
                        sb.append("-mf");
                        break block0;
                    }
                    case 5: {
                        sb.append("-mb");
                        break block0;
                    }
                    case 6: {
                        sb.append("-su");
                        break block0;
                    }
                    case 7: {
                        sb.append("-at");
                        break block0;
                    }
                    case 8: {
                        sb.append("-sa");
                        break block0;
                    }
                    case 9: {
                        sb.append("-lp");
                        break block0;
                    }
                    case 10: {
                        sb.append("-lv");
                        break block0;
                    }
                    case 11: {
                        sb.append("-en");
                        break block0;
                    }
                    case 12: {
                        sb.append("-ed");
                        break block0;
                    }
                    case 13: {
                        sb.append("-es");
                        break block0;
                    }
                    case 14: {
                        sb.append("-uss");
                        break block0;
                    }
                    case 15: {
                        sb.append("-fss");
                    }
                }
            }
        }
        return sb.toString();
    }

    public static String usageSourceToString(int usageSource) {
        switch (usageSource) {
            case 1: {
                return "TASK_ROOT_ACTIVITY";
            }
            case 2: {
                return "CURRENT_ACTIVITY";
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("UNKNOWN(");
        sb.append(usageSource);
        sb.append(")");
        return sb.toString();
    }

    public static String standbyBucketToString(int standbyBucket) {
        switch (standbyBucket) {
            case 5: {
                return "EXEMPTED";
            }
            case 10: {
                return "ACTIVE";
            }
            case 20: {
                return "WORKING_SET";
            }
            case 30: {
                return "FREQUENT";
            }
            case 40: {
                return "RARE";
            }
            case 45: {
                return "RESTRICTED";
            }
            case 50: {
                return "NEVER";
            }
        }
        return String.valueOf(standbyBucket);
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST")
    public void whitelistAppTemporarily(String packageName, long duration, UserHandle user) {
        this.mContext.getSystemService(PowerWhitelistManager.class).whitelistAppTemporarily(packageName, duration);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BIND_CARRIER_SERVICES")
    public void onCarrierPrivilegedAppsChanged() {
        try {
            this.mService.onCarrierPrivilegedAppsChanged();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REPORT_USAGE_STATS")
    public void reportChooserSelection(String packageName, int userId, String contentType, String[] annotations, String action) {
        try {
            this.mService.reportChooserSelection(packageName, userId, contentType, annotations, action);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.PACKAGE_USAGE_STATS"})
    public long getLastTimeAnyComponentUsed(@NonNull String packageName) {
        try {
            return this.mService.getLastTimeAnyComponentUsed(packageName, this.mContext.getOpPackageName());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RESPONSE_STATS")
    @NonNull
    public List<BroadcastResponseStats> queryBroadcastResponseStats(@Nullable String packageName, long id2) {
        try {
            return this.mService.queryBroadcastResponseStats(packageName, id2, this.mContext.getOpPackageName(), this.mContext.getUserId()).getList();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RESPONSE_STATS")
    public void clearBroadcastResponseStats(@Nullable String packageName, long id2) {
        try {
            this.mService.clearBroadcastResponseStats(packageName, id2, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RESPONSE_STATS")
    public void clearBroadcastEvents() {
        try {
            this.mService.clearBroadcastEvents(this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DUMP")
    public boolean isPackageExemptedFromBroadcastResponseStats(@NonNull String packageName) {
        try {
            return this.mService.isPackageExemptedFromBroadcastResponseStats(packageName, this.mContext.getUserId());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    @Nullable
    public String getAppStandbyConstant(@NonNull String key) {
        try {
            return this.mService.getAppStandbyConstant(key);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UsageSource {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ForcedReasons {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StandbyBuckets {
    }
}

