/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Activity;
import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetProviderInfo;
import android.appwidget.PendingHostUpdate;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.IntentSender;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetHost;
import com.android.internal.appwidget.IAppWidgetService;
import java.lang.ref.WeakReference;
import java.util.List;

public class AppWidgetHost {
    private static final String TAG = "AppWidgetHost";
    static final int HANDLE_UPDATE = 1;
    static final int HANDLE_PROVIDER_CHANGED = 2;
    static final int HANDLE_PROVIDERS_CHANGED = 3;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    static final int HANDLE_VIEW_DATA_CHANGED = 4;
    static final int HANDLE_APP_WIDGET_REMOVED = 5;
    static final int HANDLE_VIEW_UPDATE_DEFERRED = 6;
    static final Object sServiceLock = new Object();
    @UnsupportedAppUsage
    static IAppWidgetService sService;
    static boolean sServiceInitialized;
    private DisplayMetrics mDisplayMetrics;
    private String mContextOpPackageName;
    @UnsupportedAppUsage
    private final Handler mHandler;
    private final int mHostId;
    private final Callbacks mCallbacks;
    private final SparseArray<AppWidgetHostListener> mListeners = new SparseArray();
    private RemoteViews.InteractionHandler mInteractionHandler;

    public AppWidgetHost(Context context, int hostId) {
        this(context, hostId, null, context.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AppWidgetHostListener getListener(int appWidgetId) {
        AppWidgetHostListener tempListener = null;
        SparseArray<AppWidgetHostListener> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            tempListener = this.mListeners.get(appWidgetId);
        }
        return tempListener;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public AppWidgetHost(Context context, int hostId, RemoteViews.InteractionHandler handler, Looper looper) {
        this.mContextOpPackageName = context.getOpPackageName();
        this.mHostId = hostId;
        this.mInteractionHandler = handler;
        this.mHandler = new UpdateHandler(looper);
        this.mCallbacks = new Callbacks(this.mHandler);
        this.mDisplayMetrics = context.getResources().getDisplayMetrics();
        AppWidgetHost.bindService(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bindService(Context context) {
        Object object = sServiceLock;
        synchronized (object) {
            if (sServiceInitialized) {
                return;
            }
            sServiceInitialized = true;
            PackageManager packageManager = context.getPackageManager();
            if (!packageManager.hasSystemFeature("android.software.app_widgets") && !context.getResources().getBoolean(17891690)) {
                return;
            }
            IBinder b = ServiceManager.getService("appwidget");
            sService = IAppWidgetService.Stub.asInterface(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        List updates;
        int i;
        int[] idsToUpdate;
        if (sService == null) {
            return;
        }
        SparseArray<AppWidgetHostListener> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            int n = this.mListeners.size();
            idsToUpdate = new int[n];
            for (i = 0; i < n; ++i) {
                idsToUpdate[i] = this.mListeners.keyAt(i);
            }
        }
        try {
            updates = sService.startListening(this.mCallbacks, this.mContextOpPackageName, this.mHostId, idsToUpdate).getList();
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        int N2 = updates.size();
        block12: for (i = 0; i < N2; ++i) {
            PendingHostUpdate update = (PendingHostUpdate)updates.get(i);
            switch (update.type) {
                case 0: {
                    this.updateAppWidgetView(update.appWidgetId, update.views);
                    continue block12;
                }
                case 1: {
                    this.onProviderChanged(update.appWidgetId, update.widgetInfo);
                    continue block12;
                }
                case 2: {
                    this.viewDataChanged(update.appWidgetId, update.viewId);
                    continue block12;
                }
                case 3: {
                    this.dispatchOnAppWidgetRemoved(update.appWidgetId);
                }
            }
        }
    }

    public void stopListening() {
        if (sService == null) {
            return;
        }
        try {
            sService.stopListening(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public int allocateAppWidgetId() {
        if (sService == null) {
            return -1;
        }
        try {
            return sService.allocateAppWidgetId(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    @Nullable
    public IntentSender getIntentSenderForConfigureActivity(int appWidgetId, int intentFlags) {
        IntentSender intentSender;
        if (sService == null) {
            return null;
        }
        try {
            intentSender = sService.createAppWidgetConfigIntentSender(this.mContextOpPackageName, appWidgetId, intentFlags);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        if (intentSender == null) {
            throw new ActivityNotFoundException();
        }
        return intentSender;
    }

    public void startAppWidgetConfigureActivityForResult(@NonNull Activity activity, int appWidgetId, int intentFlags, int requestCode, @Nullable Bundle options) {
        if (sService == null) {
            return;
        }
        try {
            IntentSender intentSender = this.getIntentSenderForConfigureActivity(appWidgetId, intentFlags);
            activity.startIntentSenderForResult(intentSender, requestCode, null, 0, 0, 0, options);
        }
        catch (IntentSender.SendIntentException e) {
            throw new ActivityNotFoundException();
        }
    }

    public void setAppWidgetHidden() {
        if (sService == null) {
            return;
        }
        try {
            sService.setAppWidgetHidden(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("System server dead?", e);
        }
    }

    public void setInteractionHandler(RemoteViews.InteractionHandler interactionHandler) {
        this.mInteractionHandler = interactionHandler;
    }

    public int[] getAppWidgetIds() {
        if (sService == null) {
            return new int[0];
        }
        try {
            return sService.getAppWidgetIdsForHost(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public void deleteAppWidgetId(int appWidgetId) {
        if (sService == null) {
            return;
        }
        this.removeListener(appWidgetId);
        try {
            sService.deleteAppWidgetId(this.mContextOpPackageName, appWidgetId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public void deleteHost() {
        if (sService == null) {
            return;
        }
        try {
            sService.deleteHost(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public static void deleteAllHosts() {
        if (sService == null) {
            return;
        }
        try {
            sService.deleteAllHosts();
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public AppWidgetHostView createView(Context context, int appWidgetId, AppWidgetProviderInfo appWidget) {
        if (sService == null) {
            return null;
        }
        AppWidgetHostView view = this.onCreateView(context, appWidgetId, appWidget);
        view.setInteractionHandler(this.mInteractionHandler);
        view.setAppWidget(appWidgetId, appWidget);
        this.setListener(appWidgetId, view);
        return view;
    }

    protected AppWidgetHostView onCreateView(Context context, int appWidgetId, AppWidgetProviderInfo appWidget) {
        return new AppWidgetHostView(context, this.mInteractionHandler);
    }

    protected void onProviderChanged(int appWidgetId, AppWidgetProviderInfo appWidget) {
        AppWidgetHostListener v = this.getListener(appWidgetId);
        appWidget.updateDimensions(this.mDisplayMetrics);
        if (v != null) {
            v.onUpdateProviderInfo(appWidget);
        }
    }

    void dispatchOnAppWidgetRemoved(int appWidgetId) {
        this.removeListener(appWidgetId);
        this.onAppWidgetRemoved(appWidgetId);
    }

    public void onAppWidgetRemoved(int appWidgetId) {
    }

    protected void onProvidersChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(int appWidgetId, @NonNull AppWidgetHostListener listener) {
        SparseArray<AppWidgetHostListener> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            this.mListeners.put(appWidgetId, listener);
        }
        RemoteViews views = null;
        try {
            views = sService.getAppWidgetViews(this.mContextOpPackageName, appWidgetId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        listener.updateAppWidget(views);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(int appWidgetId) {
        SparseArray<AppWidgetHostListener> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            this.mListeners.remove(appWidgetId);
        }
    }

    void updateAppWidgetView(int appWidgetId, RemoteViews views) {
        AppWidgetHostListener v = this.getListener(appWidgetId);
        if (v != null) {
            v.updateAppWidget(views);
        }
    }

    void viewDataChanged(int appWidgetId, int viewId) {
        AppWidgetHostListener v = this.getListener(appWidgetId);
        if (v != null) {
            v.onViewDataChanged(viewId);
        }
    }

    private void updateAppWidgetDeferred(int appWidgetId) {
        AppWidgetHostListener v = this.getListener(appWidgetId);
        if (v == null) {
            Log.e(TAG, "updateAppWidgetDeferred: null listener for id: " + appWidgetId);
            return;
        }
        v.updateAppWidgetDeferred(this.mContextOpPackageName, appWidgetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearViews() {
        SparseArray<AppWidgetHostListener> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            this.mListeners.clear();
        }
    }

    static {
        sServiceInitialized = false;
    }

    public static interface AppWidgetHostListener {
        public void onUpdateProviderInfo(@Nullable AppWidgetProviderInfo var1);

        public void updateAppWidget(@Nullable RemoteViews var1);

        default public void updateAppWidgetDeferred(String packageName, int appWidgetId) {
            RemoteViews latestViews = null;
            try {
                latestViews = sService.getAppWidgetViews(packageName, appWidgetId);
            }
            catch (Exception e) {
                Log.e(AppWidgetHost.TAG, "updateAppWidgetDeferred: ", e);
            }
            this.updateAppWidget(latestViews);
        }

        public void onViewDataChanged(int var1);
    }

    class UpdateHandler
    extends Handler {
        public UpdateHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AppWidgetHost.this.updateAppWidgetView(msg.arg1, (RemoteViews)msg.obj);
                    break;
                }
                case 5: {
                    AppWidgetHost.this.dispatchOnAppWidgetRemoved(msg.arg1);
                    break;
                }
                case 2: {
                    AppWidgetHost.this.onProviderChanged(msg.arg1, (AppWidgetProviderInfo)msg.obj);
                    break;
                }
                case 3: {
                    AppWidgetHost.this.onProvidersChanged();
                    break;
                }
                case 4: {
                    AppWidgetHost.this.viewDataChanged(msg.arg1, msg.arg2);
                    break;
                }
                case 6: {
                    AppWidgetHost.this.updateAppWidgetDeferred(msg.arg1);
                }
            }
        }
    }

    static class Callbacks
    extends IAppWidgetHost.Stub {
        private final WeakReference<Handler> mWeakHandler;

        public Callbacks(Handler handler) {
            this.mWeakHandler = new WeakReference<Handler>(handler);
        }

        @Override
        public void updateAppWidget(int appWidgetId, RemoteViews views) {
            Handler handler;
            if (Callbacks.isLocalBinder() && views != null) {
                views = views.clone();
            }
            if ((handler = (Handler)this.mWeakHandler.get()) == null) {
                return;
            }
            Message msg = handler.obtainMessage(1, appWidgetId, 0, views);
            msg.sendToTarget();
        }

        @Override
        public void providerChanged(int appWidgetId, AppWidgetProviderInfo info) {
            Handler handler;
            if (Callbacks.isLocalBinder() && info != null) {
                info = info.clone();
            }
            if ((handler = (Handler)this.mWeakHandler.get()) == null) {
                return;
            }
            Message msg = handler.obtainMessage(2, appWidgetId, 0, info);
            msg.sendToTarget();
        }

        @Override
        public void appWidgetRemoved(int appWidgetId) {
            Handler handler = (Handler)this.mWeakHandler.get();
            if (handler == null) {
                return;
            }
            handler.obtainMessage(5, appWidgetId, 0).sendToTarget();
        }

        @Override
        public void providersChanged() {
            Handler handler = (Handler)this.mWeakHandler.get();
            if (handler == null) {
                return;
            }
            handler.obtainMessage(3).sendToTarget();
        }

        @Override
        public void viewDataChanged(int appWidgetId, int viewId) {
            Handler handler = (Handler)this.mWeakHandler.get();
            if (handler == null) {
                return;
            }
            Message msg = handler.obtainMessage(4, appWidgetId, viewId);
            msg.sendToTarget();
        }

        @Override
        public void updateAppWidgetDeferred(int appWidgetId) {
            Handler handler = (Handler)this.mWeakHandler.get();
            if (handler == null) {
                return;
            }
            Message msg = handler.obtainMessage(6, appWidgetId, 0, null);
            msg.sendToTarget();
        }

        private static boolean isLocalBinder() {
            return Process.myPid() == Binder.getCallingPid();
        }
    }
}

