/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.IServiceConnection;
import android.app.PendingIntent;
import android.appwidget.AppWidgetProvider;
import android.appwidget.AppWidgetProviderInfo;
import android.appwidget.flags.Flags;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ParceledListSlice;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetService;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.FunctionalUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class AppWidgetManager {
    public static final String ACTION_APPWIDGET_PICK = "android.appwidget.action.APPWIDGET_PICK";
    public static final String ACTION_KEYGUARD_APPWIDGET_PICK = "android.appwidget.action.KEYGUARD_APPWIDGET_PICK";
    public static final String ACTION_APPWIDGET_BIND = "android.appwidget.action.APPWIDGET_BIND";
    public static final String ACTION_APPWIDGET_CONFIGURE = "android.appwidget.action.APPWIDGET_CONFIGURE";
    public static final String EXTRA_APPWIDGET_ID = "appWidgetId";
    public static final String OPTION_APPWIDGET_RESTORE_COMPLETED = "appWidgetRestoreCompleted";
    public static final String OPTION_APPWIDGET_MIN_WIDTH = "appWidgetMinWidth";
    public static final String OPTION_APPWIDGET_MIN_HEIGHT = "appWidgetMinHeight";
    public static final String OPTION_APPWIDGET_MAX_WIDTH = "appWidgetMaxWidth";
    public static final String OPTION_APPWIDGET_MAX_HEIGHT = "appWidgetMaxHeight";
    public static final String OPTION_APPWIDGET_SIZES = "appWidgetSizes";
    public static final String OPTION_APPWIDGET_HOST_CATEGORY = "appWidgetCategory";
    public static final String EXTRA_APPWIDGET_OPTIONS = "appWidgetOptions";
    public static final String EXTRA_APPWIDGET_IDS = "appWidgetIds";
    public static final String EXTRA_APPWIDGET_PROVIDER = "appWidgetProvider";
    public static final String EXTRA_APPWIDGET_PROVIDER_PROFILE = "appWidgetProviderProfile";
    public static final String EXTRA_CUSTOM_INFO = "customInfo";
    public static final String EXTRA_HOST_ID = "hostId";
    public static final String EXTRA_CUSTOM_EXTRAS = "customExtras";
    public static final String EXTRA_CATEGORY_FILTER = "categoryFilter";
    public static final String EXTRA_CUSTOM_SORT = "customSort";
    public static final int INVALID_APPWIDGET_ID = 0;
    public static final String ACTION_APPWIDGET_UPDATE = "android.appwidget.action.APPWIDGET_UPDATE";
    public static final String ACTION_APPWIDGET_ENABLE_AND_UPDATE = "android.appwidget.action.APPWIDGET_ENABLE_AND_UPDATE";
    public static final String ACTION_APPWIDGET_OPTIONS_CHANGED = "android.appwidget.action.APPWIDGET_UPDATE_OPTIONS";
    public static final String ACTION_APPWIDGET_DELETED = "android.appwidget.action.APPWIDGET_DELETED";
    public static final String ACTION_APPWIDGET_DISABLED = "android.appwidget.action.APPWIDGET_DISABLED";
    public static final String ACTION_APPWIDGET_ENABLED = "android.appwidget.action.APPWIDGET_ENABLED";
    public static final String ACTION_APPWIDGET_RESTORED = "android.appwidget.action.APPWIDGET_RESTORED";
    public static final String ACTION_APPWIDGET_HOST_RESTORED = "android.appwidget.action.APPWIDGET_HOST_RESTORED";
    @FlaggedApi(value="android.appwidget.flags.engagement_metrics")
    public static final String EVENT_TYPE_WIDGET_INTERACTION = "widget_interaction";
    @FlaggedApi(value="android.appwidget.flags.engagement_metrics")
    public static final String EVENT_CATEGORY_APPWIDGET = "android.appwidget";
    @FlaggedApi(value="android.appwidget.flags.engagement_metrics")
    public static final String EXTRA_EVENT_CLICKED_VIEWS = "android.appwidget.extra.EVENT_CLICKED_VIEWS";
    @FlaggedApi(value="android.appwidget.flags.engagement_metrics")
    public static final String EXTRA_EVENT_SCROLLED_VIEWS = "android.appwidget.extra.EVENT_SCROLLED_VIEWS";
    @FlaggedApi(value="android.appwidget.flags.engagement_metrics")
    public static final String EXTRA_EVENT_DURATION_MS = "android.appwidget.extra.EVENT_DURATION_MS";
    @FlaggedApi(value="android.appwidget.flags.engagement_metrics")
    public static final String EXTRA_EVENT_POSITION_RECT = "android.appwidget.extra.EVENT_POSITION_RECT";
    private static final String TAG = "AppWidgetManager";
    private static Executor sUpdateExecutor;
    public static final String EXTRA_APPWIDGET_OLD_IDS = "appWidgetOldIds";
    public static final String EXTRA_APPWIDGET_PREVIEW = "appWidgetPreview";
    public static final String META_DATA_APPWIDGET_PROVIDER = "android.appwidget.provider";
    private final Context mContext;
    private final String mPackageName;
    @UnsupportedAppUsage
    private final IAppWidgetService mService;
    private final DisplayMetrics mDisplayMetrics;
    private int mMaxBitmapMemory = 0;
    private boolean mHasPostedLegacyLists = false;
    @NonNull
    private ServiceCollectionCache mServiceCollectionCache;

    public static AppWidgetManager getInstance(Context context) {
        return (AppWidgetManager)context.getSystemService("appwidget");
    }

    public AppWidgetManager(Context context, IAppWidgetService service) {
        this.mContext = context;
        this.mPackageName = context.getOpPackageName();
        this.mService = service;
        this.mDisplayMetrics = context.getResources().getDisplayMetrics();
        this.mServiceCollectionCache = new ServiceCollectionCache(context, 5000L);
        if (this.mService == null) {
            return;
        }
        try {
            this.mMaxBitmapMemory = (int)((double)this.mService.getMaxBitmapMemory() * 0.9);
        }
        catch (Exception e) {
            Log.e(TAG, "Error setting the maximum bitmap memory", e);
        }
        BackgroundThread.getExecutor().execute(() -> {
            try {
                this.mService.notifyProviderInheritance((ComponentName[])this.getInstalledProvidersForPackage(this.mPackageName, null).stream().filter(Objects::nonNull).map(info -> info.provider).filter(p -> {
                    try {
                        Class<?> clazz = Class.forName(p.getClassName());
                        return AppWidgetProvider.class.isAssignableFrom(clazz);
                    }
                    catch (Exception e) {
                        return false;
                    }
                }).toArray(ComponentName[]::new));
            }
            catch (Exception e) {
                Log.e(TAG, "Notify service of inheritance info", e);
            }
        });
    }

    private void tryAdapterConversion(FunctionalUtils.RemoteExceptionIgnoringConsumer<RemoteViews> action, RemoteViews original, String failureMsg) {
        if (Flags.remoteAdapterConversion() && (this.mHasPostedLegacyLists = this.mHasPostedLegacyLists || original != null && original.hasLegacyLists())) {
            RemoteViews viewsCopy = new RemoteViews(original);
            Runnable updateWidgetWithTask = () -> {
                try {
                    viewsCopy.collectAllIntents(this.mMaxBitmapMemory, this.mServiceCollectionCache).get();
                    action.acceptOrThrow(viewsCopy);
                }
                catch (Exception e) {
                    Log.e(TAG, failureMsg, e);
                }
            };
            if (Looper.getMainLooper() == Looper.myLooper()) {
                AppWidgetManager.createUpdateExecutorIfNull().execute(updateWidgetWithTask);
                return;
            }
            updateWidgetWithTask.run();
        } else {
            try {
                action.acceptOrThrow(original);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public void updateAppWidget(int[] appWidgetIds, RemoteViews views) {
        if (this.mService == null) {
            return;
        }
        this.tryAdapterConversion(view -> this.mService.updateAppWidgetIds(this.mPackageName, appWidgetIds, (RemoteViews)view), views, "Error updating app widget views in background");
    }

    public void updateAppWidgetOptions(int appWidgetId, Bundle options) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.updateAppWidgetOptions(this.mPackageName, appWidgetId, options);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Bundle getAppWidgetOptions(int appWidgetId) {
        if (this.mService == null) {
            return Bundle.EMPTY;
        }
        try {
            return this.mService.getAppWidgetOptions(this.mPackageName, appWidgetId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updateAppWidget(int appWidgetId, RemoteViews views) {
        if (this.mService == null) {
            return;
        }
        this.updateAppWidget(new int[]{appWidgetId}, views);
    }

    public void partiallyUpdateAppWidget(int[] appWidgetIds, RemoteViews views) {
        if (this.mService == null) {
            return;
        }
        this.tryAdapterConversion(view -> this.mService.partiallyUpdateAppWidgetIds(this.mPackageName, appWidgetIds, (RemoteViews)view), views, "Error partially updating app widget views in background");
    }

    public void partiallyUpdateAppWidget(int appWidgetId, RemoteViews views) {
        if (this.mService == null) {
            return;
        }
        this.partiallyUpdateAppWidget(new int[]{appWidgetId}, views);
    }

    public void updateAppWidget(ComponentName provider, RemoteViews views) {
        if (this.mService == null) {
            return;
        }
        this.tryAdapterConversion(view -> this.mService.updateAppWidgetProvider(provider, (RemoteViews)view), views, "Error updating app widget view using provider in background");
    }

    public void updateAppWidgetProviderInfo(ComponentName provider, @Nullable String metaDataKey) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.updateAppWidgetProviderInfo(provider, metaDataKey);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void notifyAppWidgetViewDataChanged(int[] appWidgetIds, int viewId) {
        if (this.mService == null) {
            return;
        }
        if (Flags.remoteAdapterConversion()) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                this.mHasPostedLegacyLists = true;
                AppWidgetManager.createUpdateExecutorIfNull().execute(() -> this.notifyCollectionWidgetChange(appWidgetIds, viewId));
            } else {
                this.notifyCollectionWidgetChange(appWidgetIds, viewId);
            }
        } else {
            try {
                this.mService.notifyAppWidgetViewDataChanged(this.mPackageName, appWidgetIds, viewId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    private void notifyCollectionWidgetChange(int[] appWidgetIds, int viewId) {
        try {
            ArrayList<CompletableFuture<Void>> updateFutures = new ArrayList<CompletableFuture<Void>>();
            for (int i = 0; i < appWidgetIds.length; ++i) {
                int widgetId = appWidgetIds[i];
                updateFutures.add(CompletableFuture.runAsync(() -> {
                    try {
                        RemoteViews views = this.mService.getAppWidgetViews(this.mPackageName, widgetId);
                        if (views.replaceRemoteCollections(viewId)) {
                            this.updateAppWidget(widgetId, views);
                        }
                    }
                    catch (Exception e) {
                        Log.e(TAG, "Error notifying changes in RemoteViews", e);
                    }
                }));
            }
            CompletableFuture.allOf((CompletableFuture[])updateFutures.toArray(CompletableFuture[]::new)).join();
        }
        catch (Exception e) {
            Log.e(TAG, "Error notifying changes for all widgets", e);
        }
    }

    @Deprecated
    public void notifyAppWidgetViewDataChanged(int appWidgetId, int viewId) {
        if (this.mService == null) {
            return;
        }
        this.notifyAppWidgetViewDataChanged(new int[]{appWidgetId}, viewId);
    }

    @NonNull
    public List<AppWidgetProviderInfo> getInstalledProvidersForProfile(@Nullable UserHandle profile) {
        if (this.mService == null) {
            return Collections.emptyList();
        }
        return this.getInstalledProvidersForProfile(1, profile, null);
    }

    @NonNull
    public List<AppWidgetProviderInfo> getInstalledProvidersForPackage(@NonNull String packageName, @Nullable UserHandle profile) {
        if (packageName == null) {
            throw new NullPointerException("A non-null package must be passed to this method. If you want all widgets regardless of package, see getInstalledProvidersForProfile(UserHandle)");
        }
        if (this.mService == null) {
            return Collections.emptyList();
        }
        return this.getInstalledProvidersForProfile(1, profile, packageName);
    }

    public List<AppWidgetProviderInfo> getInstalledProviders() {
        if (this.mService == null) {
            return Collections.emptyList();
        }
        return this.getInstalledProvidersForProfile(1, null, null);
    }

    @UnsupportedAppUsage
    public List<AppWidgetProviderInfo> getInstalledProviders(int categoryFilter) {
        if (this.mService == null) {
            return Collections.emptyList();
        }
        return this.getInstalledProvidersForProfile(categoryFilter, null, null);
    }

    @UnsupportedAppUsage
    public List<AppWidgetProviderInfo> getInstalledProvidersForProfile(int categoryFilter, @Nullable UserHandle profile, @Nullable String packageName) {
        if (this.mService == null) {
            return Collections.emptyList();
        }
        if (profile == null) {
            profile = this.mContext.getUser();
        }
        try {
            ParceledListSlice providers = this.mService.getInstalledProvidersForProfile(categoryFilter, profile.getIdentifier(), packageName);
            if (providers == null) {
                return Collections.emptyList();
            }
            for (AppWidgetProviderInfo info : providers.getList()) {
                info.updateDimensions(this.mDisplayMetrics);
            }
            return providers.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public AppWidgetProviderInfo getAppWidgetInfo(int appWidgetId) {
        if (this.mService == null) {
            Log.e(TAG, "Service wasn't initialized, appWidgetId=" + appWidgetId);
            return null;
        }
        try {
            AppWidgetProviderInfo info = this.mService.getAppWidgetInfo(this.mPackageName, appWidgetId);
            if (info != null) {
                info.updateDimensions(this.mDisplayMetrics);
            } else {
                Log.e(TAG, "App widget provider info is null. PackageName=" + this.mPackageName + " appWidgetId-" + appWidgetId);
            }
            return info;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void bindAppWidgetId(int appWidgetId, ComponentName provider) {
        if (this.mService == null) {
            return;
        }
        this.bindAppWidgetId(appWidgetId, provider, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void bindAppWidgetId(int appWidgetId, ComponentName provider, Bundle options) {
        if (this.mService == null) {
            return;
        }
        this.bindAppWidgetIdIfAllowed(appWidgetId, this.mContext.getUser(), provider, options);
    }

    public boolean bindAppWidgetIdIfAllowed(int appWidgetId, ComponentName provider) {
        if (this.mService == null) {
            return false;
        }
        return this.bindAppWidgetIdIfAllowed(appWidgetId, this.mContext.getUserId(), provider, null);
    }

    public boolean bindAppWidgetIdIfAllowed(int appWidgetId, ComponentName provider, Bundle options) {
        if (this.mService == null) {
            return false;
        }
        return this.bindAppWidgetIdIfAllowed(appWidgetId, this.mContext.getUserId(), provider, options);
    }

    public boolean bindAppWidgetIdIfAllowed(int appWidgetId, UserHandle user, ComponentName provider, Bundle options) {
        if (this.mService == null) {
            return false;
        }
        return this.bindAppWidgetIdIfAllowed(appWidgetId, user.getIdentifier(), provider, options);
    }

    public boolean hasBindAppWidgetPermission(String packageName, int userId) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.hasBindAppWidgetPermission(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasBindAppWidgetPermission(String packageName) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.hasBindAppWidgetPermission(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setBindAppWidgetPermission(String packageName, boolean permission2) {
        if (this.mService == null) {
            return;
        }
        this.setBindAppWidgetPermission(packageName, this.mContext.getUserId(), permission2);
    }

    public void setBindAppWidgetPermission(@NonNull String packageName, int userId, boolean permission2) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setBindAppWidgetPermission(packageName, userId, permission2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean bindRemoteViewsService(Context context, int appWidgetId, Intent intent, IServiceConnection connection, int flags) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.bindRemoteViewsService(context.getOpPackageName(), appWidgetId, intent, context.getIApplicationThread(), context.getActivityToken(), connection, Integer.toUnsignedLong(flags));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int[] getAppWidgetIds(ComponentName provider) {
        if (this.mService == null) {
            return new int[0];
        }
        try {
            return this.mService.getAppWidgetIds(provider);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isBoundWidgetPackage(String packageName, int userId) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isBoundWidgetPackage(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    private boolean bindAppWidgetIdIfAllowed(int appWidgetId, int profileId, ComponentName provider, Bundle options) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.bindAppWidgetId(this.mPackageName, appWidgetId, profileId, provider, options);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isRequestPinAppWidgetSupported() {
        try {
            return this.mService.isRequestPinAppWidgetSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean requestPinAppWidget(@NonNull ComponentName provider, @Nullable PendingIntent successCallback) {
        return this.requestPinAppWidget(provider, null, successCallback);
    }

    public boolean requestPinAppWidget(@NonNull ComponentName provider, @Nullable Bundle extras, @Nullable PendingIntent successCallback) {
        try {
            return this.mService.requestPinAppWidget(this.mPackageName, provider, extras, successCallback == null ? null : successCallback.getIntentSender());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void noteAppWidgetTapped(int appWidgetId) {
        try {
            this.mService.noteAppWidgetTapped(this.mPackageName, appWidgetId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.appwidget.flags.generated_previews")
    public boolean setWidgetPreview(@NonNull ComponentName provider, int widgetCategories, @NonNull RemoteViews preview) {
        try {
            return this.mService.setWidgetPreview(provider, widgetCategories, preview);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    @FlaggedApi(value="android.appwidget.flags.generated_previews")
    public RemoteViews getWidgetPreview(@NonNull ComponentName provider, @Nullable UserHandle profile, int widgetCategory) {
        try {
            if (profile == null) {
                profile = this.mContext.getUser();
            }
            return this.mService.getWidgetPreview(this.mPackageName, provider, profile.getIdentifier(), widgetCategory);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.appwidget.flags.generated_previews")
    public void removeWidgetPreview(@NonNull ComponentName provider, int widgetCategories) {
        try {
            this.mService.removeWidgetPreview(provider, widgetCategories);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.appwidget.flags.engagement_metrics")
    @NonNull
    public static PersistableBundle createWidgetInteractionEvent(int appWidgetId, long durationMs, @Nullable Rect position, @Nullable int[] clickedIds, @Nullable int[] scrolledIds) {
        PersistableBundle extras = new PersistableBundle();
        extras.putString("android.app.usage.extra.EVENT_ACTION", EVENT_TYPE_WIDGET_INTERACTION);
        extras.putString("android.app.usage.extra.EVENT_CATEGORY", EVENT_CATEGORY_APPWIDGET);
        extras.putInt(EXTRA_APPWIDGET_ID, appWidgetId);
        extras.putLong(EXTRA_EVENT_DURATION_MS, durationMs);
        if (position != null) {
            extras.putIntArray(EXTRA_EVENT_POSITION_RECT, new int[]{position.left, position.top, position.right, position.bottom});
        }
        if (clickedIds != null && clickedIds.length > 0) {
            extras.putIntArray(EXTRA_EVENT_CLICKED_VIEWS, clickedIds);
        }
        if (scrolledIds != null && scrolledIds.length > 0) {
            extras.putIntArray(EXTRA_EVENT_SCROLLED_VIEWS, scrolledIds);
        }
        return extras;
    }

    @NonNull
    private static Executor createUpdateExecutorIfNull() {
        if (sUpdateExecutor == null) {
            sUpdateExecutor = new HandlerExecutor(AppWidgetManager.createAndStartNewHandler("widget_manager_update_helper_thread", -2));
        }
        return sUpdateExecutor;
    }

    @NonNull
    private static Handler createAndStartNewHandler(@NonNull String name, int priority) {
        HandlerThread thread = new HandlerThread(name, priority);
        thread.start();
        return thread.getThreadHandler();
    }

    public static class ServiceCollectionCache {
        private final Context mContext;
        private final Handler mHandler;
        private final long mTimeOut;
        private final Map<Intent.FilterComparison, ConnectionTask> mActiveConnections = new ArrayMap<Intent.FilterComparison, ConnectionTask>();

        public ServiceCollectionCache(Context context, long timeOut) {
            this.mContext = context;
            this.mHandler = new Handler(BackgroundThread.getHandler().getLooper());
            this.mTimeOut = timeOut;
        }

        public void connectAndConsume(Intent intent, Consumer<IBinder> task, Executor executor) {
            this.mHandler.post(() -> this.connectAndConsumeInner(intent, task, executor));
        }

        private void connectAndConsumeInner(Intent intent, Consumer<IBinder> task, Executor executor) {
            ConnectionTask activeConnection = this.mActiveConnections.computeIfAbsent(new Intent.FilterComparison(intent), x$0 -> new ConnectionTask((Intent.FilterComparison)x$0));
            activeConnection.add(task, executor);
        }

        private class ConnectionTask
        implements ServiceConnection {
            private final Runnable mDestroyAfterTimeout = this::onDestroyTimeout;
            private final ArrayDeque<Pair<Consumer<IBinder>, Executor>> mTaskQueue = new ArrayDeque();
            private boolean mOnDestroyTimeout = false;
            private IBinder mIBinder;

            ConnectionTask(Intent.FilterComparison filter) {
                try {
                    ServiceCollectionCache.this.mContext.bindService(filter.getIntent(), Context.BindServiceFlags.of(1L), ServiceCollectionCache.this.mHandler::post, (ServiceConnection)this);
                }
                catch (Exception e) {
                    Log.e(AppWidgetManager.TAG, "Error connecting to service in connection cache", e);
                }
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                this.mIBinder = iBinder;
                ServiceCollectionCache.this.mHandler.post(this::handleNext);
            }

            @Override
            public void onNullBinding(ComponentName name) {
                this.onServiceConnected(name, new Binder());
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
            }

            void add(Consumer<IBinder> task, Executor executor) {
                this.mTaskQueue.add(Pair.create(task, executor));
                if (this.mOnDestroyTimeout) {
                    this.handleNext();
                }
            }

            private void handleNext() {
                ServiceCollectionCache.this.mHandler.removeCallbacks(this.mDestroyAfterTimeout);
                Pair<Consumer<IBinder>, Executor> next = this.mTaskQueue.pollFirst();
                if (next != null) {
                    this.mOnDestroyTimeout = false;
                    ((Executor)next.second).execute(() -> {
                        ((Consumer)next.first).accept(this.mIBinder);
                        ServiceCollectionCache.this.mHandler.post(this::handleNext);
                    });
                } else {
                    this.mOnDestroyTimeout = true;
                    ServiceCollectionCache.this.mHandler.postDelayed(this.mDestroyAfterTimeout, ServiceCollectionCache.this.mTimeOut);
                }
            }

            private void onDestroyTimeout() {
                if (!this.mTaskQueue.isEmpty()) {
                    this.handleNext();
                    return;
                }
                try {
                    ServiceCollectionCache.this.mContext.unbindService(this);
                }
                catch (Exception e) {
                    Log.e(AppWidgetManager.TAG, "Error unbinding the cached connection", e);
                }
                ServiceCollectionCache.this.mActiveConnections.values().remove(this);
            }
        }
    }
}

