/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.NonNull;
import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothGattServerCallback;
import android.content.AttributionSource;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BluetoothGattServer
implements BluetoothProfile {
    private static final String TAG = BluetoothGattServer.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final IBluetoothGatt mService;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private BluetoothGattServerCallback mCallback;
    private final Object mServerIfLock = new Object();
    private int mServerIf;
    private final int mTransport;
    private BluetoothGattService mPendingService;
    private final List<BluetoothGattService> mServices;
    private static final int CALLBACK_REG_TIMEOUT = 10000;
    private static final int GATT_MAX_ATTR_LEN = 512;
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothGattServerCallback mBluetoothGattServerCallback = new IBluetoothGattServerCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServerRegistered(int status, int serverIf) {
            Log.d(TAG, "onServerRegistered() - status=" + status + " serverIf=" + serverIf);
            Object object = BluetoothGattServer.this.mServerIfLock;
            synchronized (object) {
                if (BluetoothGattServer.this.mCallback != null) {
                    BluetoothGattServer.this.mServerIf = serverIf;
                    BluetoothGattServer.this.mServerIfLock.notify();
                } else {
                    Log.e(TAG, "onServerRegistered: mCallback is null");
                }
            }
        }

        @Override
        public void onServerConnectionState(int status, int serverIf, boolean connected, String address) {
            Log.d(TAG, "onServerConnectionState() - status=" + status + " serverIf=" + serverIf + " connected=" + connected + " device=" + BluetoothUtils.toAnonymizedAddress(address));
            try {
                BluetoothGattServer.this.mCallback.onConnectionStateChange(BluetoothGattServer.this.mAdapter.getRemoteDevice(address), status, connected ? 2 : 0);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onServiceAdded(int status, BluetoothGattService service) {
            Log.d(TAG, "onServiceAdded() - handle=" + service.getInstanceId() + " uuid=" + service.getUuid() + " status=" + status);
            if (BluetoothGattServer.this.mPendingService == null) {
                return;
            }
            BluetoothGattService tmp = BluetoothGattServer.this.mPendingService;
            BluetoothGattServer.this.mPendingService = null;
            tmp.setInstanceId(service.getInstanceId());
            List<BluetoothGattCharacteristic> temp_chars = tmp.getCharacteristics();
            List<BluetoothGattCharacteristic> svc_chars = service.getCharacteristics();
            for (int i = 0; i < svc_chars.size(); ++i) {
                BluetoothGattCharacteristic temp_char = temp_chars.get(i);
                BluetoothGattCharacteristic svc_char = svc_chars.get(i);
                temp_char.setInstanceId(svc_char.getInstanceId());
                List<BluetoothGattDescriptor> temp_descs = temp_char.getDescriptors();
                List<BluetoothGattDescriptor> svc_descs = svc_char.getDescriptors();
                for (int j = 0; j < svc_descs.size(); ++j) {
                    temp_descs.get(j).setInstanceId(svc_descs.get(j).getInstanceId());
                }
            }
            BluetoothGattServer.this.mServices.add(tmp);
            try {
                BluetoothGattServer.this.mCallback.onServiceAdded(status, tmp);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onCharacteristicReadRequest(String address, int transId, int offset, boolean isLong, int handle) {
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            BluetoothGattCharacteristic characteristic = BluetoothGattServer.this.getCharacteristicByHandle(handle);
            if (characteristic == null) {
                Log.w(TAG, "onCharacteristicReadRequest() no char for handle " + handle);
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onCharacteristicReadRequest(device, transId, offset, characteristic);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onDescriptorReadRequest(String address, int transId, int offset, boolean isLong, int handle) {
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            BluetoothGattDescriptor descriptor = BluetoothGattServer.this.getDescriptorByHandle(handle);
            if (descriptor == null) {
                Log.w(TAG, "onDescriptorReadRequest() no desc for handle " + handle);
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onDescriptorReadRequest(device, transId, offset, descriptor);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onCharacteristicWriteRequest(String address, int transId, int offset, int length, boolean isPrep, boolean needRsp, int handle, byte[] value) {
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            BluetoothGattCharacteristic characteristic = BluetoothGattServer.this.getCharacteristicByHandle(handle);
            if (characteristic == null) {
                Log.w(TAG, "onCharacteristicWriteRequest() no char for handle " + handle);
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onCharacteristicWriteRequest(device, transId, characteristic, isPrep, needRsp, offset, value);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onDescriptorWriteRequest(String address, int transId, int offset, int length, boolean isPrep, boolean needRsp, int handle, byte[] value) {
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            BluetoothGattDescriptor descriptor = BluetoothGattServer.this.getDescriptorByHandle(handle);
            if (descriptor == null) {
                Log.w(TAG, "onDescriptorWriteRequest() no desc for handle " + handle);
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onDescriptorWriteRequest(device, transId, descriptor, isPrep, needRsp, offset, value);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onExecuteWrite(String address, int transId, boolean execWrite) {
            Log.d(TAG, "onExecuteWrite() - device=" + BluetoothUtils.toAnonymizedAddress(address) + ", transId=" + transId + "execWrite=" + execWrite);
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onExecuteWrite(device, transId, execWrite);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onNotificationSent(String address, int status) {
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onNotificationSent(device, status);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception: " + ex);
            }
        }

        @Override
        public void onMtuChanged(String address, int mtu) {
            Log.d(TAG, "onMtuChanged() - device=" + BluetoothUtils.toAnonymizedAddress(address) + ", mtu=" + mtu);
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onMtuChanged(device, mtu);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception: " + ex);
            }
        }

        @Override
        public void onPhyUpdate(String address, int txPhy, int rxPhy, int status) {
            Log.d(TAG, "onPhyUpdate() - device=" + BluetoothUtils.toAnonymizedAddress(address) + ", txPHy=" + txPhy + ", rxPHy=" + rxPhy);
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onPhyUpdate(device, txPhy, rxPhy, status);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception: " + ex);
            }
        }

        @Override
        public void onPhyRead(String address, int txPhy, int rxPhy, int status) {
            Log.d(TAG, "onPhyUpdate() - device=" + BluetoothUtils.toAnonymizedAddress(address) + ", txPHy=" + txPhy + ", rxPHy=" + rxPhy);
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onPhyRead(device, txPhy, rxPhy, status);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception: " + ex);
            }
        }

        @Override
        public void onConnectionUpdated(String address, int interval, int latency, int timeout, int status) {
            Log.d(TAG, "onConnectionUpdated() - Device=" + BluetoothUtils.toAnonymizedAddress(address) + " interval=" + interval + " latency=" + latency + " timeout=" + timeout + " status=" + status);
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onConnectionUpdated(device, interval, latency, timeout, status);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception: " + ex);
            }
        }

        @Override
        public void onSubrateChange(String address, int subrateFactor, int latency, int contNum, int timeout, int status) {
            Log.d(TAG, "onSubrateChange() - Device=" + BluetoothUtils.toAnonymizedAddress(address) + ", subrateFactor=" + subrateFactor + ", latency=" + latency + ", contNum=" + contNum + ", timeout=" + timeout + ", status=" + status);
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onSubrateChange(device, subrateFactor, latency, contNum, timeout, status);
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception: " + ex);
            }
        }
    };

    BluetoothGattServer(IBluetoothGatt iGatt, int transport, BluetoothAdapter adapter) {
        this.mService = iGatt;
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mCallback = null;
        this.mServerIf = 0;
        this.mTransport = transport;
        this.mServices = new ArrayList<BluetoothGattService>();
    }

    @RequiresNoPermission
    public int getServerIf() {
        return this.mServerIf;
    }

    BluetoothGattCharacteristic getCharacteristicByHandle(int handle) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                if (charac.getInstanceId() != handle) continue;
                return charac;
            }
        }
        return null;
    }

    BluetoothGattDescriptor getDescriptorByHandle(int handle) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                for (BluetoothGattDescriptor desc : charac.getDescriptors()) {
                    if (desc.getInstanceId() != handle) continue;
                    return desc;
                }
            }
        }
        return null;
    }

    @Override
    @RequiresNoPermission
    public void onServiceConnected(IBinder service) {
    }

    @Override
    @RequiresNoPermission
    public void onServiceDisconnected() {
    }

    @Override
    @RequiresNoPermission
    public BluetoothAdapter getAdapter() {
        return this.mAdapter;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void close() {
        Log.d(TAG, "close()");
        this.unregisterCallback();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    boolean registerCallback(BluetoothGattServerCallback callback) {
        return this.registerCallback(callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    boolean registerCallback(BluetoothGattServerCallback callback, boolean eattSupport) {
        Log.d(TAG, "registerCallback()");
        if (this.mService == null) {
            Log.e(TAG, "GATT service not available");
            return false;
        }
        UUID uuid = UUID.randomUUID();
        Log.d(TAG, "registerCallback() - UUID=" + uuid);
        Object object = this.mServerIfLock;
        synchronized (object) {
            if (this.mCallback != null) {
                Log.e(TAG, "App can register callback only once");
                return false;
            }
            this.mCallback = callback;
            try {
                this.mService.registerServer(new ParcelUuid(uuid), this.mBluetoothGattServerCallback, eattSupport, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
                this.mCallback = null;
                return false;
            }
            try {
                this.mServerIfLock.wait(10000L);
            }
            catch (InterruptedException e) {
                Log.e(TAG, "" + e);
                this.mCallback = null;
            }
            if (this.mServerIf == 0) {
                this.mCallback = null;
                return false;
            }
            return true;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private void unregisterCallback() {
        Log.d(TAG, "unregisterCallback() - mServerIf=" + this.mServerIf);
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mCallback = null;
            this.mService.unregisterServer(this.mServerIf, this.mAttributionSource);
            this.mServerIf = 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    BluetoothGattService getService(UUID uuid, int instanceId, int type) {
        for (BluetoothGattService svc : this.mServices) {
            if (svc.getType() != type || svc.getInstanceId() != instanceId || !((Object)svc.getUuid()).equals(uuid)) continue;
            return svc;
        }
        return null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean connect(BluetoothDevice device, boolean autoConnect) {
        Log.d(TAG, "connect() - device: " + device + ", auto: " + autoConnect);
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        try {
            this.mService.serverConnect(this.mServerIf, device.getAddress(), device.getAddressType(), !autoConnect, this.mTransport, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void cancelConnection(BluetoothDevice device) {
        Log.d(TAG, "cancelConnection() - device: " + device);
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mService.serverDisconnect(this.mServerIf, device.getAddress(), this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void setPreferredPhy(BluetoothDevice device, int txPhy, int rxPhy, int phyOptions) {
        try {
            this.mService.serverSetPreferredPhy(this.mServerIf, device.getAddress(), txPhy, rxPhy, phyOptions, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void readPhy(BluetoothDevice device) {
        try {
            this.mService.serverReadPhy(this.mServerIf, device.getAddress(), this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean sendResponse(BluetoothDevice device, int requestId, int status, int offset, byte[] value) {
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        try {
            this.mService.sendResponse(this.mServerIf, device.getAddress(), requestId, status, offset, value, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean notifyCharacteristicChanged(BluetoothDevice device, BluetoothGattCharacteristic characteristic, boolean confirm) {
        return this.notifyCharacteristicChanged(device, characteristic, confirm, characteristic.getValue()) == 0;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int notifyCharacteristicChanged(@NonNull BluetoothDevice device, @NonNull BluetoothGattCharacteristic characteristic, boolean confirm, @NonNull byte[] value) {
        if (this.mService == null || this.mServerIf == 0) {
            return 9;
        }
        if (characteristic == null) {
            throw new IllegalArgumentException("characteristic must not be null");
        }
        if (device == null) {
            throw new IllegalArgumentException("device must not be null");
        }
        if (value.length > 512) {
            throw new IllegalArgumentException("notification should not be longer than max length of an attribute value");
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            throw new IllegalArgumentException("Characteristic must have a non-null service");
        }
        if (value == null) {
            throw new IllegalArgumentException("Characteristic value must not be null");
        }
        try {
            return this.mService.sendNotification(this.mServerIf, device.getAddress(), characteristic.getInstanceId(), confirm, value, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean addService(BluetoothGattService service) {
        Log.d(TAG, "addService() - service: " + service.getUuid());
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        this.mPendingService = service;
        try {
            this.mService.addService(this.mServerIf, service, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean removeService(BluetoothGattService service) {
        Log.d(TAG, "removeService() - service: " + service.getUuid());
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        BluetoothGattService intService = this.getService(service.getUuid(), service.getInstanceId(), service.getType());
        if (intService == null) {
            return false;
        }
        try {
            this.mService.removeService(this.mServerIf, service.getInstanceId(), this.mAttributionSource);
            this.mServices.remove(intService);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void clearServices() {
        Log.d(TAG, "clearServices()");
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mService.clearServices(this.mServerIf, this.mAttributionSource);
            this.mServices.clear();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    @RequiresNoPermission
    public List<BluetoothGattService> getServices() {
        return this.mServices;
    }

    @RequiresNoPermission
    public BluetoothGattService getService(UUID uuid) {
        for (BluetoothGattService service : this.mServices) {
            if (!((Object)service.getUuid()).equals(uuid)) continue;
            return service;
        }
        return null;
    }

    @Override
    @RequiresNoPermission
    public int getConnectionState(BluetoothDevice device) {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectionState instead.");
    }

    @Override
    @RequiresNoPermission
    public List<BluetoothDevice> getConnectedDevices() {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectedDevices instead.");
    }

    @Override
    @RequiresNoPermission
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        throw new UnsupportedOperationException("Use BluetoothManager#getDevicesMatchingConnectionStates instead.");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NotifyCharacteristicReturnValues {
    }
}

