/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.DistanceMeasurementMethod;
import android.bluetooth.le.DistanceMeasurementParams;
import android.bluetooth.le.IDistanceMeasurementCallback;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IDistanceMeasurement
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IDistanceMeasurement";

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<DistanceMeasurementMethod> getSupportedDistanceMeasurementMethods(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void startDistanceMeasurement(ParcelUuid var1, DistanceMeasurementParams var2, IDistanceMeasurementCallback var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int stopDistanceMeasurement(ParcelUuid var1, BluetoothDevice var2, int var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getChannelSoundingMaxSupportedSecurityLevel(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getLocalChannelSoundingMaxSupportedSecurityLevel(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int[] getChannelSoundingSupportedSecurityLevels(AttributionSource var1) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N2 = value.size();
                parcel.writeInt(N2);
                for (int i = 0; i < N2; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements IDistanceMeasurement {
        static final int TRANSACTION_getSupportedDistanceMeasurementMethods = 1;
        static final int TRANSACTION_startDistanceMeasurement = 2;
        static final int TRANSACTION_stopDistanceMeasurement = 3;
        static final int TRANSACTION_getChannelSoundingMaxSupportedSecurityLevel = 4;
        static final int TRANSACTION_getLocalChannelSoundingMaxSupportedSecurityLevel = 5;
        static final int TRANSACTION_getChannelSoundingSupportedSecurityLevels = 6;

        public Stub() {
            this.attachInterface(this, IDistanceMeasurement.DESCRIPTOR);
        }

        public static IDistanceMeasurement asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDistanceMeasurement.DESCRIPTOR);
            if (iin != null && iin instanceof IDistanceMeasurement) {
                return (IDistanceMeasurement)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getSupportedDistanceMeasurementMethods";
                }
                case 2: {
                    return "startDistanceMeasurement";
                }
                case 3: {
                    return "stopDistanceMeasurement";
                }
                case 4: {
                    return "getChannelSoundingMaxSupportedSecurityLevel";
                }
                case 5: {
                    return "getLocalChannelSoundingMaxSupportedSecurityLevel";
                }
                case 6: {
                    return "getChannelSoundingSupportedSecurityLevels";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDistanceMeasurement.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    List<DistanceMeasurementMethod> _result = this.getSupportedDistanceMeasurementMethods(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 2: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    DistanceMeasurementParams _arg1 = data.readTypedObject(DistanceMeasurementParams.CREATOR);
                    IDistanceMeasurementCallback _arg2 = IDistanceMeasurementCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.startDistanceMeasurement(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    BluetoothDevice _arg1 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg2 = data.readInt();
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.stopDistanceMeasurement(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getChannelSoundingMaxSupportedSecurityLevel(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 5: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getLocalChannelSoundingMaxSupportedSecurityLevel(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int[] _result = this.getChannelSoundingSupportedSecurityLevels(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IDistanceMeasurement {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDistanceMeasurement.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<DistanceMeasurementMethod> getSupportedDistanceMeasurementMethods(AttributionSource attributionSource) throws RemoteException {
                ArrayList<DistanceMeasurementMethod> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDistanceMeasurement.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(DistanceMeasurementMethod.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDistanceMeasurement(ParcelUuid uuid, DistanceMeasurementParams params, IDistanceMeasurementCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDistanceMeasurement.DESCRIPTOR);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeTypedObject(params, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int stopDistanceMeasurement(ParcelUuid uuid, BluetoothDevice device, int method, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDistanceMeasurement.DESCRIPTOR);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(method);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getChannelSoundingMaxSupportedSecurityLevel(BluetoothDevice remoteDevice, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDistanceMeasurement.DESCRIPTOR);
                    _data.writeTypedObject(remoteDevice, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLocalChannelSoundingMaxSupportedSecurityLevel(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDistanceMeasurement.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getChannelSoundingSupportedSecurityLevels(AttributionSource attributionSource) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDistanceMeasurement.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IDistanceMeasurement {
        @Override
        public List<DistanceMeasurementMethod> getSupportedDistanceMeasurementMethods(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public void startDistanceMeasurement(ParcelUuid uuid, DistanceMeasurementParams params, IDistanceMeasurementCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public int stopDistanceMeasurement(ParcelUuid uuid, BluetoothDevice device, int method, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int getChannelSoundingMaxSupportedSecurityLevel(BluetoothDevice remoteDevice, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int getLocalChannelSoundingMaxSupportedSecurityLevel(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int[] getChannelSoundingSupportedSecurityLevels(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

