/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.IBluetooth;
import android.os.RemoteException;
import android.util.Log;

class SocketMetrics {
    private static final String TAG = SocketMetrics.class.getSimpleName();
    static final int SOCKET_NO_ERROR = -1;
    private static final int RESULT_L2CAP_CONN_UNKNOWN = 0;
    static final int RESULT_L2CAP_CONN_SUCCESS = 1;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_SOCKET_CONNECTION_FAILED = 1000;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_SOCKET_CONNECTION_CLOSED = 1001;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_UNABLE_TO_SEND_RPC = 1002;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_NULL_BLUETOOTH_DEVICE = 1003;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_GET_SOCKET_MANAGER_FAILED = 1004;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_NULL_FILE_DESCRIPTOR = 1005;
    static final int RESULT_L2CAP_CONN_SERVER_FAILURE = 2000;
    private static final int RFCOMM_CONN_RESULT_FAILURE_UNKNOWN = 0;
    private static final int RFCOMM_CONN_RESULT_SUCCESS = 1;
    private static final int RFCOMM_CONN_RESULT_SOCKET_CONNECTION_FAILED = 2;
    private static final int RFCOMM_CONN_RESULT_SOCKET_CONNECTION_CLOSED = 3;
    private static final int RFCOMM_CONN_RESULT_UNABLE_TO_SEND_RPC = 4;
    private static final int RFCOMM_CONN_RESULT_NULL_BLUETOOTH_DEVICE = 5;
    private static final int RFCOMM_CONN_RESULT_GET_SOCKET_MANAGER_FAILED = 6;
    private static final int RFCOMM_CONN_RESULT_NULL_FILE_DESCRIPTOR = 7;

    SocketMetrics() {
    }

    static void logSocketConnect(int socketExceptionCode, long socketConnectionTimeNanos, int connType, BluetoothDevice device, int port, boolean auth, long socketCreationTimeNanos, long socketCreationLatencyNanos) {
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        if (bluetoothProxy == null) {
            Log.w(TAG, "logSocketConnect: bluetoothProxy is null");
            return;
        }
        if (connType == 4) {
            try {
                bluetoothProxy.logL2capcocClientConnection(device, port, auth, SocketMetrics.getL2capLeConnectStatusCode(socketExceptionCode), socketCreationTimeNanos, socketCreationLatencyNanos, socketConnectionTimeNanos);
            }
            catch (RemoteException e) {
                Log.w(TAG, "logL2capcocServerConnection failed", e);
            }
        } else if (connType == 1) {
            boolean isSerialPort = true;
            try {
                bluetoothProxy.logRfcommConnectionAttempt(device, auth, SocketMetrics.getRfcommConnectStatusCode(socketExceptionCode), socketCreationTimeNanos, isSerialPort);
            }
            catch (RemoteException e) {
                Log.w(TAG, "logL2capcocServerConnection failed", e);
            }
        } else {
            Log.d(TAG, "No metrics for connection type " + connType);
        }
    }

    static void logSocketAccept(BluetoothSocket acceptedSocket, BluetoothSocket socket, int connType, int channel, int timeout, int result, long socketCreationTimeMillis, long socketCreationLatencyMillis, long socketConnectionTimeMillis) {
        if (connType != 4) {
            return;
        }
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        if (bluetoothProxy == null) {
            Log.w(TAG, "logSocketConnect: bluetoothProxy is null");
            return;
        }
        try {
            bluetoothProxy.logL2capcocServerConnection(acceptedSocket == null ? null : acceptedSocket.getRemoteDevice(), channel, socket.isAuth(), result, socketCreationTimeMillis, socketCreationLatencyMillis, socketConnectionTimeMillis, timeout);
        }
        catch (RemoteException e) {
            Log.w(TAG, "logL2capcocServerConnection failed", e);
        }
    }

    private static int getL2capLeConnectStatusCode(int socketExceptionCode) {
        switch (socketExceptionCode) {
            case -1: {
                return 1;
            }
            case 19: {
                return 1003;
            }
            case 16: {
                return 1004;
            }
            case 17: {
                return 1001;
            }
            case 18: {
                return 1000;
            }
            case 20: {
                return 1002;
            }
            case 21: {
                return 1005;
            }
        }
        return 0;
    }

    private static int getRfcommConnectStatusCode(int socketExceptionCode) {
        switch (socketExceptionCode) {
            case -1: {
                return 1;
            }
            case 19: {
                return 5;
            }
            case 16: {
                return 6;
            }
            case 17: {
                return 3;
            }
            case 18: {
                return 2;
            }
            case 20: {
                return 4;
            }
            case 21: {
                return 7;
            }
        }
        return 0;
    }
}

