/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.IBluetoothAdvertise;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.content.AttributionSource;
import android.os.RemoteException;
import android.util.Log;
import java.util.Objects;

public class AdvertisingSet {
    private static final String TAG = AdvertisingSet.class.getSimpleName();
    private final IBluetoothAdvertise mAdvertise;
    private int mAdvertiserId;
    private final AttributionSource mAttributionSource;

    AdvertisingSet(IBluetoothAdvertise advertise, int advertiserId, BluetoothAdapter bluetoothAdapter, AttributionSource attributionSource) {
        this.mAdvertiserId = advertiserId;
        this.mAttributionSource = attributionSource;
        this.mAdvertise = Objects.requireNonNull(advertise);
    }

    void setAdvertiserId(int advertiserId) {
        this.mAdvertiserId = advertiserId;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void enableAdvertising(boolean enable, int duration, int maxExtendedAdvertisingEvents) {
        try {
            this.mAdvertise.enableAdvertisingSet(this.mAdvertiserId, enable, duration, maxExtendedAdvertisingEvents, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setAdvertisingData(AdvertiseData advertiseData) {
        try {
            this.mAdvertise.setAdvertisingData(this.mAdvertiserId, advertiseData, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setScanResponseData(AdvertiseData scanResponse) {
        try {
            this.mAdvertise.setScanResponseData(this.mAdvertiserId, scanResponse, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public void setAdvertisingParameters(AdvertisingSetParameters parameters) {
        try {
            this.mAdvertise.setAdvertisingParameters(this.mAdvertiserId, parameters, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingParameters(PeriodicAdvertisingParameters parameters) {
        try {
            this.mAdvertise.setPeriodicAdvertisingParameters(this.mAdvertiserId, parameters, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingData(AdvertiseData periodicData) {
        try {
            this.mAdvertise.setPeriodicAdvertisingData(this.mAdvertiserId, periodicData, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingEnabled(boolean enable) {
        try {
            this.mAdvertise.setPeriodicAdvertisingEnable(this.mAdvertiserId, enable, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void getOwnAddress() {
        try {
            this.mAdvertise.getOwnAddress(this.mAdvertiserId, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @SystemApi
    @RequiresNoPermission
    public int getAdvertiserId() {
        return this.mAdvertiserId;
    }
}

