/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class AdvertisingSetParameters
implements Parcelable {
    public static final int INTERVAL_HIGH = 1600;
    public static final int INTERVAL_MEDIUM = 400;
    public static final int INTERVAL_LOW = 160;
    public static final int INTERVAL_MIN = 160;
    public static final int INTERVAL_MAX = 0xFFFFFF;
    public static final int TX_POWER_ULTRA_LOW = -21;
    public static final int TX_POWER_LOW = -15;
    public static final int TX_POWER_MEDIUM = -7;
    public static final int TX_POWER_HIGH = 1;
    public static final int TX_POWER_MIN = -127;
    public static final int TX_POWER_MAX = 1;
    @SystemApi
    public static final int ADDRESS_TYPE_DEFAULT = -1;
    @SystemApi
    public static final int ADDRESS_TYPE_PUBLIC = 0;
    @SystemApi
    public static final int ADDRESS_TYPE_RANDOM = 1;
    @SystemApi
    public static final int ADDRESS_TYPE_RANDOM_NON_RESOLVABLE = 2;
    private final boolean mIsLegacy;
    private final boolean mIsAnonymous;
    private final boolean mIncludeTxPower;
    private final int mPrimaryPhy;
    private final int mSecondaryPhy;
    private final boolean mConnectable;
    private final boolean mDiscoverable;
    private final boolean mScannable;
    private final int mInterval;
    private final int mTxPowerLevel;
    private final int mOwnAddressType;
    private final boolean mIsDirected;
    private final boolean mIsHighDutyCycle;
    private final String mPeerAddress;
    private final int mPeerAddressType;
    @NonNull
    public static final Parcelable.Creator<AdvertisingSetParameters> CREATOR = new Parcelable.Creator<AdvertisingSetParameters>(){

        public AdvertisingSetParameters[] newArray(int size) {
            return new AdvertisingSetParameters[size];
        }

        @Override
        public AdvertisingSetParameters createFromParcel(Parcel in) {
            return new AdvertisingSetParameters(in);
        }
    };

    private AdvertisingSetParameters(boolean connectable, boolean discoverable, boolean scannable, boolean isLegacy, boolean isAnonymous, boolean includeTxPower, int primaryPhy, int secondaryPhy, int interval, int txPowerLevel, int ownAddressType, boolean isDirected, boolean isHighDutyCycle, String peerAddress, int peerAddressType) {
        this.mConnectable = connectable;
        this.mDiscoverable = discoverable;
        this.mScannable = scannable;
        this.mIsLegacy = isLegacy;
        this.mIsAnonymous = isAnonymous;
        this.mIncludeTxPower = includeTxPower;
        this.mPrimaryPhy = primaryPhy;
        this.mSecondaryPhy = secondaryPhy;
        this.mInterval = interval;
        this.mTxPowerLevel = txPowerLevel;
        this.mOwnAddressType = ownAddressType;
        this.mIsDirected = isDirected;
        this.mIsHighDutyCycle = isHighDutyCycle;
        this.mPeerAddress = peerAddress;
        this.mPeerAddressType = peerAddressType;
    }

    private AdvertisingSetParameters(Parcel in) {
        this.mConnectable = in.readInt() != 0;
        this.mScannable = in.readInt() != 0;
        this.mIsLegacy = in.readInt() != 0;
        this.mIsAnonymous = in.readInt() != 0;
        this.mIncludeTxPower = in.readInt() != 0;
        this.mPrimaryPhy = in.readInt();
        this.mSecondaryPhy = in.readInt();
        this.mInterval = in.readInt();
        this.mTxPowerLevel = in.readInt();
        this.mOwnAddressType = in.readInt();
        this.mDiscoverable = in.readInt() != 0;
        this.mIsDirected = in.readBoolean();
        this.mIsHighDutyCycle = in.readBoolean();
        this.mPeerAddress = in.readString();
        this.mPeerAddressType = in.readInt();
    }

    public boolean isConnectable() {
        return this.mConnectable;
    }

    public boolean isDiscoverable() {
        return this.mDiscoverable;
    }

    public boolean isScannable() {
        return this.mScannable;
    }

    public boolean isLegacy() {
        return this.mIsLegacy;
    }

    public boolean isAnonymous() {
        return this.mIsAnonymous;
    }

    public boolean includeTxPower() {
        return this.mIncludeTxPower;
    }

    public int getPrimaryPhy() {
        return this.mPrimaryPhy;
    }

    public int getSecondaryPhy() {
        return this.mSecondaryPhy;
    }

    public int getInterval() {
        return this.mInterval;
    }

    public int getTxPowerLevel() {
        return this.mTxPowerLevel;
    }

    @SystemApi
    public int getOwnAddressType() {
        return this.mOwnAddressType;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.directed_advertising_api")
    public boolean isDirected() {
        return this.mIsDirected;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.directed_advertising_api")
    public boolean isHighDutyCycle() {
        return this.mIsHighDutyCycle;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.directed_advertising_api")
    @Nullable
    public String getPeerAddress() {
        return this.mPeerAddress;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.directed_advertising_api")
    public int getPeerAddressType() {
        return this.mPeerAddressType;
    }

    public String toString() {
        return "AdvertisingSetParameters [connectable=" + this.mConnectable + ", discoverable=" + this.mDiscoverable + ", isLegacy=" + this.mIsLegacy + ", isAnonymous=" + this.mIsAnonymous + ", includeTxPower=" + this.mIncludeTxPower + ", primaryPhy=" + this.mPrimaryPhy + ", secondaryPhy=" + this.mSecondaryPhy + ", interval=" + this.mInterval + ", txPowerLevel=" + this.mTxPowerLevel + ", ownAddressType=" + this.mOwnAddressType + ", isDirected=" + this.mIsDirected + ", isHighDutyCycle=" + this.mIsHighDutyCycle + ", peerAddress=" + this.mPeerAddress + ", peerAddressType=" + this.mPeerAddressType + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mConnectable ? 1 : 0);
        dest.writeInt(this.mScannable ? 1 : 0);
        dest.writeInt(this.mIsLegacy ? 1 : 0);
        dest.writeInt(this.mIsAnonymous ? 1 : 0);
        dest.writeInt(this.mIncludeTxPower ? 1 : 0);
        dest.writeInt(this.mPrimaryPhy);
        dest.writeInt(this.mSecondaryPhy);
        dest.writeInt(this.mInterval);
        dest.writeInt(this.mTxPowerLevel);
        dest.writeInt(this.mOwnAddressType);
        dest.writeInt(this.mDiscoverable ? 1 : 0);
        dest.writeBoolean(this.mIsDirected);
        dest.writeBoolean(this.mIsHighDutyCycle);
        BluetoothUtils.writeStringToParcel(dest, this.mPeerAddress);
        dest.writeInt(this.mPeerAddressType);
    }

    public static class Builder {
        private boolean mConnectable = false;
        private boolean mDiscoverable = true;
        private boolean mScannable = false;
        private boolean mIsLegacy = false;
        private boolean mIsAnonymous = false;
        private boolean mIncludeTxPower = false;
        private int mPrimaryPhy = 1;
        private int mSecondaryPhy = 1;
        private int mInterval = 160;
        private int mTxPowerLevel = -7;
        private int mOwnAddressType = -1;
        private boolean mIsDirected = false;
        private boolean mIsHighDutyCycle = false;
        private String mPeerAddress = null;
        private int mPeerAddressType = 0;

        public Builder setConnectable(boolean connectable) {
            this.mConnectable = connectable;
            return this;
        }

        @NonNull
        public Builder setDiscoverable(boolean discoverable) {
            this.mDiscoverable = discoverable;
            return this;
        }

        public Builder setScannable(boolean scannable) {
            this.mScannable = scannable;
            return this;
        }

        public Builder setLegacyMode(boolean isLegacy) {
            this.mIsLegacy = isLegacy;
            return this;
        }

        public Builder setAnonymous(boolean isAnonymous) {
            this.mIsAnonymous = isAnonymous;
            return this;
        }

        public Builder setIncludeTxPower(boolean includeTxPower) {
            this.mIncludeTxPower = includeTxPower;
            return this;
        }

        public Builder setPrimaryPhy(int primaryPhy) {
            if (primaryPhy != 1 && primaryPhy != 3) {
                throw new IllegalArgumentException("bad primaryPhy " + primaryPhy);
            }
            this.mPrimaryPhy = primaryPhy;
            return this;
        }

        public Builder setSecondaryPhy(int secondaryPhy) {
            if (secondaryPhy != 1 && secondaryPhy != 2 && secondaryPhy != 3) {
                throw new IllegalArgumentException("bad secondaryPhy " + secondaryPhy);
            }
            this.mSecondaryPhy = secondaryPhy;
            return this;
        }

        public Builder setInterval(int interval) {
            if (interval < 160 || interval > 0xFFFFFF) {
                throw new IllegalArgumentException("unknown interval " + interval);
            }
            this.mInterval = interval;
            return this;
        }

        public Builder setTxPowerLevel(int txPowerLevel) {
            if (txPowerLevel < -127 || txPowerLevel > 1) {
                throw new IllegalArgumentException("unknown txPowerLevel " + txPowerLevel);
            }
            this.mTxPowerLevel = txPowerLevel;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setOwnAddressType(int ownAddressType) {
            if (ownAddressType < -1 || ownAddressType > 2) {
                throw new IllegalArgumentException("unknown address type " + ownAddressType);
            }
            this.mOwnAddressType = ownAddressType;
            return this;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.directed_advertising_api")
        @NonNull
        public Builder setDirected(boolean isDirected) {
            this.mIsDirected = isDirected;
            return this;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.directed_advertising_api")
        @NonNull
        public Builder setHighDutyCycle(boolean isHighDutyCycle) {
            this.mIsHighDutyCycle = isHighDutyCycle;
            return this;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.directed_advertising_api")
        @NonNull
        public Builder setPeerAddress(@NonNull String peerAddress) {
            Objects.requireNonNull(peerAddress);
            if (!BluetoothAdapter.checkBluetoothAddress(peerAddress)) {
                throw new IllegalArgumentException(peerAddress + " is not a valid Bluetooth address");
            }
            this.mPeerAddress = peerAddress;
            return this;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.directed_advertising_api")
        @NonNull
        public Builder setPeerAddressType(int peerAddressType) {
            switch (peerAddressType) {
                case 0: 
                case 1: {
                    this.mPeerAddressType = peerAddressType;
                    break;
                }
                case 255: 
                case 65535: {
                    throw new IllegalArgumentException("unsupported peer address type " + peerAddressType);
                }
                default: {
                    throw new IllegalArgumentException("unknown peer address type " + peerAddressType);
                }
            }
            return this;
        }

        public AdvertisingSetParameters build() {
            if (this.mIsLegacy) {
                if (this.mIsAnonymous) {
                    throw new IllegalArgumentException("Legacy advertising can't be anonymous");
                }
                if (this.mIsDirected && !this.mConnectable) {
                    throw new IllegalStateException("Legacy directed advertising must be connectable");
                }
                if (this.mIsDirected && this.mScannable) {
                    throw new IllegalStateException("Legacy directed advertising can't be scannable");
                }
                if (!this.mIsDirected && this.mIsHighDutyCycle) {
                    throw new IllegalStateException("Non-directed legacy advertising can't be high duty cycle");
                }
                if (!this.mIsDirected && this.mConnectable && !this.mScannable) {
                    throw new IllegalStateException("Non-directed legacy advertising can't be connectable and non-scannable");
                }
                if (this.mIncludeTxPower) {
                    throw new IllegalStateException("Legacy advertising can't include TX power level in header");
                }
            } else {
                if (this.mConnectable && this.mScannable) {
                    throw new IllegalStateException("Advertising can't be both connectable and scannable");
                }
                if (this.mIsAnonymous && this.mConnectable) {
                    throw new IllegalStateException("Advertising can't be both connectable and anonymous");
                }
                if (this.mIsHighDutyCycle) {
                    throw new IllegalStateException("Non-legacy advertising can't be high duty cycle");
                }
            }
            if (this.mIsDirected && this.mPeerAddress == null) {
                throw new IllegalStateException("Peer address should not be null for directed advertising");
            }
            return new AdvertisingSetParameters(this.mConnectable, this.mDiscoverable, this.mScannable, this.mIsLegacy, this.mIsAnonymous, this.mIncludeTxPower, this.mPrimaryPhy, this.mSecondaryPhy, this.mInterval, this.mTxPowerLevel, this.mOwnAddressType, this.mIsDirected, this.mIsHighDutyCycle, this.mPeerAddress, this.mPeerAddressType);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AddressTypeStatus {
    }
}

