/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothAdvertise;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.AdvertisingSet;
import android.bluetooth.le.AdvertisingSetCallback;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.BluetoothLeUtils;
import android.bluetooth.le.IAdvertisingSetCallback;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.bluetooth.le.TransportDiscoveryData;
import android.content.AttributionSource;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BluetoothLeAdvertiser {
    private static final String TAG = BluetoothLeAdvertiser.class.getSimpleName();
    private static final int MAX_LEGACY_ADVERTISING_DATA_BYTES = 31;
    private static final int OVERHEAD_BYTES_PER_FIELD = 2;
    private static final int FLAGS_FIELD_BYTES = 3;
    private static final int MANUFACTURER_SPECIFIC_DATA_LENGTH = 2;
    private final Map<AdvertiseCallback, AdvertisingSetCallback> mLegacyAdvertisers = new HashMap<AdvertiseCallback, AdvertisingSetCallback>();
    private final Map<AdvertisingSetCallback, IAdvertisingSetCallback> mCallbackWrappers = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, AdvertisingSet> mAdvertisingSets = Collections.synchronizedMap(new HashMap());
    private final BluetoothAdapter mBluetoothAdapter;
    private final AttributionSource mAttributionSource;
    private final Handler mHandler;

    public BluetoothLeAdvertiser(BluetoothAdapter bluetoothAdapter) {
        this.mBluetoothAdapter = Objects.requireNonNull(bluetoothAdapter);
        this.mAttributionSource = this.mBluetoothAdapter.getAttributionSource();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public void startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseCallback callback) {
        this.startAdvertising(settings, advertiseData, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public void startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseData scanResponse, AdvertiseCallback callback) {
        Map<AdvertiseCallback, AdvertisingSetCallback> map = this.mLegacyAdvertisers;
        synchronized (map) {
            boolean hasFlags;
            BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            boolean isConnectable = settings.isConnectable();
            boolean isDiscoverable = settings.isDiscoverable();
            boolean bl = hasFlags = isConnectable && isDiscoverable;
            if (this.totalBytes(advertiseData, hasFlags) > 31 || this.totalBytes(scanResponse, false) > 31) {
                this.postStartFailure(callback, 1);
                return;
            }
            if (this.mLegacyAdvertisers.containsKey(callback)) {
                this.postStartFailure(callback, 3);
                return;
            }
            AdvertisingSetParameters.Builder parameters = new AdvertisingSetParameters.Builder();
            parameters.setLegacyMode(true);
            parameters.setConnectable(isConnectable);
            parameters.setDiscoverable(isDiscoverable);
            parameters.setScannable(true);
            parameters.setOwnAddressType(settings.getOwnAddressType());
            if (settings.getMode() == 0) {
                parameters.setInterval(1600);
            } else if (settings.getMode() == 1) {
                parameters.setInterval(400);
            } else if (settings.getMode() == 2) {
                parameters.setInterval(160);
            }
            if (settings.getTxPowerLevel() == 0) {
                Log.d(TAG, "TxPower == ADVERTISE_TX_POWER_ULTRA_LOW");
                parameters.setTxPowerLevel(-21);
            } else if (settings.getTxPowerLevel() == 1) {
                Log.d(TAG, "TxPower == ADVERTISE_TX_POWER_LOW");
                parameters.setTxPowerLevel(-15);
            } else if (settings.getTxPowerLevel() == 2) {
                Log.d(TAG, "TxPower == ADVERTISE_TX_POWER_MEDIUM");
                parameters.setTxPowerLevel(-7);
            } else if (settings.getTxPowerLevel() == 3) {
                Log.d(TAG, "TxPower == ADVERTISE_TX_POWER_HIGH");
                parameters.setTxPowerLevel(1);
            }
            int duration = 0;
            int timeoutMillis = settings.getTimeout();
            if (timeoutMillis > 0) {
                duration = timeoutMillis < 10 ? 1 : timeoutMillis / 10;
            }
            AdvertisingSetCallback wrapped = this.wrapOldCallback(callback, settings);
            this.mLegacyAdvertisers.put(callback, wrapped);
            this.startAdvertisingSet(parameters.build(), advertiseData, scanResponse, null, null, duration, 0, wrapped);
        }
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission", "AndroidFrameworkRequiresPermission"})
    AdvertisingSetCallback wrapOldCallback(final AdvertiseCallback callback, final AdvertiseSettings settings) {
        return new AdvertisingSetCallback(){

            @Override
            public void onAdvertisingSetStarted(AdvertisingSet advertisingSet, int txPower, int status) {
                if (status != 0) {
                    BluetoothLeAdvertiser.this.postStartFailure(callback, status);
                    return;
                }
                BluetoothLeAdvertiser.this.postStartSuccess(callback, settings);
            }

            @Override
            public void onAdvertisingEnabled(AdvertisingSet advertisingSet, boolean enabled, int status) {
                if (enabled) {
                    Log.e(TAG, "Legacy advertiser should be only disabled on timeout, but was enabled!");
                    return;
                }
                BluetoothLeAdvertiser.this.stopAdvertising(callback);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void stopAdvertising(AdvertiseCallback callback) {
        Map<AdvertiseCallback, AdvertisingSetCallback> map = this.mLegacyAdvertisers;
        synchronized (map) {
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            AdvertisingSetCallback wrapper = this.mLegacyAdvertisers.get(callback);
            if (wrapper == null) {
                return;
            }
            this.stopAdvertisingSet(wrapper);
            this.mLegacyAdvertisers.remove(callback);
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, AdvertisingSetCallback callback) {
        this.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, 0, 0, callback, new Handler(Looper.getMainLooper()));
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, AdvertisingSetCallback callback, Handler handler) {
        this.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, 0, 0, callback, handler);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtendedAdvertisingEvents, AdvertisingSetCallback callback) {
        this.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, duration, maxExtendedAdvertisingEvents, callback, new Handler(Looper.getMainLooper()));
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtendedAdvertisingEvents, AdvertisingSetCallback callback, Handler handler) {
        this.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, duration, maxExtendedAdvertisingEvents, null, callback, handler);
    }

    @SystemApi
    @SuppressLint(value={"ExecutorRegistration"})
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public void startAdvertisingSet(@NonNull AdvertisingSetParameters parameters, @Nullable AdvertiseData advertiseData, @Nullable AdvertiseData scanResponse, @Nullable PeriodicAdvertisingParameters periodicParameters, @Nullable AdvertiseData periodicData, int duration, int maxExtendedAdvertisingEvents, @Nullable BluetoothGattServer gattServer, @Nullable AdvertisingSetCallback callback, @SuppressLint(value={"ListenerLast"}) @NonNull Handler handler) {
        boolean hasFlags;
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        boolean isConnectable = parameters.isConnectable();
        boolean isDiscoverable = parameters.isDiscoverable();
        boolean bl = hasFlags = isConnectable && isDiscoverable;
        if (parameters.isLegacy()) {
            if (this.totalBytes(advertiseData, hasFlags) > 31) {
                throw new IllegalArgumentException("Legacy advertising data too big");
            }
            if (this.totalBytes(scanResponse, false) > 31) {
                throw new IllegalArgumentException("Legacy scan response data too big");
            }
        } else {
            boolean supportCodedPhy = this.mBluetoothAdapter.isLeCodedPhySupported();
            boolean support2MPhy = this.mBluetoothAdapter.isLe2MPhySupported();
            int pphy = parameters.getPrimaryPhy();
            int sphy = parameters.getSecondaryPhy();
            if (pphy == 3 && !supportCodedPhy) {
                throw new IllegalArgumentException("Unsupported primary PHY selected");
            }
            if (sphy == 3 && !supportCodedPhy || sphy == 2 && !support2MPhy) {
                throw new IllegalArgumentException("Unsupported secondary PHY selected");
            }
            int maxData = this.mBluetoothAdapter.getLeMaximumAdvertisingDataLength();
            if (this.totalBytes(advertiseData, hasFlags) > maxData) {
                throw new IllegalArgumentException("Advertising data too big");
            }
            if (this.totalBytes(scanResponse, false) > maxData) {
                throw new IllegalArgumentException("Scan response data too big");
            }
            if (this.totalBytes(periodicData, false) > maxData) {
                throw new IllegalArgumentException("Periodic advertising data too big");
            }
            boolean supportPeriodic = this.mBluetoothAdapter.isLePeriodicAdvertisingSupported();
            if (periodicParameters != null && !supportPeriodic) {
                throw new IllegalArgumentException("Controller does not support LE Periodic Advertising");
            }
        }
        if (maxExtendedAdvertisingEvents < 0 || maxExtendedAdvertisingEvents > 255) {
            throw new IllegalArgumentException("maxExtendedAdvertisingEvents out of range: " + maxExtendedAdvertisingEvents);
        }
        if (maxExtendedAdvertisingEvents != 0 && !this.mBluetoothAdapter.isLeExtendedAdvertisingSupported()) {
            throw new IllegalArgumentException("Can't use maxExtendedAdvertisingEvents with controller that doesn't support LE Extended Advertising");
        }
        if (duration < 0 || duration > 65535) {
            throw new IllegalArgumentException("duration out of range: " + duration);
        }
        IBluetoothAdvertise advertise = this.mBluetoothAdapter.getBluetoothAdvertise();
        if (advertise == null) {
            Log.e(TAG, "Bluetooth Advertise is null");
            BluetoothLeAdvertiser.postStartSetFailure(handler, callback, 4);
            return;
        }
        IAdvertisingSetCallback wrapped = this.wrap(callback, handler);
        if (this.mCallbackWrappers.putIfAbsent(callback, wrapped) != null) {
            throw new IllegalArgumentException("callback instance already associated with advertising");
        }
        try {
            advertise.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, duration, maxExtendedAdvertisingEvents, gattServer == null ? 0 : gattServer.getServerIf(), wrapped, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to start advertising set - ", e);
            BluetoothLeAdvertiser.postStartSetFailure(handler, callback, 4);
            return;
        }
        catch (SecurityException e) {
            this.mCallbackWrappers.remove(callback);
            throw e;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void stopAdvertisingSet(AdvertisingSetCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        IAdvertisingSetCallback wrapped = this.mCallbackWrappers.remove(callback);
        if (wrapped == null) {
            return;
        }
        IBluetoothAdvertise advertise = this.mBluetoothAdapter.getBluetoothAdvertise();
        if (advertise == null) {
            Log.e(TAG, "Bluetooth Advertise is null");
            return;
        }
        try {
            advertise.stopAdvertisingSet(wrapped, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to stop advertising - ", e);
        }
    }

    @RequiresNoPermission
    public void cleanup() {
        this.mLegacyAdvertisers.clear();
        this.mCallbackWrappers.clear();
        this.mAdvertisingSets.clear();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    private int totalBytes(AdvertiseData data, boolean isFlagsIncluded) {
        int length;
        if (data == null) {
            return 0;
        }
        int size = isFlagsIncluded ? 3 : 0;
        size += BluetoothLeAdvertiser.calculateUuidsSize(data.getServiceUuids());
        size += BluetoothLeAdvertiser.calculateUuidsSize(data.getServiceSolicitationUuids());
        for (TransportDiscoveryData transportDiscoveryData : data.getTransportDiscoveryData()) {
            size += 2 + transportDiscoveryData.totalBytes();
        }
        for (Map.Entry entry : data.getServiceData().entrySet()) {
            ParcelUuid uuid = (ParcelUuid)entry.getKey();
            byte[] serviceData = (byte[])entry.getValue();
            int uuidLen = BluetoothUuid.uuidToBytes(uuid).length;
            size += 2 + uuidLen + BluetoothLeAdvertiser.byteLength(serviceData);
        }
        for (int i = 0; i < data.getManufacturerSpecificData().size(); ++i) {
            size += 4 + BluetoothLeAdvertiser.byteLength(data.getManufacturerSpecificData().valueAt(i));
        }
        if (data.getIncludeTxPowerLevel()) {
            size += 3;
        }
        if (data.getIncludeDeviceName() && (length = this.mBluetoothAdapter.getNameLengthForAdvertise()) >= 0) {
            size += 2 + length;
        }
        return size;
    }

    private static int calculateUuidsSize(List<ParcelUuid> uuids) {
        if (uuids == null) {
            return 0;
        }
        int num16BitUuids = 0;
        int num32BitUuids = 0;
        int num128BitUuids = 0;
        for (ParcelUuid uuid : uuids) {
            if (BluetoothUuid.is16BitUuid(uuid)) {
                ++num16BitUuids;
                continue;
            }
            if (BluetoothUuid.is32BitUuid(uuid)) {
                ++num32BitUuids;
                continue;
            }
            ++num128BitUuids;
        }
        int size = 0;
        if (num16BitUuids != 0) {
            size += 2 + num16BitUuids * 2;
        }
        if (num32BitUuids != 0) {
            size += 2 + num32BitUuids * 4;
        }
        if (num128BitUuids != 0) {
            size += 2 + num128BitUuids * 16;
        }
        return size;
    }

    private static int byteLength(byte[] array2) {
        return array2 == null ? 0 : array2.length;
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    IAdvertisingSetCallback wrap(final AdvertisingSetCallback callback, final Handler handler) {
        return new IAdvertisingSetCallback.Stub(){

            @Override
            public void onAdvertisingSetStarted(IBinder advertiseBinder, int advertiserId, int txPower, int status) {
                handler.post(() -> {
                    if (status != 0) {
                        callback.onAdvertisingSetStarted(null, 0, status);
                        BluetoothLeAdvertiser.this.mCallbackWrappers.remove(callback);
                        return;
                    }
                    AdvertisingSet advertisingSet = new AdvertisingSet(IBluetoothAdvertise.Stub.asInterface(advertiseBinder), advertiserId, BluetoothLeAdvertiser.this.mBluetoothAdapter, BluetoothLeAdvertiser.this.mAttributionSource);
                    BluetoothLeAdvertiser.this.mAdvertisingSets.put(advertiserId, advertisingSet);
                    callback.onAdvertisingSetStarted(advertisingSet, txPower, status);
                });
            }

            @Override
            public void onOwnAddressRead(int advertiserId, int addressType, String address) {
                handler.post(() -> {
                    AdvertisingSet advertisingSet = BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                    callback.onOwnAddressRead(advertisingSet, addressType, address);
                });
            }

            @Override
            public void onAdvertisingSetStopped(int advertiserId) {
                handler.post(() -> {
                    AdvertisingSet advertisingSet = BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                    callback.onAdvertisingSetStopped(advertisingSet);
                    BluetoothLeAdvertiser.this.mAdvertisingSets.remove(advertiserId);
                    BluetoothLeAdvertiser.this.mCallbackWrappers.remove(callback);
                });
            }

            @Override
            public void onAdvertisingEnabled(int advertiserId, boolean enabled, int status) {
                handler.post(() -> {
                    AdvertisingSet advertisingSet = BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                    callback.onAdvertisingEnabled(advertisingSet, enabled, status);
                });
            }

            @Override
            public void onAdvertisingDataSet(int advertiserId, int status) {
                handler.post(() -> {
                    AdvertisingSet advertisingSet = BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                    callback.onAdvertisingDataSet(advertisingSet, status);
                });
            }

            @Override
            public void onScanResponseDataSet(int advertiserId, int status) {
                handler.post(() -> {
                    AdvertisingSet advertisingSet = BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                    callback.onScanResponseDataSet(advertisingSet, status);
                });
            }

            @Override
            public void onAdvertisingParametersUpdated(int advertiserId, int txPower, int status) {
                handler.post(() -> {
                    AdvertisingSet advertisingSet = BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                    callback.onAdvertisingParametersUpdated(advertisingSet, txPower, status);
                });
            }

            @Override
            public void onPeriodicAdvertisingParametersUpdated(int advertiserId, int status) {
                handler.post(() -> {
                    AdvertisingSet advertisingSet = BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                    callback.onPeriodicAdvertisingParametersUpdated(advertisingSet, status);
                });
            }

            @Override
            public void onPeriodicAdvertisingDataSet(int advertiserId, int status) {
                handler.post(() -> {
                    AdvertisingSet advertisingSet = BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                    callback.onPeriodicAdvertisingDataSet(advertisingSet, status);
                });
            }

            @Override
            public void onPeriodicAdvertisingEnabled(int advertiserId, boolean enable, int status) {
                handler.post(() -> {
                    AdvertisingSet advertisingSet = BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                    callback.onPeriodicAdvertisingEnabled(advertisingSet, enable, status);
                });
            }
        };
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private static void postStartSetFailure(Handler handler, AdvertisingSetCallback callback, int error) {
        handler.post(() -> callback.onAdvertisingSetStarted(null, 0, error));
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private void postStartFailure(AdvertiseCallback callback, int error) {
        this.mHandler.post(() -> callback.onStartFailure(error));
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private void postStartSuccess(AdvertiseCallback callback, AdvertiseSettings settings) {
        this.mHandler.post(() -> callback.onStartSuccess(settings));
    }
}

