/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ChannelSoundingParams;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class DistanceMeasurementParams
implements Parcelable {
    @SystemApi
    public static final int REPORT_FREQUENCY_LOW = 0;
    @SystemApi
    public static final int REPORT_FREQUENCY_MEDIUM = 1;
    @SystemApi
    public static final int REPORT_FREQUENCY_HIGH = 2;
    private static final int REPORT_DURATION_MAX = Integer.MAX_VALUE;
    private static final int REPORT_DURATION_DEFAULT = Integer.MAX_VALUE;
    private final BluetoothDevice mDevice;
    private final int mDuration;
    private final int mFrequency;
    private final int mMethodId;
    private final ChannelSoundingParams mChannelSoundingParams;
    @NonNull
    public static final Parcelable.Creator<DistanceMeasurementParams> CREATOR = new Parcelable.Creator<DistanceMeasurementParams>(){

        @Override
        @NonNull
        public DistanceMeasurementParams createFromParcel(@NonNull Parcel in) {
            Builder builder = new Builder(BluetoothDevice.CREATOR.createFromParcel(in));
            builder.setDurationSeconds(in.readInt());
            builder.setFrequency(in.readInt());
            builder.setMethodId(in.readInt());
            if (in.readInt() == 1) {
                builder.setChannelSoundingParams(ChannelSoundingParams.CREATOR.createFromParcel(in));
            }
            return builder.build();
        }

        @NonNull
        public DistanceMeasurementParams[] newArray(int size) {
            return new DistanceMeasurementParams[size];
        }
    };

    public DistanceMeasurementParams(@NonNull BluetoothDevice device, int duration, int frequency, int methodId, ChannelSoundingParams channelSoundingParams) {
        this.mDevice = Objects.requireNonNull(device);
        this.mDuration = duration;
        this.mFrequency = frequency;
        this.mMethodId = methodId;
        this.mChannelSoundingParams = channelSoundingParams;
    }

    @SystemApi
    @NonNull
    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    @SystemApi
    public int getDurationSeconds() {
        return this.mDuration;
    }

    @SystemApi
    public int getFrequency() {
        return this.mFrequency;
    }

    @SystemApi
    public int getMethodId() {
        return this.mMethodId;
    }

    @SystemApi
    @Nullable
    public ChannelSoundingParams getChannelSoundingParams() {
        return this.mChannelSoundingParams;
    }

    @SystemApi
    public static int getDefaultDurationSeconds() {
        return Integer.MAX_VALUE;
    }

    @SystemApi
    public static int getMaxDurationSeconds() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.mDevice.writeToParcel(out, flags);
        out.writeInt(this.mDuration);
        out.writeInt(this.mFrequency);
        out.writeInt(this.mMethodId);
        out.writeInt(this.mChannelSoundingParams == null ? 0 : 1);
        if (this.mChannelSoundingParams != null) {
            this.mChannelSoundingParams.writeToParcel(out, flags);
        }
    }

    @SystemApi
    public static class Builder {
        private BluetoothDevice mDevice = null;
        private int mDuration = Integer.MAX_VALUE;
        private int mFrequency = 0;
        private int mMethodId = 1;
        private ChannelSoundingParams mChannelSoundingParams = null;

        public Builder(@NonNull BluetoothDevice device) {
            this.mDevice = Objects.requireNonNull(device);
        }

        @SystemApi
        @NonNull
        public Builder setDurationSeconds(int duration) {
            if (duration < 0 || duration > DistanceMeasurementParams.getMaxDurationSeconds()) {
                throw new IllegalArgumentException("illegal duration " + duration);
            }
            this.mDuration = duration;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setFrequency(int frequency) {
            switch (frequency) {
                case 0: 
                case 1: 
                case 2: {
                    this.mFrequency = frequency;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown frequency " + frequency);
                }
            }
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setMethodId(int methodId) {
            switch (methodId) {
                case 0: 
                case 1: 
                case 2: {
                    this.mMethodId = methodId;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown method id " + methodId);
                }
            }
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setChannelSoundingParams(@NonNull ChannelSoundingParams channelSoundingParams) {
            this.mChannelSoundingParams = channelSoundingParams;
            return this;
        }

        @SystemApi
        @NonNull
        public DistanceMeasurementParams build() {
            return new DistanceMeasurementParams(this.mDevice, this.mDuration, this.mFrequency, this.mMethodId, this.mChannelSoundingParams);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ReportFrequency {
    }
}

