/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.UserIdInt;
import android.companion.AssociatedDevice;
import android.companion.DeviceFilter;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.drawable.Icon;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.OneTimeUseBuilder;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.CollectionUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AssociationRequest
implements Parcelable {
    public static final String DEVICE_PROFILE_WATCH = "android.app.role.COMPANION_DEVICE_WATCH";
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_PROFILE_GLASSES")
    public static final String DEVICE_PROFILE_GLASSES = "android.app.role.COMPANION_DEVICE_GLASSES";
    public static final String DEVICE_PROFILE_WEARABLE_SENSING = "android.companion.COMPANION_DEVICE_WEARABLE_SENSING";
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_PROFILE_APP_STREAMING")
    public static final String DEVICE_PROFILE_APP_STREAMING = "android.app.role.COMPANION_DEVICE_APP_STREAMING";
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_PROFILE_NEARBY_DEVICE_STREAMING")
    public static final String DEVICE_PROFILE_NEARBY_DEVICE_STREAMING = "android.app.role.COMPANION_DEVICE_NEARBY_DEVICE_STREAMING";
    @FlaggedApi(value="android.companion.virtualdevice.flags.enable_limited_vdm_role")
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_PROFILE_VIRTUAL_DEVICE")
    public static final String DEVICE_PROFILE_VIRTUAL_DEVICE = "android.app.role.COMPANION_DEVICE_VIRTUAL_DEVICE";
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_PROFILE_AUTOMOTIVE_PROJECTION")
    public static final String DEVICE_PROFILE_AUTOMOTIVE_PROJECTION = "android.app.role.SYSTEM_AUTOMOTIVE_PROJECTION";
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_PROFILE_COMPUTER")
    public static final String DEVICE_PROFILE_COMPUTER = "android.app.role.COMPANION_DEVICE_COMPUTER";
    private final boolean mSingleDevice;
    @NonNull
    private final List<DeviceFilter<?>> mDeviceFilters;
    @Nullable
    private final String mDeviceProfile;
    @Nullable
    private CharSequence mDisplayName;
    @Nullable
    private AssociatedDevice mAssociatedDevice;
    private final boolean mSelfManaged;
    private final boolean mForceConfirmation;
    private final boolean mSkipRoleGrant;
    @Nullable
    private String mPackageName;
    private int mUserId;
    @Nullable
    private String mDeviceProfilePrivilegesDescription;
    private final long mCreationTime;
    private boolean mSkipPrompt;
    @Nullable
    private Icon mDeviceIcon;
    @NonNull
    public static final Parcelable.Creator<AssociationRequest> CREATOR = new Parcelable.Creator<AssociationRequest>(){

        public AssociationRequest[] newArray(int size) {
            return new AssociationRequest[size];
        }

        @Override
        public AssociationRequest createFromParcel(@NonNull Parcel in) {
            return new AssociationRequest(in);
        }
    };

    private AssociationRequest(boolean singleDevice, @NonNull List<DeviceFilter<?>> deviceFilters, @Nullable String deviceProfile, @Nullable CharSequence displayName, boolean selfManaged, boolean forceConfirmation, boolean skipRoleGrant, @Nullable Icon deviceIcon) {
        this.mSingleDevice = singleDevice;
        this.mDeviceFilters = Objects.requireNonNull(deviceFilters);
        this.mDeviceProfile = deviceProfile;
        this.mDisplayName = displayName;
        this.mSelfManaged = selfManaged;
        this.mForceConfirmation = forceConfirmation;
        this.mSkipRoleGrant = skipRoleGrant;
        this.mCreationTime = System_Delegate.currentTimeMillis();
        this.mDeviceIcon = deviceIcon;
    }

    @Nullable
    public String getDeviceProfile() {
        return this.mDeviceProfile;
    }

    @Nullable
    public CharSequence getDisplayName() {
        return this.mDisplayName;
    }

    public boolean isSelfManaged() {
        return this.mSelfManaged;
    }

    public boolean isForceConfirmation() {
        return this.mForceConfirmation;
    }

    @SuppressLint(value={"UnflaggedApi"})
    public boolean isSkipRoleGrant() {
        return this.mSkipRoleGrant;
    }

    public boolean isSingleDevice() {
        return this.mSingleDevice;
    }

    @FlaggedApi(value="android.companion.association_device_icon")
    @Nullable
    public Icon getDeviceIcon() {
        return this.mDeviceIcon;
    }

    public void setPackageName(@NonNull String packageName) {
        this.mPackageName = packageName;
    }

    public void setUserId(int userId) {
        this.mUserId = userId;
    }

    public void setDeviceProfilePrivilegesDescription(@NonNull String desc) {
        this.mDeviceProfilePrivilegesDescription = desc;
    }

    public void setSkipPrompt(boolean value) {
        this.mSkipPrompt = value;
    }

    public void setDisplayName(CharSequence displayName) {
        this.mDisplayName = displayName;
    }

    public void setAssociatedDevice(AssociatedDevice associatedDevice) {
        this.mAssociatedDevice = associatedDevice;
    }

    public void setDeviceIcon(Icon deviceIcon) {
        this.mDeviceIcon = deviceIcon;
    }

    @NonNull
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public List<DeviceFilter<?>> getDeviceFilters() {
        return this.mDeviceFilters;
    }

    @Nullable
    public AssociatedDevice getAssociatedDevice() {
        return this.mAssociatedDevice;
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    public int getUserId() {
        return this.mUserId;
    }

    @Nullable
    public String getDeviceProfilePrivilegesDescription() {
        return this.mDeviceProfilePrivilegesDescription;
    }

    public long getCreationTime() {
        return this.mCreationTime;
    }

    public boolean isSkipPrompt() {
        return this.mSkipPrompt;
    }

    public String toString() {
        return "AssociationRequest { singleDevice = " + this.mSingleDevice + ", deviceFilters = " + this.mDeviceFilters + ", deviceProfile = " + this.mDeviceProfile + ", displayName = " + this.mDisplayName + ", associatedDevice = " + this.mAssociatedDevice + ", selfManaged = " + this.mSelfManaged + ", forceConfirmation = " + this.mForceConfirmation + ", skipRoleGrant = " + this.mSkipRoleGrant + ", packageName = " + this.mPackageName + ", userId = " + this.mUserId + ", deviceProfilePrivilegesDescription = " + this.mDeviceProfilePrivilegesDescription + ", creationTime = " + this.mCreationTime + ", skipPrompt = " + this.mSkipPrompt + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationRequest that = (AssociationRequest)o;
        return this.mSingleDevice == that.mSingleDevice && Objects.equals(this.mDeviceFilters, that.mDeviceFilters) && Objects.equals(this.mDeviceProfile, that.mDeviceProfile) && Objects.equals(this.mDisplayName, that.mDisplayName) && Objects.equals(this.mAssociatedDevice, that.mAssociatedDevice) && this.mSelfManaged == that.mSelfManaged && this.mForceConfirmation == that.mForceConfirmation && this.mSkipRoleGrant == that.mSkipRoleGrant && Objects.equals(this.mPackageName, that.mPackageName) && this.mUserId == that.mUserId && Objects.equals(this.mDeviceProfilePrivilegesDescription, that.mDeviceProfilePrivilegesDescription) && this.mCreationTime == that.mCreationTime && this.mSkipPrompt == that.mSkipPrompt && (this.mDeviceIcon == null ? that.mDeviceIcon == null : this.mDeviceIcon.sameAs(that.mDeviceIcon));
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Boolean.hashCode(this.mSingleDevice);
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceFilters);
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceProfile);
        _hash = 31 * _hash + Objects.hashCode(this.mDisplayName);
        _hash = 31 * _hash + Objects.hashCode(this.mAssociatedDevice);
        _hash = 31 * _hash + Boolean.hashCode(this.mSelfManaged);
        _hash = 31 * _hash + Boolean.hashCode(this.mForceConfirmation);
        _hash = 31 * _hash + Boolean.hashCode(this.mSkipRoleGrant);
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        _hash = 31 * _hash + this.mUserId;
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceProfilePrivilegesDescription);
        _hash = 31 * _hash + Long.hashCode(this.mCreationTime);
        _hash = 31 * _hash + Boolean.hashCode(this.mSkipPrompt);
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceIcon);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        int flg = 0;
        if (this.mSingleDevice) {
            flg |= 1;
        }
        if (this.mSelfManaged) {
            flg |= 2;
        }
        if (this.mForceConfirmation) {
            flg |= 4;
        }
        if (this.mSkipPrompt) {
            flg |= 8;
        }
        if (this.mDeviceProfile != null) {
            flg |= 0x10;
        }
        if (this.mDisplayName != null) {
            flg |= 0x20;
        }
        if (this.mAssociatedDevice != null) {
            flg |= 0x40;
        }
        if (this.mPackageName != null) {
            flg |= 0x80;
        }
        if (this.mDeviceProfilePrivilegesDescription != null) {
            flg |= 0x100;
        }
        if (this.mSkipRoleGrant) {
            flg |= 0x200;
        }
        dest.writeInt(flg);
        dest.writeParcelableList(this.mDeviceFilters, flags);
        if (this.mDeviceProfile != null) {
            dest.writeString(this.mDeviceProfile);
        }
        if (this.mDisplayName != null) {
            dest.writeCharSequence(this.mDisplayName);
        }
        if (this.mAssociatedDevice != null) {
            dest.writeTypedObject(this.mAssociatedDevice, flags);
        }
        if (this.mPackageName != null) {
            dest.writeString(this.mPackageName);
        }
        dest.writeInt(this.mUserId);
        if (this.mDeviceProfilePrivilegesDescription != null) {
            dest.writeString8(this.mDeviceProfilePrivilegesDescription);
        }
        dest.writeLong(this.mCreationTime);
        if (this.mDeviceIcon != null) {
            dest.writeInt(1);
            this.mDeviceIcon.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AssociationRequest(@NonNull Parcel in) {
        int flg = in.readInt();
        boolean singleDevice = (flg & 1) != 0;
        boolean selfManaged = (flg & 2) != 0;
        boolean forceConfirmation = (flg & 4) != 0;
        boolean skipPrompt = (flg & 8) != 0;
        boolean skipRoleGrant = (flg & 0x200) != 0;
        ArrayList deviceFilters = new ArrayList();
        in.readParcelableList(deviceFilters, DeviceFilter.class.getClassLoader(), DeviceFilter.class);
        String deviceProfile = (flg & 0x10) == 0 ? null : in.readString();
        CharSequence displayName = (flg & 0x20) == 0 ? null : in.readCharSequence();
        AssociatedDevice associatedDevice = (flg & 0x40) == 0 ? null : in.readTypedObject(AssociatedDevice.CREATOR);
        String packageName = (flg & 0x80) == 0 ? null : in.readString();
        int userId = in.readInt();
        String deviceProfilePrivilegesDescription = (flg & 0x100) == 0 ? null : in.readString8();
        long creationTime = in.readLong();
        this.mSingleDevice = singleDevice;
        this.mDeviceFilters = deviceFilters;
        AnnotationValidations.validate(NonNull.class, null, this.mDeviceFilters);
        this.mDeviceProfile = deviceProfile;
        this.mDisplayName = displayName;
        this.mAssociatedDevice = associatedDevice;
        this.mSelfManaged = selfManaged;
        this.mForceConfirmation = forceConfirmation;
        this.mSkipRoleGrant = skipRoleGrant;
        this.mPackageName = packageName;
        this.mUserId = userId;
        AnnotationValidations.validate(UserIdInt.class, null, this.mUserId);
        this.mDeviceProfilePrivilegesDescription = deviceProfilePrivilegesDescription;
        this.mCreationTime = creationTime;
        this.mSkipPrompt = skipPrompt;
        this.mDeviceIcon = in.readInt() == 1 ? Icon.CREATOR.createFromParcel(in) : null;
    }

    public static class Builder
    extends OneTimeUseBuilder<AssociationRequest> {
        private boolean mSingleDevice = false;
        private ArrayList<DeviceFilter<?>> mDeviceFilters = null;
        private String mDeviceProfile;
        private CharSequence mDisplayName;
        private boolean mSelfManaged = false;
        private boolean mForceConfirmation = false;
        private boolean mSkipRoleGrant = false;
        private Icon mDeviceIcon = null;

        @NonNull
        public Builder setSingleDevice(boolean singleDevice) {
            this.checkNotUsed();
            this.mSingleDevice = singleDevice;
            return this;
        }

        @NonNull
        public Builder addDeviceFilter(@Nullable DeviceFilter<?> deviceFilter) {
            this.checkNotUsed();
            if (deviceFilter != null) {
                this.mDeviceFilters = ArrayUtils.add(this.mDeviceFilters, deviceFilter);
            }
            return this;
        }

        @NonNull
        public Builder setDeviceProfile(@NonNull String deviceProfile) {
            this.checkNotUsed();
            this.mDeviceProfile = deviceProfile;
            return this;
        }

        @NonNull
        public Builder setDisplayName(@NonNull CharSequence displayName) {
            this.checkNotUsed();
            this.mDisplayName = Objects.requireNonNull(displayName);
            return this;
        }

        @RequiresPermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
        @NonNull
        public Builder setSelfManaged(boolean selfManaged) {
            this.checkNotUsed();
            this.mSelfManaged = selfManaged;
            return this;
        }

        @RequiresPermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
        @NonNull
        public Builder setForceConfirmation(boolean forceConfirmation) {
            this.checkNotUsed();
            this.mForceConfirmation = forceConfirmation;
            return this;
        }

        @RequiresPermission(value="android.permission.ASSOCIATE_COMPANION_DEVICES")
        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public Builder setSkipRoleGrant(boolean skipRoleGrant) {
            this.checkNotUsed();
            this.mSkipRoleGrant = skipRoleGrant;
            return this;
        }

        @NonNull
        @RequiresPermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
        @FlaggedApi(value="android.companion.association_device_icon")
        public Builder setDeviceIcon(@NonNull Icon deviceIcon) {
            this.checkNotUsed();
            this.mDeviceIcon = Objects.requireNonNull(deviceIcon);
            return this;
        }

        @Override
        @NonNull
        public AssociationRequest build() {
            this.markUsed();
            if (this.mSelfManaged && this.mDisplayName == null) {
                throw new IllegalStateException("Request for a self-managed association MUST provide the display name of the device");
            }
            return new AssociationRequest(this.mSingleDevice, CollectionUtils.emptyIfNull(this.mDeviceFilters), this.mDeviceProfile, this.mDisplayName, this.mSelfManaged, this.mForceConfirmation, this.mSkipRoleGrant, this.mDeviceIcon);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceProfile {
    }
}

