/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.MacAddress;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;
import java.util.Objects;

@FlaggedApi(value="android.companion.association_tag")
public class DeviceId
implements Parcelable {
    private static final int CUSTOM_ID_LENGTH_LIMIT = 1024;
    private final String mCustomId;
    private final MacAddress mMacAddress;
    @NonNull
    public static final Parcelable.Creator<DeviceId> CREATOR = new Parcelable.Creator<DeviceId>(){

        public DeviceId[] newArray(int size) {
            return new DeviceId[size];
        }

        @Override
        public DeviceId createFromParcel(@NonNull Parcel in) {
            return new DeviceId(in);
        }
    };

    public DeviceId(@Nullable String customId, @Nullable MacAddress macAddress) {
        this.mCustomId = customId;
        this.mMacAddress = macAddress;
    }

    public boolean isSameDevice(@Nullable DeviceId other) {
        if (other == null) {
            return false;
        }
        if (this.mCustomId != null && other.mCustomId != null) {
            return this.mCustomId.equals(other.mCustomId);
        }
        if (this.mMacAddress != null && other.mMacAddress != null) {
            return ((Object)this.mMacAddress).equals(other.mMacAddress);
        }
        return false;
    }

    @Nullable
    public String getMacAddressAsString() {
        return this.mMacAddress != null ? ((Object)this.mMacAddress).toString().toUpperCase(Locale.US) : null;
    }

    @Nullable
    public String getCustomId() {
        return this.mCustomId;
    }

    @Nullable
    public MacAddress getMacAddress() {
        return this.mMacAddress;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        if (this.mCustomId != null) {
            dest.writeInt(1);
            dest.writeString8(this.mCustomId);
        } else {
            dest.writeInt(0);
        }
        dest.writeTypedObject(this.mMacAddress, 0);
    }

    private DeviceId(@NonNull Parcel in) {
        int flg = in.readInt();
        this.mCustomId = flg == 1 ? in.readString8() : null;
        this.mMacAddress = in.readTypedObject(MacAddress.CREATOR);
    }

    public int hashCode() {
        return Objects.hash(this.mCustomId, this.mMacAddress);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeviceId)) {
            return false;
        }
        DeviceId that = (DeviceId)o;
        return Objects.equals(this.mCustomId, that.mCustomId) && Objects.equals(this.mMacAddress, that.mMacAddress);
    }

    public String toString() {
        return "DeviceId{,mCustomId= " + this.mCustomId + ",mMacAddress= " + this.mMacAddress + "}";
    }

    public static class Builder {
        private String mCustomId;
        private MacAddress mMacAddress;

        @NonNull
        public Builder setCustomId(@Nullable String customId) {
            if (customId != null && customId.length() > 1024) {
                throw new IllegalArgumentException("Length of the custom id must be at most 1024 characters");
            }
            this.mCustomId = customId;
            return this;
        }

        @NonNull
        public Builder setMacAddress(@Nullable MacAddress macAddress) {
            this.mMacAddress = macAddress;
            return this;
        }

        @NonNull
        public DeviceId build() {
            if (this.mCustomId == null && this.mMacAddress == null) {
                throw new IllegalArgumentException("At least one device id property must benon-null to build a DeviceId.");
            }
            return new DeviceId(this.mCustomId, this.mMacAddress);
        }
    }
}

