/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.provider.OneTimeUseBuilder;
import java.util.Objects;

@FlaggedApi(value="android.companion.device_presence")
public class ObservingDevicePresenceRequest
implements Parcelable {
    private final int mAssociationId;
    @Nullable
    private final ParcelUuid mUuid;
    private static final int PARCEL_UUID_NULL = 0;
    private static final int PARCEL_UUID_NOT_NULL = 1;
    @NonNull
    public static final Parcelable.Creator<ObservingDevicePresenceRequest> CREATOR = new Parcelable.Creator<ObservingDevicePresenceRequest>(){

        public ObservingDevicePresenceRequest[] newArray(int size) {
            return new ObservingDevicePresenceRequest[size];
        }

        @Override
        public ObservingDevicePresenceRequest createFromParcel(@NonNull Parcel in) {
            return new ObservingDevicePresenceRequest(in);
        }
    };

    private ObservingDevicePresenceRequest(int associationId, ParcelUuid uuid) {
        this.mAssociationId = associationId;
        this.mUuid = uuid;
    }

    private ObservingDevicePresenceRequest(@NonNull Parcel in) {
        this.mAssociationId = in.readInt();
        this.mUuid = in.readInt() == 0 ? null : ParcelUuid.CREATOR.createFromParcel(in);
    }

    public int getAssociationId() {
        return this.mAssociationId;
    }

    @Nullable
    public ParcelUuid getUuid() {
        return this.mUuid;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mAssociationId);
        if (this.mUuid == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            this.mUuid.writeToParcel(dest, flags);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "ObservingDevicePresenceRequest { Association Id= " + this.mAssociationId + ",ParcelUuid= " + this.mUuid + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObservingDevicePresenceRequest)) {
            return false;
        }
        ObservingDevicePresenceRequest that = (ObservingDevicePresenceRequest)o;
        return Objects.equals(this.mUuid, that.mUuid) && this.mAssociationId == that.mAssociationId;
    }

    public int hashCode() {
        return Objects.hash(this.mAssociationId, this.mUuid);
    }

    public static class Builder
    extends OneTimeUseBuilder<ObservingDevicePresenceRequest> {
        private int mAssociationId = -1;
        private ParcelUuid mUuid;

        @NonNull
        public Builder setAssociationId(int associationId) {
            this.checkNotUsed();
            this.mAssociationId = associationId;
            return this;
        }

        @NonNull
        @RequiresPermission(allOf={"android.permission.REQUEST_OBSERVE_DEVICE_UUID_PRESENCE", "android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_SCAN"})
        public Builder setUuid(@NonNull ParcelUuid uuid) {
            this.checkNotUsed();
            this.mUuid = uuid;
            return this;
        }

        @Override
        @NonNull
        public ObservingDevicePresenceRequest build() {
            this.markUsed();
            if (this.mUuid != null && this.mAssociationId != -1) {
                throw new IllegalStateException("Cannot observe device presence based on both ParcelUuid and association ID. Choose one or the other.");
            }
            if (this.mUuid == null && this.mAssociationId <= 0) {
                throw new IllegalStateException("Must provide either a ParcelUuid or a valid association ID to observe device presence.");
            }
            return new ObservingDevicePresenceRequest(this.mAssociationId, this.mUuid);
        }
    }
}

