/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.QueuedWork;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.Trace;
import android.os.UserHandle;
import android.ravenwood.annotation.RavenwoodKeep;
import android.ravenwood.annotation.RavenwoodKeepPartialClass;
import android.ravenwood.annotation.RavenwoodPartiallyAllowlisted;
import android.util.Log;
import com.android.internal.os.DebugStore;
import com.android.internal.os.Flags;

@RavenwoodPartiallyAllowlisted
@RavenwoodKeepPartialClass
public abstract class BroadcastReceiver {
    @UnsupportedAppUsage
    private PendingResult mPendingResult;
    private boolean mDebugUnregister;
    private static final boolean DEBUG_STORE_ENABLED = Flags.debugStoreEnabled();

    @RavenwoodKeep
    public BroadcastReceiver() {
    }

    public abstract void onReceive(Context var1, Intent var2);

    public PendingResult goAsync() {
        PendingResult res = this.mPendingResult;
        this.mPendingResult = null;
        if (DEBUG_STORE_ENABLED) {
            DebugStore.recordGoAsync(System.identityHashCode(res));
        }
        if (res != null && Trace.isTagEnabled(64L)) {
            res.mReceiverClassName = this.getClass().getName();
            Trace.traceCounter(64L, "BroadcastReceiver#goAsync#ClassName:" + res.mReceiverClassName, 1);
        }
        return res;
    }

    public IBinder peekService(Context myContext, Intent service) {
        IActivityManager am = ActivityManager.getService();
        IBinder binder = null;
        try {
            service.prepareToLeaveProcess(myContext);
            binder = am.peekService(service, service.resolveTypeIfNeeded(myContext.getContentResolver()), myContext.getOpPackageName());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return binder;
    }

    public void setResultCode(int code) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultCode = code;
    }

    public int getResultCode() {
        return this.mPendingResult != null ? this.mPendingResult.mResultCode : 0;
    }

    public void setResultData(String data) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultData = data;
    }

    public String getResultData() {
        return this.mPendingResult != null ? this.mPendingResult.mResultData : null;
    }

    public void setResultExtras(Bundle extras) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultExtras = extras;
    }

    public Bundle getResultExtras(boolean makeMap) {
        if (this.mPendingResult == null) {
            return null;
        }
        Bundle e = this.mPendingResult.mResultExtras;
        if (!makeMap) {
            return e;
        }
        if (e == null) {
            this.mPendingResult.mResultExtras = e = new Bundle();
        }
        return e;
    }

    public void setResult(int code, String data, Bundle extras) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultCode = code;
        this.mPendingResult.mResultData = data;
        this.mPendingResult.mResultExtras = extras;
    }

    public boolean getAbortBroadcast() {
        return this.mPendingResult != null ? this.mPendingResult.mAbortBroadcast : false;
    }

    public void abortBroadcast() {
        this.checkSynchronousHint();
        this.mPendingResult.mAbortBroadcast = true;
    }

    public void clearAbortBroadcast() {
        if (this.mPendingResult != null) {
            this.mPendingResult.mAbortBroadcast = false;
        }
    }

    public boolean isOrderedBroadcast() {
        return this.mPendingResult != null ? this.mPendingResult.mOrderedHint : false;
    }

    public boolean isInitialStickyBroadcast() {
        return this.mPendingResult != null ? this.mPendingResult.mInitialStickyHint : false;
    }

    public void setOrderedHint(boolean isOrdered) {
    }

    @UnsupportedAppUsage
    public void setPendingResult(PendingResult result) {
        this.mPendingResult = result;
    }

    @UnsupportedAppUsage
    public PendingResult getPendingResult() {
        return this.mPendingResult;
    }

    @SystemApi
    @NonNull
    public UserHandle getSendingUser() {
        return UserHandle.of(this.getSendingUserId());
    }

    public int getSendingUserId() {
        return this.mPendingResult.mSendingUser;
    }

    public int getSentFromUid() {
        return this.mPendingResult != null ? this.mPendingResult.mSentFromUid : -1;
    }

    @Nullable
    public String getSentFromPackage() {
        return this.mPendingResult != null ? this.mPendingResult.mSentFromPackage : null;
    }

    public void setDebugUnregister(boolean debug) {
        this.mDebugUnregister = debug;
    }

    public boolean getDebugUnregister() {
        return this.mDebugUnregister;
    }

    void checkSynchronousHint() {
        if (this.mPendingResult == null) {
            throw new IllegalStateException("Call while result is not pending");
        }
        if (this.mPendingResult.mOrderedHint || this.mPendingResult.mInitialStickyHint) {
            return;
        }
        RuntimeException e = new RuntimeException("BroadcastReceiver trying to return result during a non-ordered broadcast");
        Log.e("BroadcastReceiver", e.getMessage(), e);
    }

    public static class PendingResult {
        public static final int TYPE_COMPONENT = 0;
        public static final int TYPE_REGISTERED = 1;
        public static final int TYPE_UNREGISTERED = 2;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        final int mType;
        @UnsupportedAppUsage
        final boolean mOrderedHint;
        @UnsupportedAppUsage
        final boolean mInitialStickyHint;
        final boolean mAssumeDeliveredHint;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        final IBinder mToken;
        @UnsupportedAppUsage
        final int mSendingUser;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        final int mFlags;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        int mResultCode;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        String mResultData;
        @UnsupportedAppUsage
        Bundle mResultExtras;
        @UnsupportedAppUsage
        boolean mAbortBroadcast;
        @UnsupportedAppUsage
        boolean mFinished;
        String mReceiverClassName;
        final int mSentFromUid;
        final String mSentFromPackage;

        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        public PendingResult(int resultCode, String resultData, Bundle resultExtras, int type, boolean ordered, boolean sticky, IBinder token, int userId, int flags) {
            this(resultCode, resultData, resultExtras, type, ordered, sticky, PendingResult.guessAssumeDelivered(type, ordered), token, userId, flags, -1, null);
        }

        public PendingResult(int resultCode, String resultData, Bundle resultExtras, int type, boolean ordered, boolean sticky, boolean assumeDelivered, IBinder token, int userId, int flags, int sentFromUid, String sentFromPackage) {
            this.mResultCode = resultCode;
            this.mResultData = resultData;
            this.mResultExtras = resultExtras;
            this.mType = type;
            this.mOrderedHint = ordered;
            this.mInitialStickyHint = sticky;
            this.mAssumeDeliveredHint = assumeDelivered;
            this.mToken = token;
            this.mSendingUser = userId;
            this.mFlags = flags;
            this.mSentFromUid = sentFromUid;
            this.mSentFromPackage = sentFromPackage;
        }

        public static boolean guessAssumeDelivered(int type, boolean ordered) {
            if (type == 0) {
                return false;
            }
            return !ordered || type == 2;
        }

        public void setResultCode(int code) {
            this.checkSynchronousHint();
            this.mResultCode = code;
        }

        public int getResultCode() {
            return this.mResultCode;
        }

        public void setResultData(String data) {
            this.checkSynchronousHint();
            this.mResultData = data;
        }

        public String getResultData() {
            return this.mResultData;
        }

        public void setResultExtras(Bundle extras) {
            this.checkSynchronousHint();
            this.mResultExtras = extras;
        }

        public Bundle getResultExtras(boolean makeMap) {
            Bundle e = this.mResultExtras;
            if (!makeMap) {
                return e;
            }
            if (e == null) {
                this.mResultExtras = e = new Bundle();
            }
            return e;
        }

        public void setResult(int code, String data, Bundle extras) {
            this.checkSynchronousHint();
            this.mResultCode = code;
            this.mResultData = data;
            this.mResultExtras = extras;
        }

        public boolean getAbortBroadcast() {
            return this.mAbortBroadcast;
        }

        public void abortBroadcast() {
            this.checkSynchronousHint();
            this.mAbortBroadcast = true;
        }

        public void clearAbortBroadcast() {
            this.mAbortBroadcast = false;
        }

        public void finish() {
            if (Trace.isTagEnabled(64L)) {
                Trace.traceCounter(64L, "PendingResult#finish#ClassName:" + this.mReceiverClassName, 1);
            }
            if (DEBUG_STORE_ENABLED) {
                DebugStore.recordFinish(System.identityHashCode(this));
            }
            if (this.mType == 0) {
                final IActivityManager mgr = ActivityManager.getService();
                if (QueuedWork.hasPendingWork()) {
                    QueuedWork.queue(new Runnable(){

                        @Override
                        public void run() {
                            this.sendFinished(mgr);
                        }
                    }, false);
                } else {
                    this.sendFinished(mgr);
                }
            } else {
                IActivityManager mgr = ActivityManager.getService();
                this.sendFinished(mgr);
            }
        }

        public void setExtrasClassLoader(ClassLoader cl) {
            if (this.mResultExtras != null) {
                this.mResultExtras.setClassLoader(cl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendFinished(IActivityManager am) {
            PendingResult pendingResult = this;
            synchronized (pendingResult) {
                if (this.mFinished) {
                    throw new IllegalStateException("Broadcast already finished");
                }
                this.mFinished = true;
                try {
                    if (this.mResultExtras != null) {
                        this.mResultExtras.setAllowFds(false);
                    }
                    if (!this.mAssumeDeliveredHint) {
                        if (this.mOrderedHint) {
                            am.finishReceiver(this.mToken, this.mResultCode, this.mResultData, this.mResultExtras, this.mAbortBroadcast, this.mFlags);
                        } else {
                            am.finishReceiver(this.mToken, 0, null, null, false, this.mFlags);
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public int getSendingUserId() {
            return this.mSendingUser;
        }

        public int getSentFromUid() {
            return this.mSentFromUid;
        }

        public String getSentFromPackage() {
            return this.mSentFromPackage;
        }

        void checkSynchronousHint() {
            if (this.mOrderedHint || this.mInitialStickyHint) {
                return;
            }
            RuntimeException e = new RuntimeException("BroadcastReceiver trying to return result during a non-ordered broadcast");
            Log.e("BroadcastReceiver", e.getMessage(), e);
        }
    }
}

