/*
 * Decompiled with CFR 0.152.
 */
package android.content.om;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.om.FabricatedOverlay;
import android.content.om.OverlayConstraint;
import android.content.om.OverlayIdentifier;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class OverlayManagerTransaction
implements Parcelable {
    private final List<Request> mRequests;
    private final boolean mSelfTargeting;
    @NonNull
    public static final Parcelable.Creator<OverlayManagerTransaction> CREATOR = new Parcelable.Creator<OverlayManagerTransaction>(){

        @Override
        public OverlayManagerTransaction createFromParcel(Parcel source) {
            return new OverlayManagerTransaction(source);
        }

        public OverlayManagerTransaction[] newArray(int size) {
            return new OverlayManagerTransaction[size];
        }
    };

    private OverlayManagerTransaction(@NonNull List<Request> requests, boolean selfTargeting) {
        Objects.requireNonNull(requests);
        if (requests.contains(null)) {
            throw new IllegalArgumentException("null request");
        }
        this.mRequests = requests;
        this.mSelfTargeting = selfTargeting;
    }

    @NonNull
    public static OverlayManagerTransaction newInstance() {
        return new OverlayManagerTransaction(new ArrayList<Request>(), true);
    }

    private OverlayManagerTransaction(@NonNull Parcel source) {
        int size = source.readInt();
        this.mRequests = new ArrayList<Request>(size);
        for (int i = 0; i < size; ++i) {
            int request = source.readInt();
            OverlayIdentifier overlay = source.readParcelable(null, OverlayIdentifier.class);
            int userId = source.readInt();
            Bundle extras = source.readBundle(null);
            OverlayConstraint[] constraints = source.createTypedArray(OverlayConstraint.CREATOR);
            this.mRequests.add(new Request(request, overlay, userId, extras, Arrays.asList(constraints)));
        }
        this.mSelfTargeting = false;
    }

    @SystemApi(client=SystemApi.Client.SYSTEM_SERVER)
    @SuppressLint(value={"ReferencesHidden"})
    @NonNull
    public Iterator<Request> getRequests() {
        return this.mRequests.iterator();
    }

    public String toString() {
        return String.format("OverlayManagerTransaction { mRequests = %s }", this.mRequests);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        int size = this.mRequests.size();
        dest.writeInt(size);
        for (int i = 0; i < size; ++i) {
            Request req = this.mRequests.get(i);
            dest.writeInt(req.type);
            dest.writeParcelable(req.overlay, flags);
            dest.writeInt(req.userId);
            dest.writeBundle(req.extras);
            dest.writeTypedArray(req.constraints.toArray(new OverlayConstraint[0]), flags);
        }
    }

    private static Request generateRegisterFabricatedOverlayRequest(@NonNull FabricatedOverlay overlay) {
        Objects.requireNonNull(overlay);
        Bundle extras = new Bundle();
        extras.putParcelable("fabricated_overlay", overlay.mOverlay);
        return new Request(2, overlay.getIdentifier(), -1, extras);
    }

    private static Request generateUnRegisterFabricatedOverlayRequest(@NonNull OverlayIdentifier overlayIdentifier) {
        Objects.requireNonNull(overlayIdentifier);
        return new Request(3, overlayIdentifier, -1);
    }

    @NonNull
    public void registerFabricatedOverlay(@NonNull FabricatedOverlay overlay) {
        this.mRequests.add(OverlayManagerTransaction.generateRegisterFabricatedOverlayRequest(overlay));
    }

    @NonNull
    public void unregisterFabricatedOverlay(@NonNull OverlayIdentifier overlay) {
        this.mRequests.add(OverlayManagerTransaction.generateUnRegisterFabricatedOverlayRequest(overlay));
    }

    boolean isSelfTargeting() {
        return this.mSelfTargeting;
    }

    @SystemApi(client=SystemApi.Client.SYSTEM_SERVER)
    public static class Request {
        public static final int TYPE_SET_ENABLED = 0;
        public static final int TYPE_SET_DISABLED = 1;
        public static final int TYPE_REGISTER_FABRICATED = 2;
        public static final int TYPE_UNREGISTER_FABRICATED = 3;
        public static final String BUNDLE_FABRICATED_OVERLAY = "fabricated_overlay";
        public final int type;
        @NonNull
        public final OverlayIdentifier overlay;
        public final int userId;
        @SuppressLint(value={"NullableCollection"})
        @Nullable
        public final Bundle extras;
        @NonNull
        public final List<OverlayConstraint> constraints;

        public Request(int type, @NonNull OverlayIdentifier overlay, int userId) {
            this(type, overlay, userId, null, Collections.emptyList());
        }

        public Request(int type, @NonNull OverlayIdentifier overlay, int userId, @Nullable Bundle extras) {
            this(type, overlay, userId, extras, Collections.emptyList());
        }

        public Request(int type, @NonNull OverlayIdentifier overlay, int userId, @NonNull List<OverlayConstraint> constraints) {
            this(type, overlay, userId, null, constraints);
        }

        public Request(int type, @NonNull OverlayIdentifier overlay, int userId, @Nullable Bundle extras, @NonNull List<OverlayConstraint> constraints) {
            this.type = type;
            this.overlay = overlay;
            this.userId = userId;
            this.extras = extras;
            Objects.requireNonNull(constraints);
            this.constraints = constraints;
        }

        public String toString() {
            return TextUtils.formatSimple("Request{type=0x%02x (%s), overlay=%s, userId=%d, constraints=%s}", this.type, this.typeToString(), this.overlay, this.userId, OverlayConstraint.constraintsToString(this.constraints));
        }

        public String typeToString() {
            switch (this.type) {
                case 0: {
                    return "TYPE_SET_ENABLED";
                }
                case 1: {
                    return "TYPE_SET_DISABLED";
                }
                case 2: {
                    return "TYPE_REGISTER_FABRICATED";
                }
                case 3: {
                    return "TYPE_UNREGISTER_FABRICATED";
                }
            }
            return String.format("TYPE_UNKNOWN (0x%02x)", this.type);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface RequestType {
        }
    }

    public static class Builder {
        private final List<Request> mRequests = new ArrayList<Request>();
        private boolean mSelfTargeting = false;

        public Builder setEnabled(@NonNull OverlayIdentifier overlay, boolean enable) {
            return this.setEnabled(overlay, enable, UserHandle.myUserId());
        }

        public Builder setEnabled(@NonNull OverlayIdentifier overlay, boolean enable, @NonNull List<OverlayConstraint> constraints) {
            return this.setEnabled(overlay, enable, UserHandle.myUserId(), constraints);
        }

        public Builder setEnabled(@NonNull OverlayIdentifier overlay, boolean enable, int userId) {
            return this.setEnabled(overlay, enable, userId, Collections.emptyList());
        }

        public Builder setEnabled(@NonNull OverlayIdentifier overlay, boolean enable, int userId, @NonNull List<OverlayConstraint> constraints) {
            Objects.requireNonNull(overlay);
            int type = enable ? 0 : 1;
            this.mRequests.add(new Request(type, overlay, userId, constraints));
            return this;
        }

        public Builder setSelfTargeting(boolean selfTargeting) {
            this.mSelfTargeting = selfTargeting;
            return this;
        }

        @NonNull
        public Builder registerFabricatedOverlay(@NonNull FabricatedOverlay overlay) {
            this.mRequests.add(OverlayManagerTransaction.generateRegisterFabricatedOverlayRequest(overlay));
            return this;
        }

        @NonNull
        public Builder unregisterFabricatedOverlay(@NonNull OverlayIdentifier overlay) {
            this.mRequests.add(OverlayManagerTransaction.generateUnRegisterFabricatedOverlayRequest(overlay));
            return this;
        }

        @NonNull
        public OverlayManagerTransaction build() {
            return new OverlayManagerTransaction(this.mRequests, this.mSelfTargeting);
        }
    }
}

