/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.pm.DataLoaderParamsParcel;
import android.content.pm.DataLoaderType;

@SystemApi
public class DataLoaderParams {
    @NonNull
    private final DataLoaderParamsParcel mData;

    @NonNull
    public static DataLoaderParams forStreaming(@NonNull ComponentName componentName, @NonNull String arguments) {
        return new DataLoaderParams(1, componentName, arguments);
    }

    @SystemApi
    @NonNull
    public static DataLoaderParams forIncremental(@NonNull ComponentName componentName, @NonNull String arguments) {
        return new DataLoaderParams(2, componentName, arguments);
    }

    public DataLoaderParams(@NonNull @DataLoaderType int type, @NonNull ComponentName componentName, @NonNull String arguments) {
        DataLoaderParamsParcel data = new DataLoaderParamsParcel();
        data.type = type;
        data.packageName = componentName.getPackageName();
        data.className = componentName.getClassName();
        data.arguments = arguments;
        this.mData = data;
    }

    DataLoaderParams(@NonNull DataLoaderParamsParcel data) {
        this.mData = data;
    }

    @NonNull
    public DataLoaderParamsParcel getData() {
        return this.mData;
    }

    @NonNull
    @DataLoaderType
    public int getType() {
        return this.mData.type;
    }

    @NonNull
    public ComponentName getComponentName() {
        return new ComponentName(this.mData.packageName, this.mData.className);
    }

    @NonNull
    public String getArguments() {
        return this.mData.arguments;
    }
}

