/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LauncherActivityInfoInternal;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.icu.text.UnicodeSet;
import android.os.UserHandle;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.content.pm.Flags;
import java.util.Objects;

public class LauncherActivityInfo {
    private final PackageManager mPm;
    private final LauncherActivityInfoInternal mInternal;
    private static final UnicodeSet INVISIBLE_CHARACTERS = new UnicodeSet("[[:White_Space:][:Default_Ignorable_Code_Point:][:gc=Cc:]]", false).freeze();
    private static final int PREFIX_CONSECUTIVE_INVISIBLE_CHARACTERS_MAXIMUM = 3;

    LauncherActivityInfo(Context context, LauncherActivityInfoInternal internal) {
        this.mPm = context.getPackageManager();
        this.mInternal = internal;
    }

    public ComponentName getComponentName() {
        return this.mInternal.getComponentName();
    }

    public UserHandle getUser() {
        return this.mInternal.getUser();
    }

    public CharSequence getLabel() {
        if (!Flags.lightweightInvisibleLabelDetection()) {
            return this.getActivityInfo().loadLabel(this.mPm);
        }
        String label = this.getActivityInfo().loadLabel(this.mPm).toString().trim();
        if (LauncherActivityInfo.isVisible(label)) {
            return label;
        }
        label = this.getApplicationInfo().loadLabel(this.mPm).toString().trim();
        if (LauncherActivityInfo.isVisible(label)) {
            return label;
        }
        return this.getComponentName().getPackageName();
    }

    public float getLoadingProgress() {
        return this.mInternal.getIncrementalStatesInfo().getProgress();
    }

    public Drawable getIcon(int density) {
        int iconRes = this.getActivityInfo().getIconResource();
        Drawable icon = null;
        if (density != 0 && iconRes != 0) {
            try {
                Resources resources = this.mPm.getResourcesForApplication(this.getActivityInfo().applicationInfo);
                icon = resources.getDrawableForDensity(iconRes, density);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException exception) {
                // empty catch block
            }
        }
        if (icon == null) {
            icon = this.getActivityInfo().loadIcon(this.mPm);
        }
        return icon;
    }

    public int getApplicationFlags() {
        return this.getActivityInfo().flags;
    }

    @NonNull
    public ActivityInfo getActivityInfo() {
        return this.mInternal.getActivityInfo();
    }

    public ApplicationInfo getApplicationInfo() {
        return this.getActivityInfo().applicationInfo;
    }

    public long getFirstInstallTime() {
        try {
            return this.mPm.getPackageInfo((String)this.getActivityInfo().packageName, (int)8192).firstInstallTime;
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            return 0L;
        }
    }

    public String getName() {
        return this.getActivityInfo().name;
    }

    public Drawable getBadgedIcon(int density) {
        Drawable originalIcon = this.getIcon(density);
        return this.mPm.getUserBadgedIcon(originalIcon, this.mInternal.getUser());
    }

    public boolean supportsMultiInstance() {
        return this.mInternal.supportsMultiInstance();
    }

    @VisibleForTesting
    public static boolean isVisible(@NonNull CharSequence sequence) {
        Objects.requireNonNull(sequence);
        if (TextUtils.isEmpty(sequence)) {
            return false;
        }
        Paint paint = new Paint();
        int invisibleCharCount = 0;
        int notSupportedCharCount = 0;
        int[] codePoints = sequence.codePoints().toArray();
        int length = codePoints.length;
        for (int i = 0; i < length; ++i) {
            String ch = new String(new int[]{codePoints[i]}, 0, 1);
            if (INVISIBLE_CHARACTERS.contains(ch)) {
                if (notSupportedCharCount != 0 || ++invisibleCharCount < 3) continue;
                return false;
            }
            if (paint.hasGlyph(ch)) break;
            ++notSupportedCharCount;
        }
        return invisibleCharCount + notSupportedCharCount < codePoints.length;
    }
}

