/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageManager;
import android.util.ArrayMap;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;

public class SystemFeaturesCache {
    private static final int UNAVAILABLE_FEATURE_VERSION = Integer.MIN_VALUE;
    private static volatile SystemFeaturesCache sInstance;
    @NonNull
    private final int[] mSdkFeatureVersions;

    public static void setInstance(SystemFeaturesCache instance) {
        if (sInstance != null) {
            throw new IllegalStateException("SystemFeaturesCache instance already initialized.");
        }
        sInstance = instance;
    }

    @NonNull
    public static SystemFeaturesCache getInstance() {
        SystemFeaturesCache instance = sInstance;
        if (instance == null) {
            throw new IllegalStateException("SystemFeaturesCache not initialized");
        }
        return instance;
    }

    public static boolean hasInstance() {
        return sInstance != null;
    }

    @VisibleForTesting
    public static void clearInstance() {
        sInstance = null;
    }

    public SystemFeaturesCache(@NonNull ArrayMap<String, FeatureInfo> availableFeatures) {
        this(availableFeatures.values());
    }

    @VisibleForTesting
    public SystemFeaturesCache(@NonNull Collection<FeatureInfo> availableFeatures) {
        this.mSdkFeatureVersions = new int[186];
        Arrays.fill(this.mSdkFeatureVersions, Integer.MIN_VALUE);
        for (FeatureInfo fi : availableFeatures) {
            int sdkFeatureIndex = PackageManager.maybeGetSdkFeatureIndex(fi.name);
            if (sdkFeatureIndex < 0) continue;
            this.mSdkFeatureVersions[sdkFeatureIndex] = fi.version;
        }
    }

    public SystemFeaturesCache(@NonNull int[] sdkFeatureVersions) {
        if (sdkFeatureVersions.length != 186) {
            throw new IllegalArgumentException(String.format("Unexpected cached SDK feature count: %d (expected %d)", sdkFeatureVersions.length, 186));
        }
        this.mSdkFeatureVersions = sdkFeatureVersions;
    }

    public int[] getSdkFeatureVersions() {
        return this.mSdkFeatureVersions;
    }

    public Boolean maybeHasFeature(@NonNull String featureName, int version) {
        int sdkFeatureIndex = PackageManager.maybeGetSdkFeatureIndex(featureName);
        if (sdkFeatureIndex < 0) {
            return null;
        }
        if (version == Integer.MIN_VALUE && this.mSdkFeatureVersions[sdkFeatureIndex] == Integer.MIN_VALUE) {
            return null;
        }
        return this.mSdkFeatureVersions[sdkFeatureIndex] >= version;
    }
}

