/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.ArchivedPackageParcel;
import android.content.pm.PackageInfo;
import android.content.pm.SharedLibraryInfo;
import android.content.pm.SigningDetails;
import android.content.pm.VerifierInfo;
import android.content.pm.parsing.ApkLite;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class PackageLite {
    @NonNull
    private final String mPackageName;
    @NonNull
    private final String mPath;
    @NonNull
    private final String mBaseApkPath;
    @Nullable
    private final String[] mSplitApkPaths;
    @Nullable
    private final String[] mSplitNames;
    @Nullable
    private final String[] mUsesSplitNames;
    @Nullable
    private final String[] mConfigForSplit;
    @Nullable
    private final Set<String> mBaseRequiredSplitTypes;
    @Nullable
    private final Set<String>[] mRequiredSplitTypes;
    @Nullable
    private final Set<String>[] mSplitTypes;
    private final int mVersionCodeMajor;
    private final int mVersionCode;
    private final int mTargetSdk;
    private final int mBaseRevisionCode;
    @Nullable
    private final int[] mSplitRevisionCodes;
    private final int mInstallLocation;
    @NonNull
    private final VerifierInfo[] mVerifiers;
    @NonNull
    private final SigningDetails mSigningDetails;
    @Nullable
    private final boolean[] mIsFeatureSplits;
    private final boolean mIsolatedSplits;
    private final boolean mSplitRequired;
    private final boolean mCoreApp;
    private final boolean mDebuggable;
    private final boolean mMultiArch;
    private final boolean mUse32bitAbi;
    private final boolean mExtractNativeLibs;
    private final boolean mProfileableByShell;
    private final boolean mUseEmbeddedDex;
    private final boolean mIsSdkLibrary;
    private final boolean mIsStaticLibrary;
    @NonNull
    private final List<String> mUsesSdkLibraries;
    @Nullable
    private final long[] mUsesSdkLibrariesVersionsMajor;
    @Nullable
    private final String[][] mUsesSdkLibrariesCertDigests;
    @NonNull
    private final List<String> mUsesStaticLibraries;
    @Nullable
    private final long[] mUsesStaticLibrariesVersions;
    @Nullable
    private final String[][] mUsesStaticLibrariesCertDigests;
    @NonNull
    private final List<SharedLibraryInfo> mDeclaredLibraries;
    @Nullable
    private final ArchivedPackageParcel mArchivedPackage;
    private final int mPageSizeCompat;

    public PackageLite(String path, String baseApkPath, ApkLite baseApk, String[] splitNames, boolean[] isFeatureSplits, String[] usesSplitNames, String[] configForSplit, String[] splitApkPaths, int[] splitRevisionCodes, int targetSdk, Set<String>[] requiredSplitTypes, Set<String>[] splitTypes) {
        this.mPath = path;
        this.mBaseApkPath = baseApkPath;
        this.mPackageName = baseApk.getPackageName();
        this.mVersionCode = baseApk.getVersionCode();
        this.mVersionCodeMajor = baseApk.getVersionCodeMajor();
        this.mInstallLocation = baseApk.getInstallLocation();
        this.mVerifiers = baseApk.getVerifiers();
        this.mSigningDetails = baseApk.getSigningDetails();
        this.mBaseRevisionCode = baseApk.getRevisionCode();
        this.mCoreApp = baseApk.isCoreApp();
        this.mDebuggable = baseApk.isDebuggable();
        this.mMultiArch = baseApk.isMultiArch();
        this.mUse32bitAbi = baseApk.isUse32bitAbi();
        this.mExtractNativeLibs = baseApk.isExtractNativeLibs();
        this.mIsolatedSplits = baseApk.isIsolatedSplits();
        this.mUseEmbeddedDex = baseApk.isUseEmbeddedDex();
        this.mBaseRequiredSplitTypes = baseApk.getRequiredSplitTypes();
        this.mRequiredSplitTypes = requiredSplitTypes;
        this.mSplitRequired = baseApk.isSplitRequired() || this.hasAnyRequiredSplitTypes();
        this.mProfileableByShell = baseApk.isProfileableByShell();
        this.mIsSdkLibrary = baseApk.isIsSdkLibrary();
        this.mUsesSdkLibraries = baseApk.getUsesSdkLibraries();
        this.mUsesSdkLibrariesVersionsMajor = baseApk.getUsesSdkLibrariesVersionsMajor();
        this.mUsesSdkLibrariesCertDigests = baseApk.getUsesSdkLibrariesCertDigests();
        this.mIsStaticLibrary = baseApk.isIsStaticLibrary();
        this.mUsesStaticLibraries = baseApk.getUsesStaticLibraries();
        this.mUsesStaticLibrariesVersions = baseApk.getUsesStaticLibrariesVersions();
        this.mUsesStaticLibrariesCertDigests = baseApk.getUsesStaticLibrariesCertDigests();
        this.mSplitNames = splitNames;
        this.mSplitTypes = splitTypes;
        this.mIsFeatureSplits = isFeatureSplits;
        this.mUsesSplitNames = usesSplitNames;
        this.mConfigForSplit = configForSplit;
        this.mSplitApkPaths = splitApkPaths;
        this.mSplitRevisionCodes = splitRevisionCodes;
        this.mTargetSdk = targetSdk;
        this.mDeclaredLibraries = baseApk.getDeclaredLibraries();
        this.mArchivedPackage = baseApk.getArchivedPackage();
        this.mPageSizeCompat = baseApk.getPageSizeCompat();
    }

    public List<String> getAllApkPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(this.mBaseApkPath);
        if (!ArrayUtils.isEmpty(this.mSplitApkPaths)) {
            Collections.addAll(paths, this.mSplitApkPaths);
        }
        return paths;
    }

    public long getLongVersionCode() {
        return PackageInfo.composeLongVersionCode(this.mVersionCodeMajor, this.mVersionCode);
    }

    private boolean hasAnyRequiredSplitTypes() {
        if (!CollectionUtils.isEmpty(this.mBaseRequiredSplitTypes)) {
            return true;
        }
        return ArrayUtils.find(this.mRequiredSplitTypes, r -> !CollectionUtils.isEmpty(r)) != null;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public String getPath() {
        return this.mPath;
    }

    @NonNull
    public String getBaseApkPath() {
        return this.mBaseApkPath;
    }

    @Nullable
    public String[] getSplitApkPaths() {
        return this.mSplitApkPaths;
    }

    @Nullable
    public String[] getSplitNames() {
        return this.mSplitNames;
    }

    @Nullable
    public String[] getUsesSplitNames() {
        return this.mUsesSplitNames;
    }

    @Nullable
    public String[] getConfigForSplit() {
        return this.mConfigForSplit;
    }

    @Nullable
    public Set<String> getBaseRequiredSplitTypes() {
        return this.mBaseRequiredSplitTypes;
    }

    @Nullable
    public Set<String>[] getRequiredSplitTypes() {
        return this.mRequiredSplitTypes;
    }

    @Nullable
    public Set<String>[] getSplitTypes() {
        return this.mSplitTypes;
    }

    public int getVersionCodeMajor() {
        return this.mVersionCodeMajor;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getTargetSdk() {
        return this.mTargetSdk;
    }

    public int getBaseRevisionCode() {
        return this.mBaseRevisionCode;
    }

    @Nullable
    public int[] getSplitRevisionCodes() {
        return this.mSplitRevisionCodes;
    }

    public int getInstallLocation() {
        return this.mInstallLocation;
    }

    @NonNull
    public VerifierInfo[] getVerifiers() {
        return this.mVerifiers;
    }

    @NonNull
    public SigningDetails getSigningDetails() {
        return this.mSigningDetails;
    }

    @Nullable
    public boolean[] getIsFeatureSplits() {
        return this.mIsFeatureSplits;
    }

    public boolean isIsolatedSplits() {
        return this.mIsolatedSplits;
    }

    public boolean isSplitRequired() {
        return this.mSplitRequired;
    }

    public boolean isCoreApp() {
        return this.mCoreApp;
    }

    public boolean isDebuggable() {
        return this.mDebuggable;
    }

    public boolean isMultiArch() {
        return this.mMultiArch;
    }

    public boolean isUse32bitAbi() {
        return this.mUse32bitAbi;
    }

    public boolean isExtractNativeLibs() {
        return this.mExtractNativeLibs;
    }

    public boolean isProfileableByShell() {
        return this.mProfileableByShell;
    }

    public boolean isUseEmbeddedDex() {
        return this.mUseEmbeddedDex;
    }

    public boolean isIsSdkLibrary() {
        return this.mIsSdkLibrary;
    }

    public boolean isIsStaticLibrary() {
        return this.mIsStaticLibrary;
    }

    @NonNull
    public List<String> getUsesSdkLibraries() {
        return this.mUsesSdkLibraries;
    }

    @Nullable
    public long[] getUsesSdkLibrariesVersionsMajor() {
        return this.mUsesSdkLibrariesVersionsMajor;
    }

    @Nullable
    public String[][] getUsesSdkLibrariesCertDigests() {
        return this.mUsesSdkLibrariesCertDigests;
    }

    @NonNull
    public List<String> getUsesStaticLibraries() {
        return this.mUsesStaticLibraries;
    }

    @Nullable
    public long[] getUsesStaticLibrariesVersions() {
        return this.mUsesStaticLibrariesVersions;
    }

    @Nullable
    public String[][] getUsesStaticLibrariesCertDigests() {
        return this.mUsesStaticLibrariesCertDigests;
    }

    @NonNull
    public List<SharedLibraryInfo> getDeclaredLibraries() {
        return this.mDeclaredLibraries;
    }

    @Nullable
    public ArchivedPackageParcel getArchivedPackage() {
        return this.mArchivedPackage;
    }

    public int getPageSizeCompat() {
        return this.mPageSizeCompat;
    }

    @Deprecated
    private void __metadata() {
    }
}

