/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.split;

import android.annotation.NonNull;
import android.content.pm.parsing.PackageLite;
import android.util.IntArray;
import android.util.SparseArray;
import java.util.Arrays;
import java.util.BitSet;
import libcore.util.EmptyArray;

public abstract class SplitDependencyLoader<E extends Exception> {
    @NonNull
    private final SparseArray<int[]> mDependencies;

    protected SplitDependencyLoader(@NonNull SparseArray<int[]> dependencies) {
        this.mDependencies = dependencies;
    }

    protected void loadDependenciesForSplit(int splitIdx) throws E {
        int[] deps;
        if (this.isSplitCached(splitIdx)) {
            return;
        }
        if (splitIdx == 0) {
            int[] configSplitIndices = this.collectConfigSplitIndices(0);
            this.constructSplit(0, configSplitIndices, -1);
            return;
        }
        IntArray linearDependencies = new IntArray();
        linearDependencies.add(splitIdx);
        while ((splitIdx = (deps = this.mDependencies.get(splitIdx)) != null && deps.length > 0 ? deps[0] : -1) >= 0 && !this.isSplitCached(splitIdx)) {
            linearDependencies.add(splitIdx);
        }
        int parentIdx = splitIdx;
        for (int i = linearDependencies.size() - 1; i >= 0; --i) {
            int idx = linearDependencies.get(i);
            int[] configSplitIndices = this.collectConfigSplitIndices(idx);
            this.constructSplit(idx, configSplitIndices, parentIdx);
            parentIdx = idx;
        }
    }

    @NonNull
    private int[] collectConfigSplitIndices(int splitIdx) {
        int[] deps = this.mDependencies.get(splitIdx);
        if (deps == null || deps.length <= 1) {
            return EmptyArray.INT;
        }
        return Arrays.copyOfRange(deps, 1, deps.length);
    }

    protected abstract boolean isSplitCached(int var1);

    protected abstract void constructSplit(int var1, @NonNull int[] var2, int var3) throws E;

    private static int[] append(int[] src, int elem) {
        if (src == null) {
            return new int[]{elem};
        }
        int[] dst = Arrays.copyOf(src, src.length + 1);
        dst[src.length] = elem;
        return dst;
    }

    @NonNull
    public static SparseArray<int[]> createDependenciesFromPackage(PackageLite pkg) throws IllegalDependencyException {
        int splitIdx;
        SparseArray<int[]> splitDependencies = new SparseArray<int[]>();
        splitDependencies.put(0, new int[]{-1});
        for (splitIdx = 0; splitIdx < pkg.getSplitNames().length; ++splitIdx) {
            int targetIdx;
            if (!pkg.getIsFeatureSplits()[splitIdx]) continue;
            String splitDependency = pkg.getUsesSplitNames()[splitIdx];
            if (splitDependency != null) {
                int depIdx = Arrays.binarySearch(pkg.getSplitNames(), splitDependency);
                if (depIdx < 0) {
                    throw new IllegalDependencyException("Split '" + pkg.getSplitNames()[splitIdx] + "' requires split '" + splitDependency + "', which is missing.");
                }
                targetIdx = depIdx + 1;
            } else {
                targetIdx = 0;
            }
            splitDependencies.put(splitIdx + 1, new int[]{targetIdx});
        }
        int size = pkg.getSplitNames().length;
        for (splitIdx = 0; splitIdx < size; ++splitIdx) {
            int targetSplitIdx;
            if (pkg.getIsFeatureSplits()[splitIdx]) continue;
            String configForSplit = pkg.getConfigForSplit()[splitIdx];
            if (configForSplit != null) {
                int depIdx = Arrays.binarySearch(pkg.getSplitNames(), configForSplit);
                if (depIdx < 0) {
                    throw new IllegalDependencyException("Split '" + pkg.getSplitNames()[splitIdx] + "' targets split '" + configForSplit + "', which is missing.");
                }
                if (!pkg.getIsFeatureSplits()[depIdx]) {
                    throw new IllegalDependencyException("Split '" + pkg.getSplitNames()[splitIdx] + "' declares itself as configuration split for a non-feature split '" + pkg.getSplitNames()[depIdx] + "'");
                }
                targetSplitIdx = depIdx + 1;
            } else {
                targetSplitIdx = 0;
            }
            splitDependencies.put(targetSplitIdx, SplitDependencyLoader.append(splitDependencies.get(targetSplitIdx), splitIdx + 1));
        }
        BitSet bitset = new BitSet();
        int size2 = splitDependencies.size();
        for (int i = 0; i < size2; ++i) {
            int splitIdx2 = splitDependencies.keyAt(i);
            bitset.clear();
            while (splitIdx2 != -1) {
                if (bitset.get(splitIdx2)) {
                    throw new IllegalDependencyException("Cycle detected in split dependencies.");
                }
                bitset.set(splitIdx2);
                int[] deps = splitDependencies.get(splitIdx2);
                splitIdx2 = deps != null ? deps[0] : -1;
            }
        }
        return splitDependencies;
    }

    public static class IllegalDependencyException
    extends Exception {
        private IllegalDependencyException(String message) {
            super(message);
        }
    }
}

