/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.verify.domain;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.content.UriRelativeFilterGroup;
import android.content.UriRelativeFilterGroupParcel;
import android.content.pm.PackageManager;
import android.content.pm.verify.domain.DomainOwner;
import android.content.pm.verify.domain.DomainSet;
import android.content.pm.verify.domain.DomainVerificationInfo;
import android.content.pm.verify.domain.DomainVerificationUserState;
import android.content.pm.verify.domain.IDomainVerificationManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.ArrayMap;
import com.android.internal.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;

public class DomainVerificationManager {
    @SystemApi
    public static final String EXTRA_VERIFICATION_REQUEST = "android.content.pm.verify.domain.extra.VERIFICATION_REQUEST";
    @SystemApi
    public static final int STATUS_OK = 0;
    @SystemApi
    public static final int ERROR_DOMAIN_SET_ID_INVALID = 1;
    @SystemApi
    public static final int ERROR_UNKNOWN_DOMAIN = 2;
    @SystemApi
    public static final int ERROR_UNABLE_TO_APPROVE = 3;
    public static final int INTERNAL_ERROR_NAME_NOT_FOUND = 1;
    private final Context mContext;
    private final IDomainVerificationManager mDomainVerificationManager;

    public DomainVerificationManager(Context context, IDomainVerificationManager domainVerificationManager) {
        this.mContext = context;
        this.mDomainVerificationManager = domainVerificationManager;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.DOMAIN_VERIFICATION_AGENT")
    @FlaggedApi(value="android.content.pm.relative_reference_intent_filters")
    public void setUriRelativeFilterGroups(@NonNull String packageName, @NonNull Map<String, List<UriRelativeFilterGroup>> domainToGroupsMap) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(domainToGroupsMap);
        Bundle bundle = new Bundle();
        for (String domain : domainToGroupsMap.keySet()) {
            List<UriRelativeFilterGroup> groups = domainToGroupsMap.get(domain);
            bundle.putParcelableList(domain, UriRelativeFilterGroup.groupsToParcels(groups));
        }
        try {
            this.mDomainVerificationManager.setUriRelativeFilterGroups(packageName, bundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @FlaggedApi(value="android.content.pm.relative_reference_intent_filters")
    public Map<String, List<UriRelativeFilterGroup>> getUriRelativeFilterGroups(@NonNull String packageName, @NonNull List<String> domains) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(domains);
        if (domains.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            Bundle bundle = this.mDomainVerificationManager.getUriRelativeFilterGroups(packageName, domains);
            ArrayMap<String, List<UriRelativeFilterGroup>> map = new ArrayMap<String, List<UriRelativeFilterGroup>>();
            if (!bundle.isEmpty()) {
                for (String domain : bundle.keySet()) {
                    ArrayList<UriRelativeFilterGroupParcel> parcels = bundle.getParcelableArrayList(domain, UriRelativeFilterGroupParcel.class);
                    map.put(domain, UriRelativeFilterGroup.parcelsToGroups(parcels));
                }
            }
            return map;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.DOMAIN_VERIFICATION_AGENT")
    public List<String> queryValidVerificationPackageNames() {
        try {
            return this.mDomainVerificationManager.queryValidVerificationPackageNames();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Nullable
    @RequiresPermission(value="android.permission.DOMAIN_VERIFICATION_AGENT")
    public DomainVerificationInfo getDomainVerificationInfo(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        try {
            return this.mDomainVerificationManager.getDomainVerificationInfo(packageName);
        }
        catch (Exception e) {
            Exception converted = this.rethrow(e, packageName);
            if (converted instanceof PackageManager.NameNotFoundException) {
                throw (PackageManager.NameNotFoundException)converted;
            }
            if (converted instanceof RuntimeException) {
                throw (RuntimeException)converted;
            }
            throw new RuntimeException(converted);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.DOMAIN_VERIFICATION_AGENT")
    public int setDomainVerificationStatus(@NonNull UUID domainSetId, @NonNull Set<String> domains, int state) throws PackageManager.NameNotFoundException {
        this.validateInput(domainSetId, domains);
        try {
            return this.mDomainVerificationManager.setDomainVerificationStatus(((Object)domainSetId).toString(), new DomainSet(domains), state);
        }
        catch (Exception e) {
            Exception converted = this.rethrow(e, null);
            if (converted instanceof PackageManager.NameNotFoundException) {
                throw (PackageManager.NameNotFoundException)converted;
            }
            if (converted instanceof RuntimeException) {
                throw (RuntimeException)converted;
            }
            throw new RuntimeException(converted);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DOMAIN_VERIFICATION_USER_SELECTION")
    public void setDomainVerificationLinkHandlingAllowed(@NonNull String packageName, boolean allowed) throws PackageManager.NameNotFoundException {
        try {
            this.mDomainVerificationManager.setDomainVerificationLinkHandlingAllowed(packageName, allowed, this.mContext.getUserId());
        }
        catch (Exception e) {
            Exception converted = this.rethrow(e, null);
            if (converted instanceof PackageManager.NameNotFoundException) {
                throw (PackageManager.NameNotFoundException)converted;
            }
            if (converted instanceof RuntimeException) {
                throw (RuntimeException)converted;
            }
            throw new RuntimeException(converted);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DOMAIN_VERIFICATION_USER_SELECTION")
    public int setDomainVerificationUserSelection(@NonNull UUID domainSetId, @NonNull Set<String> domains, boolean enabled) throws PackageManager.NameNotFoundException {
        this.validateInput(domainSetId, domains);
        try {
            return this.mDomainVerificationManager.setDomainVerificationUserSelection(((Object)domainSetId).toString(), new DomainSet(domains), enabled, this.mContext.getUserId());
        }
        catch (Exception e) {
            Exception converted = this.rethrow(e, null);
            if (converted instanceof PackageManager.NameNotFoundException) {
                throw (PackageManager.NameNotFoundException)converted;
            }
            if (converted instanceof RuntimeException) {
                throw (RuntimeException)converted;
            }
            throw new RuntimeException(converted);
        }
    }

    @Nullable
    public DomainVerificationUserState getDomainVerificationUserState(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        try {
            return this.mDomainVerificationManager.getDomainVerificationUserState(packageName, this.mContext.getUserId());
        }
        catch (Exception e) {
            Exception converted = this.rethrow(e, packageName);
            if (converted instanceof PackageManager.NameNotFoundException) {
                throw (PackageManager.NameNotFoundException)converted;
            }
            if (converted instanceof RuntimeException) {
                throw (RuntimeException)converted;
            }
            throw new RuntimeException(converted);
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.UPDATE_DOMAIN_VERIFICATION_USER_SELECTION")
    public SortedSet<DomainOwner> getOwnersForDomain(@NonNull String domain) {
        try {
            Objects.requireNonNull(domain);
            List<DomainOwner> orderedList = this.mDomainVerificationManager.getOwnersForDomain(domain, this.mContext.getUserId());
            TreeSet<DomainOwner> set = new TreeSet<DomainOwner>(Comparator.comparingInt(orderedList::indexOf));
            set.addAll(orderedList);
            return set;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private Exception rethrow(Exception exception, @Nullable String packageName) {
        if (exception instanceof ServiceSpecificException) {
            int serviceSpecificErrorCode = ((ServiceSpecificException)exception).errorCode;
            if (packageName == null) {
                packageName = exception.getMessage();
            }
            if (serviceSpecificErrorCode == 1) {
                return new PackageManager.NameNotFoundException(packageName);
            }
            return exception;
        }
        if (exception instanceof RemoteException) {
            return ((RemoteException)exception).rethrowFromSystemServer();
        }
        return exception;
    }

    private void validateInput(@Nullable UUID domainSetId, @Nullable Set<String> domains) {
        if (domainSetId == null) {
            throw new IllegalArgumentException("domainSetId cannot be null");
        }
        if (CollectionUtils.isEmpty(domains)) {
            throw new IllegalArgumentException("Provided domain set cannot be empty");
        }
    }

    public static @interface Error {
    }
}

