/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

@RavenwoodKeepWholeClass
public class AssetFileDescriptor
implements Parcelable,
Closeable {
    public static final long UNKNOWN_LENGTH = -1L;
    @UnsupportedAppUsage
    private final ParcelFileDescriptor mFd;
    @UnsupportedAppUsage
    private final long mStartOffset;
    @UnsupportedAppUsage
    private final long mLength;
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<AssetFileDescriptor> CREATOR = new Parcelable.Creator<AssetFileDescriptor>(){

        @Override
        public AssetFileDescriptor createFromParcel(Parcel in) {
            return new AssetFileDescriptor(in);
        }

        public AssetFileDescriptor[] newArray(int size) {
            return new AssetFileDescriptor[size];
        }
    };

    public AssetFileDescriptor(ParcelFileDescriptor fd, long startOffset, long length) {
        this(fd, startOffset, length, null);
    }

    public AssetFileDescriptor(ParcelFileDescriptor fd, long startOffset, long length, Bundle extras) {
        if (fd == null) {
            throw new IllegalArgumentException("fd must not be null");
        }
        if (length < 0L && startOffset != 0L) {
            throw new IllegalArgumentException("startOffset must be 0 when using UNKNOWN_LENGTH");
        }
        this.mFd = fd;
        this.mStartOffset = startOffset;
        this.mLength = length;
        this.mExtras = extras;
    }

    public ParcelFileDescriptor getParcelFileDescriptor() {
        return this.mFd;
    }

    public FileDescriptor getFileDescriptor() {
        return this.mFd.getFileDescriptor();
    }

    public long getStartOffset() {
        return this.mStartOffset;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public long getLength() {
        if (this.mLength >= 0L) {
            return this.mLength;
        }
        long len = this.mFd.getStatSize();
        return len >= 0L ? len : -1L;
    }

    public long getDeclaredLength() {
        return this.mLength;
    }

    @Override
    public void close() throws IOException {
        this.mFd.close();
    }

    public FileInputStream createInputStream() throws IOException {
        if (this.mLength < 0L) {
            return new ParcelFileDescriptor.AutoCloseInputStream(this.mFd);
        }
        return new AutoCloseInputStream(this);
    }

    public FileOutputStream createOutputStream() throws IOException {
        if (this.mLength < 0L) {
            return new ParcelFileDescriptor.AutoCloseOutputStream(this.mFd);
        }
        return new AutoCloseOutputStream(this);
    }

    public String toString() {
        return "{AssetFileDescriptor: " + this.mFd + " start=" + this.mStartOffset + " len=" + this.mLength + "}";
    }

    @Override
    public int describeContents() {
        return this.mFd.describeContents();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.mFd.writeToParcel(out, flags);
        out.writeLong(this.mStartOffset);
        out.writeLong(this.mLength);
        if (this.mExtras != null) {
            out.writeInt(1);
            out.writeBundle(this.mExtras);
        } else {
            out.writeInt(0);
        }
    }

    AssetFileDescriptor(Parcel src) {
        this.mFd = ParcelFileDescriptor.CREATOR.createFromParcel(src);
        this.mStartOffset = src.readLong();
        this.mLength = src.readLong();
        this.mExtras = src.readInt() != 0 ? src.readBundle() : null;
    }

    public static class AutoCloseInputStream
    extends ParcelFileDescriptor.AutoCloseInputStream {
        private ParcelFileDescriptor.AutoCloseInputStream mDelegateInputStream;

        public AutoCloseInputStream(AssetFileDescriptor fd) throws IOException {
            super(fd.getParcelFileDescriptor());
            StructStat ss;
            try {
                ss = Os.fstat(fd.getParcelFileDescriptor().getFileDescriptor());
            }
            catch (ErrnoException e) {
                throw new IOException(e);
            }
            this.mDelegateInputStream = OsConstants.S_ISSOCK(ss.st_mode) || OsConstants.S_ISFIFO(ss.st_mode) ? new NonSeekableAutoCloseInputStream(fd) : new SeekableAutoCloseInputStream(fd);
        }

        @Override
        public int available() throws IOException {
            return this.mDelegateInputStream.available();
        }

        @Override
        public int read() throws IOException {
            return this.mDelegateInputStream.read();
        }

        @Override
        public int read(byte[] buffer, int offset, int count) throws IOException {
            return this.mDelegateInputStream.read(buffer, offset, count);
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.mDelegateInputStream.read(buffer);
        }

        @Override
        public long skip(long count) throws IOException {
            return this.mDelegateInputStream.skip(count);
        }

        @Override
        public void mark(int readlimit) {
            this.mDelegateInputStream.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.mDelegateInputStream.markSupported();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.mDelegateInputStream.reset();
        }

        @Override
        public FileChannel getChannel() {
            return this.mDelegateInputStream.getChannel();
        }

        @Override
        public void close() throws IOException {
            this.mDelegateInputStream.close();
        }
    }

    public static class AutoCloseOutputStream
    extends ParcelFileDescriptor.AutoCloseOutputStream {
        private long mRemaining;

        public AutoCloseOutputStream(AssetFileDescriptor fd) throws IOException {
            super(fd.getParcelFileDescriptor());
            if (fd.getParcelFileDescriptor().seekTo(fd.getStartOffset()) < 0L) {
                throw new IOException("Unable to seek");
            }
            this.mRemaining = (int)fd.getLength();
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                if ((long)count > this.mRemaining) {
                    count = (int)this.mRemaining;
                }
                super.write(buffer, offset, count);
                this.mRemaining -= (long)count;
                return;
            }
            super.write(buffer, offset, count);
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                int count = buffer.length;
                if ((long)count > this.mRemaining) {
                    count = (int)this.mRemaining;
                }
                super.write(buffer);
                this.mRemaining -= (long)count;
                return;
            }
            super.write(buffer);
        }

        @Override
        public void write(int oneByte) throws IOException {
            if (this.mRemaining >= 0L) {
                if (this.mRemaining == 0L) {
                    return;
                }
                super.write(oneByte);
                --this.mRemaining;
                return;
            }
            super.write(oneByte);
        }
    }

    private static class SeekableAutoCloseInputStream
    extends ParcelFileDescriptor.AutoCloseInputStream {
        private long mTotalSize;
        private final long mFileOffset;
        private long mOffset;
        private OffsetCorrectFileChannel mOffsetCorrectFileChannel;

        SeekableAutoCloseInputStream(AssetFileDescriptor fd) throws IOException {
            super(fd.getParcelFileDescriptor());
            this.mTotalSize = fd.getLength();
            this.mFileOffset = fd.getStartOffset();
        }

        @Override
        public int available() throws IOException {
            long available = this.mTotalSize - this.mOffset;
            return available >= 0L ? (available < Integer.MAX_VALUE ? (int)available : Integer.MAX_VALUE) : 0;
        }

        @Override
        public int read() throws IOException {
            byte[] buffer = new byte[1];
            int result = this.read(buffer, 0, 1);
            return result == -1 ? -1 : buffer[0] & 0xFF;
        }

        @Override
        public int read(byte[] buffer, int offset, int count) throws IOException {
            int available = this.available();
            if (available <= 0) {
                return -1;
            }
            if (count == 0) {
                return 0;
            }
            if (count > available) {
                count = available;
            }
            try {
                int res = Os.pread(this.getFD(), buffer, offset, count, this.mFileOffset + this.mOffset);
                if (res == 0) {
                    res = -1;
                }
                if (res > 0) {
                    this.mOffset += (long)res;
                    this.updateChannelPosition(this.mOffset + this.mFileOffset);
                }
                return res;
            }
            catch (ErrnoException e) {
                throw new IOException(e);
            }
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public long skip(long count) throws IOException {
            int available = this.available();
            if (available <= 0) {
                return -1L;
            }
            if (count > (long)available) {
                count = available;
            }
            this.mOffset += count;
            this.updateChannelPosition(this.mOffset + this.mFileOffset);
            return count;
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public synchronized void reset() throws IOException {
        }

        @Override
        public FileChannel getChannel() {
            if (this.mOffsetCorrectFileChannel == null) {
                this.mOffsetCorrectFileChannel = new OffsetCorrectFileChannel(super.getChannel());
            }
            try {
                this.updateChannelPosition(this.mOffset + this.mFileOffset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.mOffsetCorrectFileChannel;
        }

        private void updateChannelPosition(long newPosition) throws IOException {
            if (this.mOffsetCorrectFileChannel != null) {
                this.mOffsetCorrectFileChannel.position(newPosition);
            }
        }

        private class OffsetCorrectFileChannel
        extends FileChannel {
            private final FileChannel mDelegate;
            private static final String METHOD_NOT_SUPPORTED_MESSAGE = "This Method is not supported in AutoCloseInputStream FileChannel.";

            OffsetCorrectFileChannel(FileChannel fc) {
                this.mDelegate = fc;
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                if (SeekableAutoCloseInputStream.this.available() <= 0) {
                    return -1;
                }
                int bytesRead = this.mDelegate.read(dst);
                if (bytesRead != -1) {
                    SeekableAutoCloseInputStream.this.mOffset += (long)bytesRead;
                }
                return bytesRead;
            }

            @Override
            public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
                long bytesRead;
                if (SeekableAutoCloseInputStream.this.available() <= 0) {
                    return -1L;
                }
                if (SeekableAutoCloseInputStream.this.mOffset + (long)length > SeekableAutoCloseInputStream.this.mTotalSize) {
                    length = (int)(SeekableAutoCloseInputStream.this.mTotalSize - SeekableAutoCloseInputStream.this.mOffset);
                }
                if ((bytesRead = this.mDelegate.read(dsts, offset, length)) != -1L) {
                    SeekableAutoCloseInputStream.this.mOffset += bytesRead;
                }
                return bytesRead;
            }

            @Override
            public int read(ByteBuffer dst, long position) throws IOException {
                if (position - SeekableAutoCloseInputStream.this.mFileOffset > SeekableAutoCloseInputStream.this.mTotalSize) {
                    return -1;
                }
                return this.mDelegate.read(dst, position);
            }

            @Override
            public long position() throws IOException {
                return this.mDelegate.position();
            }

            @Override
            public FileChannel position(long newPosition) throws IOException {
                SeekableAutoCloseInputStream.this.mOffset = newPosition - SeekableAutoCloseInputStream.this.mFileOffset;
                return this.mDelegate.position(newPosition);
            }

            @Override
            public long size() throws IOException {
                return SeekableAutoCloseInputStream.this.mTotalSize;
            }

            @Override
            public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
                if (position - SeekableAutoCloseInputStream.this.mFileOffset > SeekableAutoCloseInputStream.this.mTotalSize) {
                    return 0L;
                }
                if (position - SeekableAutoCloseInputStream.this.mFileOffset + count > SeekableAutoCloseInputStream.this.mTotalSize) {
                    count = SeekableAutoCloseInputStream.this.mTotalSize - (position - SeekableAutoCloseInputStream.this.mFileOffset);
                }
                return this.mDelegate.transferTo(position, count, target);
            }

            @Override
            public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
                if (position - SeekableAutoCloseInputStream.this.mFileOffset > SeekableAutoCloseInputStream.this.mTotalSize) {
                    throw new IOException("Cannot map to buffer because position exceed current file size.");
                }
                if (position - SeekableAutoCloseInputStream.this.mFileOffset + size > SeekableAutoCloseInputStream.this.mTotalSize) {
                    size = SeekableAutoCloseInputStream.this.mTotalSize - (position - SeekableAutoCloseInputStream.this.mFileOffset);
                }
                return this.mDelegate.map(mode, position, size);
            }

            @Override
            protected void implCloseChannel() throws IOException {
                this.mDelegate.close();
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                throw new UnsupportedOperationException(METHOD_NOT_SUPPORTED_MESSAGE);
            }

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                throw new UnsupportedOperationException(METHOD_NOT_SUPPORTED_MESSAGE);
            }

            @Override
            public int write(ByteBuffer src, long position) throws IOException {
                throw new UnsupportedOperationException(METHOD_NOT_SUPPORTED_MESSAGE);
            }

            @Override
            public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
                throw new UnsupportedOperationException(METHOD_NOT_SUPPORTED_MESSAGE);
            }

            @Override
            public FileChannel truncate(long size) throws IOException {
                throw new UnsupportedOperationException(METHOD_NOT_SUPPORTED_MESSAGE);
            }

            @Override
            public void force(boolean metaData) throws IOException {
                throw new UnsupportedOperationException(METHOD_NOT_SUPPORTED_MESSAGE);
            }

            @Override
            public FileLock lock(long position, long size, boolean shared) throws IOException {
                throw new UnsupportedOperationException(METHOD_NOT_SUPPORTED_MESSAGE);
            }

            @Override
            public FileLock tryLock(long position, long size, boolean shared) throws IOException {
                throw new UnsupportedOperationException(METHOD_NOT_SUPPORTED_MESSAGE);
            }
        }
    }

    private static class NonSeekableAutoCloseInputStream
    extends ParcelFileDescriptor.AutoCloseInputStream {
        private long mRemaining;

        NonSeekableAutoCloseInputStream(AssetFileDescriptor fd) throws IOException {
            super(fd.getParcelFileDescriptor());
            this.skipRaw(fd.getStartOffset());
            this.mRemaining = (int)fd.getLength();
        }

        @RavenwoodReplace
        private long skipRaw(long count) throws IOException {
            return super.skip(count);
        }

        private long skipRaw$ravenwood(long count) throws IOException {
            int toRead;
            long totalRead;
            int read;
            byte[] buf = new byte[(int)Math.min(1024L, count)];
            for (totalRead = 0L; totalRead < count && (read = super.read(buf, 0, toRead = (int)Math.min(count - totalRead, (long)buf.length))) != -1; totalRead += (long)read) {
            }
            return totalRead;
        }

        @Override
        public int available() throws IOException {
            return this.mRemaining >= 0L ? (this.mRemaining < Integer.MAX_VALUE ? (int)this.mRemaining : Integer.MAX_VALUE) : super.available();
        }

        @Override
        public int read() throws IOException {
            byte[] buffer = new byte[1];
            int result = this.read(buffer, 0, 1);
            return result == -1 ? -1 : buffer[0] & 0xFF;
        }

        @Override
        public int read(byte[] buffer, int offset, int count) throws IOException {
            if (this.mRemaining >= 0L) {
                int res;
                if (this.mRemaining == 0L) {
                    return -1;
                }
                if ((long)count > this.mRemaining) {
                    count = (int)this.mRemaining;
                }
                if ((res = super.read(buffer, offset, count)) >= 0) {
                    this.mRemaining -= (long)res;
                }
                return res;
            }
            return super.read(buffer, offset, count);
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public long skip(long count) throws IOException {
            if (this.mRemaining >= 0L) {
                long res;
                if (this.mRemaining == 0L) {
                    return -1L;
                }
                if (count > this.mRemaining) {
                    count = this.mRemaining;
                }
                if ((res = this.skipRaw(count)) >= 0L) {
                    this.mRemaining -= res;
                }
                return res;
            }
            return this.skipRaw(count);
        }

        @Override
        public void mark(int readlimit) {
            if (this.mRemaining >= 0L) {
                return;
            }
            super.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            if (this.mRemaining >= 0L) {
                return false;
            }
            return super.markSupported();
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.mRemaining >= 0L) {
                return;
            }
            super.reset();
        }
    }
}

