/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.res.AssetManager;
import com.android.ide.common.rendering.api.AssetRepository;
import java.io.IOException;
import java.io.InputStream;

public class BridgeAssetManager
extends AssetManager {
    @Nullable
    private AssetRepository mAssetRepository;

    public static AssetManager initSystem() {
        if (!(AssetManager.sSystem instanceof BridgeAssetManager)) {
            AssetManager.sSystem = new BridgeAssetManager();
        }
        return AssetManager.sSystem;
    }

    public static void clearSystem() {
        AssetManager.sSystem = null;
    }

    public void setAssetRepository(@NonNull AssetRepository assetRepository) {
        this.mAssetRepository = assetRepository;
    }

    public void releaseAssetRepository() {
        this.mAssetRepository = null;
    }

    @NonNull
    public AssetRepository getAssetRepository() {
        if (this.mAssetRepository == null) {
            throw new IllegalStateException("Asset repository is not set");
        }
        return this.mAssetRepository;
    }

    @Override
    public InputStream open(String fileName, int accessMode) throws IOException {
        return this.getAssetRepository().openAsset(fileName, accessMode);
    }

    @Override
    public InputStream openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        return this.getAssetRepository().openNonAsset(cookie, fileName, accessMode);
    }

    private BridgeAssetManager() {
    }
}

