/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.FeatureFlags;
import com.android.aconfig.annotations.AssumeTrueForR8;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class CustomFeatureFlags
implements FeatureFlags {
    private BiPredicate<String, Predicate<FeatureFlags>> mGetValueImpl;
    private Set<String> mReadOnlyFlagsSet = new HashSet<String>(Arrays.asList("android.content.res.always_false", "android.content.res.asset_file_descriptor_frro", "android.content.res.default_locale", "android.content.res.dimension_frro", "android.content.res.font_scale_converter_public", "android.content.res.handle_all_config_changes", "android.content.res.layout_readwrite_flags", "android.content.res.manifest_flagging", "android.content.res.nine_patch_frro", "android.content.res.register_resource_paths", "android.content.res.resources_minor_version_support", "android.content.res.rro_constraints", "android.content.res.rro_control_for_android_no_overlayable", "android.content.res.self_targeting_android_resource_frro", "android.content.res.system_context_handle_app_info_changed", "android.content.res.use_new_aconfig_storage", ""));

    public CustomFeatureFlags(BiPredicate<String, Predicate<FeatureFlags>> getValueImpl) {
        this.mGetValueImpl = getValueImpl;
    }

    @Override
    @UnsupportedAppUsage
    public boolean alwaysFalse() {
        return this.getValue("android.content.res.always_false", FeatureFlags::alwaysFalse);
    }

    @Override
    @UnsupportedAppUsage
    public boolean assetFileDescriptorFrro() {
        return this.getValue("android.content.res.asset_file_descriptor_frro", FeatureFlags::assetFileDescriptorFrro);
    }

    @Override
    @UnsupportedAppUsage
    public boolean defaultLocale() {
        return this.getValue("android.content.res.default_locale", FeatureFlags::defaultLocale);
    }

    @Override
    @UnsupportedAppUsage
    public boolean dimensionFrro() {
        return this.getValue("android.content.res.dimension_frro", FeatureFlags::dimensionFrro);
    }

    @Override
    @UnsupportedAppUsage
    public boolean fontScaleConverterPublic() {
        return this.getValue("android.content.res.font_scale_converter_public", FeatureFlags::fontScaleConverterPublic);
    }

    @Override
    @UnsupportedAppUsage
    public boolean handleAllConfigChanges() {
        return this.getValue("android.content.res.handle_all_config_changes", FeatureFlags::handleAllConfigChanges);
    }

    @Override
    @UnsupportedAppUsage
    public boolean layoutReadwriteFlags() {
        return this.getValue("android.content.res.layout_readwrite_flags", FeatureFlags::layoutReadwriteFlags);
    }

    @Override
    @UnsupportedAppUsage
    public boolean manifestFlagging() {
        return this.getValue("android.content.res.manifest_flagging", FeatureFlags::manifestFlagging);
    }

    @Override
    @UnsupportedAppUsage
    public boolean ninePatchFrro() {
        return this.getValue("android.content.res.nine_patch_frro", FeatureFlags::ninePatchFrro);
    }

    @Override
    @UnsupportedAppUsage
    public boolean registerResourcePaths() {
        return this.getValue("android.content.res.register_resource_paths", FeatureFlags::registerResourcePaths);
    }

    @Override
    @UnsupportedAppUsage
    public boolean resourcesMinorVersionSupport() {
        return this.getValue("android.content.res.resources_minor_version_support", FeatureFlags::resourcesMinorVersionSupport);
    }

    @Override
    @UnsupportedAppUsage
    public boolean rroConstraints() {
        return this.getValue("android.content.res.rro_constraints", FeatureFlags::rroConstraints);
    }

    @Override
    @UnsupportedAppUsage
    public boolean rroControlForAndroidNoOverlayable() {
        return this.getValue("android.content.res.rro_control_for_android_no_overlayable", FeatureFlags::rroControlForAndroidNoOverlayable);
    }

    @Override
    @UnsupportedAppUsage
    public boolean selfTargetingAndroidResourceFrro() {
        return this.getValue("android.content.res.self_targeting_android_resource_frro", FeatureFlags::selfTargetingAndroidResourceFrro);
    }

    @Override
    @UnsupportedAppUsage
    public boolean systemContextHandleAppInfoChanged() {
        return this.getValue("android.content.res.system_context_handle_app_info_changed", FeatureFlags::systemContextHandleAppInfoChanged);
    }

    @Override
    @UnsupportedAppUsage
    public boolean useNewAconfigStorage() {
        return this.getValue("android.content.res.use_new_aconfig_storage", FeatureFlags::useNewAconfigStorage);
    }

    public boolean isFlagReadOnlyOptimized(String flagName) {
        return this.mReadOnlyFlagsSet.contains(flagName) && this.isOptimizationEnabled();
    }

    @AssumeTrueForR8
    private boolean isOptimizationEnabled() {
        return false;
    }

    protected boolean getValue(String flagName, Predicate<FeatureFlags> getter) {
        return this.mGetValueImpl.test(flagName, getter);
    }

    public List<String> getFlagNames() {
        return Arrays.asList("android.content.res.always_false", "android.content.res.asset_file_descriptor_frro", "android.content.res.default_locale", "android.content.res.dimension_frro", "android.content.res.font_scale_converter_public", "android.content.res.handle_all_config_changes", "android.content.res.layout_readwrite_flags", "android.content.res.manifest_flagging", "android.content.res.nine_patch_frro", "android.content.res.register_resource_paths", "android.content.res.resources_minor_version_support", "android.content.res.rro_constraints", "android.content.res.rro_control_for_android_no_overlayable", "android.content.res.self_targeting_android_resource_frro", "android.content.res.system_context_handle_app_info_changed", "android.content.res.use_new_aconfig_storage");
    }
}

