/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ActivityInfo;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.ComplexColor;
import android.content.res.Resources;
import android.content.res.TypedArray_Delegate;
import android.content.res.XmlBlock;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.StrictMode;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodThrow;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.android.internal.util.XmlUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.system.VMRuntime;
import java.util.Arrays;

@RavenwoodKeepWholeClass
public class TypedArray
implements AutoCloseable {
    static final int STYLE_NUM_ENTRIES = 7;
    static final int STYLE_TYPE = 0;
    static final int STYLE_DATA = 1;
    static final int STYLE_ASSET_COOKIE = 2;
    static final int STYLE_RESOURCE_ID = 3;
    static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    static final int STYLE_DENSITY = 5;
    static final int STYLE_SOURCE_RESOURCE_ID = 6;
    @UnsupportedAppUsage
    private final Resources mResources;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private DisplayMetrics mMetrics;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private AssetManager mAssets;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private boolean mRecycled;
    @UnsupportedAppUsage
    XmlBlock.Parser mXml;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    Resources.Theme mTheme;
    @UnsupportedAppUsage
    int[] mData;
    long mDataAddress;
    @UnsupportedAppUsage
    int[] mIndices;
    long mIndicesAddress;
    @UnsupportedAppUsage
    int mLength;
    @UnsupportedAppUsage
    TypedValue mValue = new TypedValue();

    static TypedArray obtain_Original(Resources res, int len) {
        TypedArray attrs = res.mTypedArrayPool.acquire();
        if (attrs == null) {
            attrs = new TypedArray(res);
        }
        attrs.mRecycled = false;
        attrs.mAssets = res.getAssets();
        attrs.mMetrics = res.getDisplayMetrics();
        attrs.resize(len);
        return attrs;
    }

    @LayoutlibDelegate
    static TypedArray obtain(Resources resources, int n) {
        return TypedArray_Delegate.obtain(resources, n);
    }

    private void resize(int len) {
        this.mLength = len;
        int dataLen = len * 7;
        int indicesLen = len + 1;
        VMRuntime runtime = VMRuntime.getRuntime();
        if (this.mDataAddress == 0L || this.mData.length < dataLen) {
            this.mData = (int[])runtime.newNonMovableArray(Integer.TYPE, dataLen);
            this.mDataAddress = runtime.addressOf(this.mData);
            this.mIndices = (int[])runtime.newNonMovableArray(Integer.TYPE, indicesLen);
            this.mIndicesAddress = runtime.addressOf(this.mIndices);
        }
    }

    public int length() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mLength;
    }

    public int getIndexCount() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mIndices[0];
    }

    public int getIndex(int at) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mIndices[1 + at];
    }

    public Resources getResources() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mResources;
    }

    public CharSequence getText(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 0) {
            return null;
        }
        if (type == 3) {
            return this.loadStringValueAt(index);
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            return v.coerceToString();
        }
        throw new RuntimeException("getText of bad type: 0x" + Integer.toHexString(type));
    }

    @Nullable
    public String getString(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 0) {
            return null;
        }
        if (type == 3) {
            return this.loadStringValueAt(index).toString();
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            CharSequence cs = v.coerceToString();
            return cs != null ? cs.toString() : null;
        }
        throw new RuntimeException("getString of bad type: 0x" + Integer.toHexString(type));
    }

    public String getNonResourceString(int index) {
        int cookie;
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 3 && (cookie = data[index + 2]) < 0) {
            String value = this.mXml.getPooledString(data[index + 1]).toString();
            if (value != null && this.mXml != null && this.mXml.mValidator != null) {
                this.mXml.mValidator.validateResStrAttr(this.mXml, index, value);
            }
            return value;
        }
        return null;
    }

    @UnsupportedAppUsage
    public String getNonConfigurationString(int index, int allowedChangingConfigs) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        int changingConfigs = ActivityInfo.activityInfoConfigNativeToJava(data[index + 4]);
        if ((changingConfigs & ~allowedChangingConfigs) != 0) {
            return null;
        }
        if (type == 0) {
            return null;
        }
        if (type == 3) {
            return this.loadStringValueAt(index).toString();
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            CharSequence cs = v.coerceToString();
            return cs != null ? cs.toString() : null;
        }
        throw new RuntimeException("getNonConfigurationString of bad type: 0x" + Integer.toHexString(type));
    }

    public boolean getBoolean(int index, boolean defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1] != 0;
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            StrictMode.noteResourceMismatch(v);
            return XmlUtils.convertValueToBoolean(v.coerceToString(), defValue);
        }
        throw new RuntimeException("getBoolean of bad type: 0x" + Integer.toHexString(type));
    }

    public int getInt(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            StrictMode.noteResourceMismatch(v);
            return XmlUtils.convertValueToInt(v.coerceToString(), defValue);
        }
        throw new RuntimeException("getInt of bad type: 0x" + Integer.toHexString(type));
    }

    public float getFloat(int index, float defValue) {
        CharSequence str;
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 4) {
            return Float.intBitsToFloat(data[index + 1]);
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v) && (str = v.coerceToString()) != null) {
            StrictMode.noteResourceMismatch(v);
            return Float.parseFloat(str.toString());
        }
        throw new RuntimeException("getFloat of bad type: 0x" + Integer.toHexString(type));
    }

    public int getColor(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 3) {
            TypedValue value = this.mValue;
            if (this.getValueAt(index, value)) {
                ColorStateList csl = this.mResources.loadColorStateList(value, value.resourceId, this.mTheme);
                return csl.getDefaultColor();
            }
            return defValue;
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to color: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    @Nullable
    @RavenwoodThrow(blockedBy={ComplexColor.class})
    public ComplexColor getComplexColor(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 7, value)) {
            if (value.type == 2) {
                throw new UnsupportedOperationException("Failed to resolve attribute at index " + index + ": " + value + ", theme=" + this.mTheme);
            }
            return this.mResources.loadComplexColor(value, value.resourceId, this.mTheme);
        }
        return null;
    }

    @Nullable
    public ColorStateList getColorStateList(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 7, value)) {
            if (value.type == 2) {
                throw new UnsupportedOperationException("Failed to resolve attribute at index " + index + ": " + value + ", theme=" + this.mTheme);
            }
            return this.mResources.loadColorStateList(value, value.resourceId, this.mTheme);
        }
        return null;
    }

    public int getInteger(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to integer: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    public float getDimension(int index, float defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimension(data[index + 1], this.mMetrics);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to dimension: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    public int getDimensionPixelOffset(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelOffset(data[index + 1], this.mMetrics);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to dimension: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    public int getDimensionPixelSize(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelSize(data[index + 1], this.mMetrics);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to dimension: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    public int getLayoutDimension(int index, String name) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelSize(data[index + 1], this.mMetrics);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException(this.getPositionDescription() + ": You must supply a " + name + " attribute., theme=" + this.mTheme);
    }

    public int getLayoutDimension(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelSize(data[index + 1], this.mMetrics);
        }
        return defValue;
    }

    public float getFraction(int index, int base, int pbase, float defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 6) {
            return TypedValue.complexToFraction(data[index + 1], base, pbase);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to fraction: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    public int getResourceId(int index, int defValue) {
        int resid;
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        if (data[(index *= 7) + 0] != 0 && (resid = data[index + 3]) != 0) {
            return resid;
        }
        return defValue;
    }

    public int getThemeAttributeId(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        if (data[(index *= 7) + 0] == 2) {
            return data[index + 1];
        }
        return defValue;
    }

    @Nullable
    @RavenwoodThrow(blockedBy={Drawable.class})
    public Drawable getDrawable(int index) {
        return this.getDrawableForDensity(index, 0);
    }

    @Nullable
    @RavenwoodThrow(blockedBy={Drawable.class})
    public Drawable getDrawableForDensity(int index, int density) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 7, value)) {
            if (value.type == 2) {
                throw new UnsupportedOperationException("Failed to resolve attribute at index " + index + ": " + value + ", theme=" + this.mTheme);
            }
            if (density > 0) {
                this.mResources.getValueForDensity(value.resourceId, density, value, true);
            }
            return this.mResources.loadDrawable(value, value.resourceId, density, this.mTheme);
        }
        return null;
    }

    @Nullable
    public Typeface getFont(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 7, value)) {
            if (value.type == 2) {
                throw new UnsupportedOperationException("Failed to resolve attribute at index " + index + ": " + value + ", theme=" + this.mTheme);
            }
            return this.mResources.getFont(value, value.resourceId);
        }
        return null;
    }

    public CharSequence[] getTextArray(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 7, value)) {
            return this.mResources.getTextArray(value.resourceId);
        }
        return null;
    }

    public boolean getValue(int index, TypedValue outValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.getValueAt(index * 7, outValue);
    }

    public int getType(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mData[(index *= 7) + 0];
    }

    public int getSourceResourceId(int index, int defaultValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int resid = this.mData[(index *= 7) + 6];
        if (resid != 0) {
            return resid;
        }
        return defaultValue;
    }

    public boolean hasValue(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        return type != 0;
    }

    public boolean hasValueOrEmpty(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 7) + 0];
        return type != 0 || data[index + 1] == 1;
    }

    public TypedValue peekValue(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 7, value)) {
            return value;
        }
        return null;
    }

    public String getPositionDescription() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mXml != null ? this.mXml.getPositionDescription() : "<internal>";
    }

    public void recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this.toString() + " recycled twice!");
        }
        this.mRecycled = true;
        this.mXml = null;
        this.mTheme = null;
        this.mAssets = null;
        this.mResources.mTypedArrayPool.release(this);
    }

    @Override
    public void close() {
        this.recycle();
    }

    @Nullable
    @UnsupportedAppUsage
    public int[] extractThemeAttrs() {
        return this.extractThemeAttrs(null);
    }

    @Nullable
    @UnsupportedAppUsage
    public int[] extractThemeAttrs(@Nullable int[] scrap) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] attrs = null;
        int[] data = this.mData;
        int N2 = this.length();
        for (int i = 0; i < N2; ++i) {
            int index = i * 7;
            if (data[index + 0] != 2) continue;
            data[index + 0] = 0;
            int attr2 = data[index + 1];
            if (attr2 == 0) continue;
            if (attrs == null) {
                if (scrap != null && scrap.length == N2) {
                    attrs = scrap;
                    Arrays.fill(attrs, 0);
                } else {
                    attrs = new int[N2];
                }
            }
            attrs[i] = attr2;
        }
        return attrs;
    }

    public int getChangingConfigurations() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int changingConfig = 0;
        int[] data = this.mData;
        int N2 = this.length();
        for (int i = 0; i < N2; ++i) {
            int index = i * 7;
            int type = data[index + 0];
            if (type == 0) continue;
            changingConfig |= ActivityInfo.activityInfoConfigNativeToJava(data[index + 4]);
        }
        return changingConfig;
    }

    @UnsupportedAppUsage
    boolean getValueAt_Original(int index, TypedValue outValue) {
        int[] data = this.mData;
        int type = data[index + 0];
        if (type == 0) {
            return false;
        }
        outValue.type = type;
        outValue.data = data[index + 1];
        outValue.assetCookie = data[index + 2];
        outValue.resourceId = data[index + 3];
        outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(data[index + 4]);
        outValue.density = data[index + 5];
        outValue.string = type == 3 ? this.loadStringValueAt(index) : null;
        outValue.sourceResourceId = data[index + 6];
        return true;
    }

    @LayoutlibDelegate
    private boolean getValueAt(int n, TypedValue typedValue) {
        return TypedArray_Delegate.getValueAt(this, n, typedValue);
    }

    @Nullable
    private CharSequence loadStringValueAt(int index) {
        int[] data = this.mData;
        int cookie = data[index + 2];
        CharSequence value = null;
        if (cookie < 0) {
            if (this.mXml != null) {
                value = this.mXml.getPooledString(data[index + 1]);
            }
        } else {
            value = this.mAssets.getPooledStringForCookie(cookie, data[index + 1]);
        }
        if (value != null && this.mXml != null && this.mXml.mValidator != null) {
            this.mXml.mValidator.validateResStrAttr(this.mXml, index / 7, value);
        }
        return value;
    }

    protected TypedArray(Resources resources) {
        this.mResources = resources;
        this.mMetrics = this.mResources.getDisplayMetrics();
        this.mAssets = this.mResources.getAssets();
    }

    public String toString() {
        return Arrays.toString(this.mData);
    }
}

