/*
 * Decompiled with CFR 0.152.
 */
package android.content.res.loader;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.om.OverlayInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.ApkAssets;
import android.content.res.Flags;
import android.content.res.loader.AssetsProvider;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.om.OverlayManagerImpl;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

public class ResourcesProvider
implements AutoCloseable,
Closeable {
    private static final String TAG = "ResourcesProvider";
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private boolean mOpen = true;
    @GuardedBy(value={"mLock"})
    private int mOpenCount = 0;
    @GuardedBy(value={"mLock"})
    private final ApkAssets mApkAssets;

    @NonNull
    public static ResourcesProvider empty(@NonNull AssetsProvider assetsProvider) {
        return new ResourcesProvider(ApkAssets.loadEmptyForLoader(4, assetsProvider));
    }

    @SuppressLint(value={"WrongConstant"})
    @NonNull
    public static ResourcesProvider loadOverlay(@NonNull OverlayInfo overlayInfo) throws IOException {
        Objects.requireNonNull(overlayInfo);
        Preconditions.checkArgument(overlayInfo.isFabricated(), "Not accepted overlay");
        if (!Flags.selfTargetingAndroidResourceFrro()) {
            Preconditions.checkStringNotEmpty(overlayInfo.getTargetOverlayableName(), "Without overlayable name");
        }
        String overlayName = OverlayManagerImpl.checkOverlayNameValid(overlayInfo.getOverlayName());
        String path = Preconditions.checkStringNotEmpty(overlayInfo.getBaseCodePath(), "Invalid base path");
        Path frroPath = Path.of(path, new String[0]);
        if (!Files.isRegularFile(frroPath, new LinkOption[0])) {
            throw new FileNotFoundException("The frro file not found");
        }
        Path idmapPath = frroPath.getParent().resolve(overlayName + ".idmap");
        if (!Files.isRegularFile(idmapPath, new LinkOption[0])) {
            throw new FileNotFoundException("The idmap file not found");
        }
        return new ResourcesProvider(ApkAssets.loadOverlayFromPath(idmapPath.toString(), 0));
    }

    @NonNull
    public static ResourcesProvider loadFromApk(@NonNull ParcelFileDescriptor fileDescriptor) throws IOException {
        return ResourcesProvider.loadFromApk(fileDescriptor, null);
    }

    @NonNull
    public static ResourcesProvider loadFromApk(@NonNull ParcelFileDescriptor fileDescriptor, @Nullable AssetsProvider assetsProvider) throws IOException {
        return new ResourcesProvider(ApkAssets.loadFromFd(fileDescriptor.getFileDescriptor(), fileDescriptor.toString(), 4, assetsProvider));
    }

    @VisibleForTesting
    @NonNull
    public static ResourcesProvider loadFromApk(@NonNull ParcelFileDescriptor fileDescriptor, long offset, long length, @Nullable AssetsProvider assetsProvider) throws IOException {
        return new ResourcesProvider(ApkAssets.loadFromFd(fileDescriptor.getFileDescriptor(), fileDescriptor.toString(), offset, length, 4, assetsProvider));
    }

    @NonNull
    public static ResourcesProvider loadFromTable(@NonNull ParcelFileDescriptor fileDescriptor, @Nullable AssetsProvider assetsProvider) throws IOException {
        return new ResourcesProvider(ApkAssets.loadTableFromFd(fileDescriptor.getFileDescriptor(), fileDescriptor.toString(), 4, assetsProvider));
    }

    @VisibleForTesting
    @NonNull
    public static ResourcesProvider loadFromTable(@NonNull ParcelFileDescriptor fileDescriptor, long offset, long length, @Nullable AssetsProvider assetsProvider) throws IOException {
        return new ResourcesProvider(ApkAssets.loadTableFromFd(fileDescriptor.getFileDescriptor(), fileDescriptor.toString(), offset, length, 4, assetsProvider));
    }

    @NonNull
    public static ResourcesProvider loadFromSplit(@NonNull Context context, @NonNull String splitName) throws IOException {
        ApplicationInfo appInfo = context.getApplicationInfo();
        int splitIndex = ArrayUtils.indexOf(appInfo.splitNames, splitName);
        if (splitIndex < 0) {
            throw new IllegalArgumentException("Split " + splitName + " not found");
        }
        String splitPath = appInfo.getSplitCodePaths()[splitIndex];
        return new ResourcesProvider(ApkAssets.loadFromPath(splitPath, 4, null));
    }

    @NonNull
    public static ResourcesProvider loadFromDirectory(@NonNull String path, @Nullable AssetsProvider assetsProvider) throws IOException {
        return new ResourcesProvider(ApkAssets.loadFromDir(path, 4, assetsProvider));
    }

    private ResourcesProvider(@NonNull ApkAssets apkAssets) {
        this.mApkAssets = apkAssets;
    }

    @NonNull
    public ApkAssets getApkAssets() {
        return this.mApkAssets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementRefCount() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mOpen) {
                throw new IllegalStateException("Operation failed: resources provider is closed");
            }
            ++this.mOpenCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementRefCount() {
        Object object = this.mLock;
        synchronized (object) {
            --this.mOpenCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mOpen) {
                return;
            }
            if (this.mOpenCount != 0) {
                throw new IllegalStateException("Failed to close provider used by " + this.mOpenCount + " ResourcesLoader instances");
            }
            this.mOpen = false;
        }
        try {
            this.mApkAssets.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOpenCount != 0) {
                Log.w(TAG, "ResourcesProvider " + this + " finalized with non-zero refs: " + this.mOpenCount);
            }
        }
    }
}

