/*
 * Decompiled with CFR 0.152.
 */
package android.federatedcompute;

import android.annotation.NonNull;
import android.content.ComponentName;
import android.content.Context;
import android.federatedcompute.FederatedComputeException;
import android.federatedcompute.aidl.IFederatedComputeCallback;
import android.federatedcompute.aidl.IFederatedComputeService;
import android.federatedcompute.common.ScheduleFederatedComputeRequest;
import android.os.Binder;
import android.os.OutcomeReceiver;
import com.android.federatedcompute.internal.util.AbstractServiceBinder;
import com.android.federatedcompute.internal.util.LogUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class FederatedComputeManager {
    public static final String FEDERATED_COMPUTE_SERVICE = "federated_compute_service";
    private static final String TAG = FederatedComputeManager.class.getSimpleName();
    private static final String FEDERATED_COMPUTATION_SERVICE_INTENT_FILTER_NAME = "android.federatedcompute.FederatedComputeService";
    private static final String FEDERATED_COMPUTATION_SERVICE_PACKAGE = "com.android.federatedcompute.services";
    private static final String ALT_FEDERATED_COMPUTATION_SERVICE_PACKAGE = "com.google.android.federatedcompute";
    private final Context mContext;
    private final AbstractServiceBinder<IFederatedComputeService> mServiceBinder;

    public FederatedComputeManager(Context context) {
        this.mContext = context;
        this.mServiceBinder = AbstractServiceBinder.getServiceBinderByIntent(context, FEDERATED_COMPUTATION_SERVICE_INTENT_FILTER_NAME, List.of(FEDERATED_COMPUTATION_SERVICE_PACKAGE, ALT_FEDERATED_COMPUTATION_SERVICE_PACKAGE), IFederatedComputeService.Stub::asInterface);
    }

    public void schedule(@NonNull ScheduleFederatedComputeRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(request);
        try {
            IFederatedComputeService service = this.mServiceBinder.getService(executor);
            IFederatedComputeCallback.Stub federatedComputeCallback = new IFederatedComputeCallback.Stub(){

                @Override
                public void onSuccess() {
                    LogUtil.d(TAG, ": schedule onSuccess() called");
                    executor.execute(() -> callback.onResult(null));
                    FederatedComputeManager.this.unbindFromService();
                }

                @Override
                public void onFailure(int errorCode) {
                    LogUtil.d(TAG, ": schedule onFailure() called with errorCode %d", errorCode);
                    executor.execute(() -> callback.onError(new FederatedComputeException(errorCode)));
                    FederatedComputeManager.this.unbindFromService();
                }
            };
            String appPackageName = this.mContext.getPackageManager().getNameForUid(Binder.getCallingUid());
            service.schedule(appPackageName, request.getTrainingOptions(), federatedComputeCallback);
        }
        catch (Exception e) {
            LogUtil.e(TAG, e, "Exception when schedule federated job");
            executor.execute(() -> callback.onError(e));
            this.unbindFromService();
        }
    }

    public void cancel(@NonNull ComponentName ownerComponent, @NonNull String populationName, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(populationName);
        try {
            IFederatedComputeService service = this.mServiceBinder.getService(executor);
            IFederatedComputeCallback.Stub federatedComputeCallback = new IFederatedComputeCallback.Stub(){

                @Override
                public void onSuccess() {
                    LogUtil.d(TAG, ": cancel onSuccess() called");
                    executor.execute(() -> callback.onResult(null));
                    FederatedComputeManager.this.unbindFromService();
                }

                @Override
                public void onFailure(int errorCode) {
                    LogUtil.d(TAG, ": cancel onFailure() called with errorCode %d", errorCode);
                    executor.execute(() -> callback.onError(new FederatedComputeException(errorCode)));
                    FederatedComputeManager.this.unbindFromService();
                }
            };
            service.cancel(ownerComponent, populationName, federatedComputeCallback);
        }
        catch (Exception e) {
            LogUtil.e(TAG, e, "Exception when cancel federated job %s", populationName);
            executor.execute(() -> callback.onError(e));
            this.unbindFromService();
        }
    }

    public void unbindFromService() {
        this.mServiceBinder.unbindFromService();
    }
}

