/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Bitmap;
import android.graphics.Gainmap;
import android.graphics.Shader;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.graphics.hwui.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RavenwoodKeepWholeClass
public class BitmapShader
extends Shader {
    Bitmap mBitmap;
    private Gainmap mOverrideGainmap;
    private int mTileX;
    private int mTileY;
    public static final int FILTER_MODE_DEFAULT = 0;
    public static final int FILTER_MODE_NEAREST = 1;
    public static final int FILTER_MODE_LINEAR = 2;
    private int mFilterMode;
    private boolean mFilterFromPaint;
    private boolean mIsDirectSampled;
    private boolean mRequestDirectSampling;
    private int mMaxAniso = 0;

    public BitmapShader(@NonNull Bitmap bitmap, @NonNull Shader.TileMode tileX, @NonNull Shader.TileMode tileY) {
        this(bitmap, tileX.nativeInt, tileY.nativeInt);
    }

    private BitmapShader(Bitmap bitmap, int tileX, int tileY) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap must be non-null");
        }
        bitmap.checkRecycled("Cannot create BitmapShader for recycled bitmap");
        this.mBitmap = bitmap;
        this.mTileX = tileX;
        this.mTileY = tileY;
        this.mFilterMode = 0;
        this.mFilterFromPaint = false;
        this.mIsDirectSampled = false;
        this.mRequestDirectSampling = false;
    }

    public int getFilterMode() {
        return this.mFilterMode;
    }

    public void setFilterMode(int mode) {
        if (mode != this.mFilterMode) {
            this.mFilterMode = mode;
            this.mMaxAniso = 0;
            this.discardNativeInstance();
        }
    }

    public void setMaxAnisotropy(int maxAnisotropy) {
        if (this.mMaxAniso != maxAnisotropy && maxAnisotropy > 0) {
            this.mMaxAniso = maxAnisotropy;
            this.mFilterMode = 0;
            this.discardNativeInstance();
        }
    }

    @FlaggedApi(value="com.android.graphics.hwui.flags.gainmap_animations")
    public void setOverrideGainmap(@Nullable Gainmap overrideGainmap) {
        if (!Flags.gainmapAnimations()) {
            throw new IllegalStateException("API not available");
        }
        this.mOverrideGainmap = overrideGainmap == null ? null : new Gainmap(overrideGainmap, overrideGainmap.getGainmapContents());
        this.discardNativeInstance();
    }

    public int getMaxAnisotropy() {
        return this.mMaxAniso;
    }

    synchronized long getNativeInstanceWithDirectSampling() {
        this.mRequestDirectSampling = true;
        return this.getNativeInstance();
    }

    @Override
    protected long createNativeInstance(long nativeMatrix, boolean filterFromPaint) {
        boolean enableLinearFilter;
        this.mBitmap.checkRecycled("BitmapShader's bitmap has been recycled");
        boolean bl = enableLinearFilter = this.mFilterMode == 2;
        if (this.mFilterMode == 0) {
            enableLinearFilter = this.mFilterFromPaint = filterFromPaint;
        }
        this.mIsDirectSampled = this.mRequestDirectSampling;
        this.mRequestDirectSampling = false;
        return BitmapShader.nativeCreate(nativeMatrix, this.mBitmap.getNativeInstance(), this.mTileX, this.mTileY, this.mMaxAniso, enableLinearFilter, this.mIsDirectSampled, this.mOverrideGainmap != null ? this.mOverrideGainmap.mNativePtr : 0L);
    }

    @Override
    protected boolean shouldDiscardNativeInstance(boolean filterFromPaint) {
        return this.mIsDirectSampled != this.mRequestDirectSampling || this.mFilterMode == 0 && this.mFilterFromPaint != filterFromPaint;
    }

    private static native long nativeCreate(long var0, long var2, int var4, int var5, int var6, boolean var7, boolean var8, long var9);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FilterMode {
    }
}

