/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;

@RavenwoodKeepWholeClass
public class ColorMatrixColorFilter
extends ColorFilter {
    @UnsupportedAppUsage
    private final ColorMatrix mMatrix = new ColorMatrix();

    public ColorMatrixColorFilter(@NonNull ColorMatrix matrix) {
        this.mMatrix.set(matrix);
    }

    public ColorMatrixColorFilter(@NonNull float[] array2) {
        if (array2.length < 20) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mMatrix.set(array2);
    }

    public void getColorMatrix(ColorMatrix colorMatrix) {
        colorMatrix.set(this.mMatrix);
    }

    @UnsupportedAppUsage
    public void setColorMatrix(@Nullable ColorMatrix matrix) {
        if (matrix == null) {
            this.mMatrix.reset();
        } else {
            this.mMatrix.set(matrix);
        }
        ColorMatrixColorFilter.nativeSetColorMatrix(this.getNativeInstance(), this.mMatrix.getArray());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setColorMatrixArray(@Nullable float[] array2) {
        if (array2 == null) {
            this.mMatrix.reset();
        } else {
            if (array2.length < 20) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.mMatrix.set(array2);
        }
        ColorMatrixColorFilter.nativeSetColorMatrix(this.getNativeInstance(), this.mMatrix.getArray());
    }

    @Override
    long createNativeInstance() {
        return ColorMatrixColorFilter.nativeColorMatrixFilter(this.mMatrix.getArray());
    }

    private static native long nativeColorMatrixFilter(float[] var0);

    private static native void nativeSetColorMatrix(long var0, float[] var2);
}

