/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Bitmap;
import android.graphics.BlendMode;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.RuntimeShader;
import android.graphics.Shader;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public final class RenderEffect {
    private final long mNativeRenderEffect;

    @NonNull
    public static RenderEffect createOffsetEffect(float offsetX, float offsetY) {
        return new RenderEffect(RenderEffect.nativeCreateOffsetEffect(offsetX, offsetY, 0L));
    }

    @NonNull
    public static RenderEffect createOffsetEffect(float offsetX, float offsetY, @NonNull RenderEffect input) {
        return new RenderEffect(RenderEffect.nativeCreateOffsetEffect(offsetX, offsetY, input.getNativeInstance()));
    }

    @NonNull
    public static RenderEffect createBlurEffect(float radiusX, float radiusY, @NonNull RenderEffect inputEffect, @NonNull Shader.TileMode edgeTreatment) {
        long nativeInputEffect = inputEffect != null ? inputEffect.mNativeRenderEffect : 0L;
        return new RenderEffect(RenderEffect.nativeCreateBlurEffect(radiusX, radiusY, nativeInputEffect, edgeTreatment.nativeInt));
    }

    @NonNull
    public static RenderEffect createBlurEffect(float radiusX, float radiusY, @NonNull Shader.TileMode edgeTreatment) {
        return new RenderEffect(RenderEffect.nativeCreateBlurEffect(radiusX, radiusY, 0L, edgeTreatment.nativeInt));
    }

    @NonNull
    public static RenderEffect createBitmapEffect(@NonNull Bitmap bitmap) {
        float right = bitmap.getWidth();
        float bottom = bitmap.getHeight();
        return new RenderEffect(RenderEffect.nativeCreateBitmapEffect(bitmap.getNativeInstance(), 0.0f, 0.0f, right, bottom, 0.0f, 0.0f, right, bottom));
    }

    @NonNull
    public static RenderEffect createBitmapEffect(@NonNull Bitmap bitmap, @Nullable Rect src, @NonNull Rect dst) {
        long bitmapHandle = bitmap.getNativeInstance();
        int left = src == null ? 0 : src.left;
        int top = src == null ? 0 : src.top;
        int right = src == null ? bitmap.getWidth() : src.right;
        int bottom = src == null ? bitmap.getHeight() : src.bottom;
        return new RenderEffect(RenderEffect.nativeCreateBitmapEffect(bitmapHandle, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom));
    }

    @NonNull
    public static RenderEffect createColorFilterEffect(@NonNull ColorFilter colorFilter, @NonNull RenderEffect renderEffect) {
        return new RenderEffect(RenderEffect.nativeCreateColorFilterEffect(colorFilter.getNativeInstance(), renderEffect.getNativeInstance()));
    }

    @NonNull
    public static RenderEffect createColorFilterEffect(@NonNull ColorFilter colorFilter) {
        return new RenderEffect(RenderEffect.nativeCreateColorFilterEffect(colorFilter.getNativeInstance(), 0L));
    }

    @NonNull
    public static RenderEffect createBlendModeEffect(@NonNull RenderEffect dst, @NonNull RenderEffect src, @NonNull BlendMode blendMode) {
        return new RenderEffect(RenderEffect.nativeCreateBlendModeEffect(dst.getNativeInstance(), src.getNativeInstance(), blendMode.getXfermode().porterDuffMode));
    }

    @NonNull
    public static RenderEffect createChainEffect(@NonNull RenderEffect outer, @NonNull RenderEffect inner) {
        return new RenderEffect(RenderEffect.nativeCreateChainEffect(outer.getNativeInstance(), inner.getNativeInstance()));
    }

    @NonNull
    public static RenderEffect createShaderEffect(@NonNull Shader shader) {
        return new RenderEffect(RenderEffect.nativeCreateShaderEffect(shader.getNativeInstance()));
    }

    @NonNull
    public static RenderEffect createRuntimeShaderEffect(@NonNull RuntimeShader shader, @NonNull String uniformShaderName) {
        return new RenderEffect(RenderEffect.nativeCreateRuntimeShaderEffect(shader.getNativeShaderBuilder(), uniformShaderName));
    }

    private RenderEffect(long nativeRenderEffect) {
        this.mNativeRenderEffect = nativeRenderEffect;
        RenderEffectHolder.RENDER_EFFECT_REGISTRY.registerNativeAllocation(this, this.mNativeRenderEffect);
    }

    long getNativeInstance() {
        return this.mNativeRenderEffect;
    }

    private static native long nativeCreateOffsetEffect(float var0, float var1, long var2);

    private static native long nativeCreateBlurEffect(float var0, float var1, long var2, int var4);

    private static native long nativeCreateBitmapEffect(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    private static native long nativeCreateColorFilterEffect(long var0, long var2);

    private static native long nativeCreateBlendModeEffect(long var0, long var2, int var4);

    private static native long nativeCreateChainEffect(long var0, long var2);

    private static native long nativeCreateShaderEffect(long var0);

    private static native long nativeCreateRuntimeShaderEffect(long var0, String var2);

    private static native long nativeGetFinalizer();

    private static class RenderEffectHolder {
        public static final NativeAllocationRegistry RENDER_EFFECT_REGISTRY = NativeAllocationRegistry.createMalloced(RenderEffect.class.getClassLoader(), RenderEffect.nativeGetFinalizer());

        private RenderEffectHolder() {
        }
    }
}

