/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.graphics.Typeface;
import android.graphics.fonts.Font;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.internal.util.Preconditions;
import com.android.text.flags.Flags;
import dalvik.annotation.optimization.CriticalNative;
import java.util.ArrayList;
import java.util.Objects;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public final class PositionedGlyphs {
    private final long mLayoutPtr;
    private final float mXOffset;
    private final float mYOffset;
    private final ArrayList<Font> mFonts;
    @FlaggedApi(value="com.android.text.flags.new_fonts_fallback_xml")
    public static final float NO_OVERRIDE = Float.MIN_VALUE;

    public float getAdvance() {
        return PositionedGlyphs.nGetTotalAdvance(this.mLayoutPtr);
    }

    public float getAscent() {
        return PositionedGlyphs.nGetAscent(this.mLayoutPtr);
    }

    public float getDescent() {
        return PositionedGlyphs.nGetDescent(this.mLayoutPtr);
    }

    public float getOffsetX() {
        return this.mXOffset;
    }

    public float getOffsetY() {
        return this.mYOffset;
    }

    public int glyphCount() {
        return PositionedGlyphs.nGetGlyphCount(this.mLayoutPtr);
    }

    @NonNull
    public Font getFont(int index) {
        Preconditions.checkArgumentInRange(index, 0, this.glyphCount() - 1, "index");
        if (Flags.typefaceRedesignReadonly()) {
            return this.mFonts.get(PositionedGlyphs.nGetFontId(this.mLayoutPtr, index));
        }
        return this.mFonts.get(index);
    }

    public int getGlyphId(int index) {
        Preconditions.checkArgumentInRange(index, 0, this.glyphCount() - 1, "index");
        return PositionedGlyphs.nGetGlyphId(this.mLayoutPtr, index);
    }

    public float getGlyphX(int index) {
        Preconditions.checkArgumentInRange(index, 0, this.glyphCount() - 1, "index");
        return PositionedGlyphs.nGetX(this.mLayoutPtr, index) + this.mXOffset;
    }

    public float getGlyphY(int index) {
        Preconditions.checkArgumentInRange(index, 0, this.glyphCount() - 1, "index");
        return PositionedGlyphs.nGetY(this.mLayoutPtr, index) + this.mYOffset;
    }

    @FlaggedApi(value="com.android.text.flags.new_fonts_fallback_xml")
    public boolean getFakeBold(int index) {
        Preconditions.checkArgumentInRange(index, 0, this.glyphCount() - 1, "index");
        return PositionedGlyphs.nGetFakeBold(this.mLayoutPtr, index);
    }

    @FlaggedApi(value="com.android.text.flags.new_fonts_fallback_xml")
    public boolean getFakeItalic(int index) {
        Preconditions.checkArgumentInRange(index, 0, this.glyphCount() - 1, "index");
        return PositionedGlyphs.nGetFakeItalic(this.mLayoutPtr, index);
    }

    @FlaggedApi(value="com.android.text.flags.new_fonts_fallback_xml")
    public float getWeightOverride(int index) {
        Preconditions.checkArgumentInRange(index, 0, this.glyphCount() - 1, "index");
        float value = PositionedGlyphs.nGetWeightOverride(this.mLayoutPtr, index);
        if (value == -1.0f) {
            return Float.MIN_VALUE;
        }
        return value;
    }

    @FlaggedApi(value="com.android.text.flags.new_fonts_fallback_xml")
    public float getItalicOverride(int index) {
        Preconditions.checkArgumentInRange(index, 0, this.glyphCount() - 1, "index");
        float value = PositionedGlyphs.nGetItalicOverride(this.mLayoutPtr, index);
        if (value == -1.0f) {
            return Float.MIN_VALUE;
        }
        return value;
    }

    public PositionedGlyphs(long layoutPtr, float xOffset, float yOffset) {
        this.mLayoutPtr = layoutPtr;
        this.mXOffset = xOffset;
        this.mYOffset = yOffset;
        if (Flags.typefaceRedesignReadonly()) {
            int fontCount = PositionedGlyphs.nGetFontCount(layoutPtr);
            this.mFonts = new ArrayList(fontCount);
            for (int i = 0; i < fontCount; ++i) {
                this.mFonts.add(new Font(PositionedGlyphs.nGetFontRef(layoutPtr, i)));
            }
        } else {
            int glyphCount = PositionedGlyphs.nGetGlyphCount(layoutPtr);
            this.mFonts = new ArrayList(glyphCount);
            long prevPtr = 0L;
            Font prevFont = null;
            for (int i = 0; i < glyphCount; ++i) {
                long ptr = PositionedGlyphs.nGetFont(layoutPtr, i);
                if (prevPtr != ptr) {
                    prevPtr = ptr;
                    prevFont = new Font(ptr);
                }
                this.mFonts.add(prevFont);
            }
        }
        NoImagePreloadHolder.REGISTRY.registerNativeAllocation(this, layoutPtr);
    }

    @CriticalNative
    private static native int nGetGlyphCount(long var0);

    @CriticalNative
    private static native float nGetTotalAdvance(long var0);

    @CriticalNative
    private static native float nGetAscent(long var0);

    @CriticalNative
    private static native float nGetDescent(long var0);

    @CriticalNative
    private static native int nGetGlyphId(long var0, int var2);

    @CriticalNative
    private static native float nGetX(long var0, int var2);

    @CriticalNative
    private static native float nGetY(long var0, int var2);

    @CriticalNative
    private static native long nGetFont(long var0, int var2);

    @CriticalNative
    private static native long nReleaseFunc();

    @CriticalNative
    private static native boolean nGetFakeBold(long var0, int var2);

    @CriticalNative
    private static native boolean nGetFakeItalic(long var0, int var2);

    @CriticalNative
    private static native float nGetWeightOverride(long var0, int var2);

    @CriticalNative
    private static native float nGetItalicOverride(long var0, int var2);

    @CriticalNative
    private static native int nGetFontCount(long var0);

    @CriticalNative
    private static native long nGetFontRef(long var0, int var2);

    @CriticalNative
    private static native int nGetFontId(long var0, int var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PositionedGlyphs)) {
            return false;
        }
        PositionedGlyphs that = (PositionedGlyphs)o;
        if (this.mXOffset != that.mXOffset || this.mYOffset != that.mYOffset) {
            return false;
        }
        if (this.glyphCount() != that.glyphCount()) {
            return false;
        }
        for (int i = 0; i < this.glyphCount(); ++i) {
            if (this.getGlyphId(i) != that.getGlyphId(i)) {
                return false;
            }
            if (this.getGlyphX(i) != that.getGlyphX(i)) {
                return false;
            }
            if (this.getGlyphY(i) != that.getGlyphY(i)) {
                return false;
            }
            if (this.getFont(i).equals(that.getFont(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = Objects.hash(Float.valueOf(this.mXOffset), Float.valueOf(this.mYOffset));
        for (int i = 0; i < this.glyphCount(); ++i) {
            hashCode = Objects.hash(hashCode, this.getGlyphId(i), Float.valueOf(this.getGlyphX(i)), Float.valueOf(this.getGlyphY(i)), this.getFont(i));
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.glyphCount(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("[ ID = " + this.getGlyphId(i) + ", pos = (" + this.getGlyphX(i) + "," + this.getGlyphY(i) + ") font = " + this.getFont(i) + " ]");
        }
        sb.append("]");
        return "PositionedGlyphs{glyphs = " + sb.toString() + ", mXOffset=" + this.mXOffset + ", mYOffset=" + this.mYOffset + '}';
    }

    private static class NoImagePreloadHolder {
        private static final NativeAllocationRegistry REGISTRY = NativeAllocationRegistry.createMalloced(Typeface.class.getClassLoader(), PositionedGlyphs.nReleaseFunc());

        private NoImagePreloadHolder() {
        }
    }
}

