/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.GraphicBuffer;
import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.libcore.readonly.Flags;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;

public class HardwareBuffer
implements Parcelable,
AutoCloseable {
    public static final int RGBA_8888 = 1;
    public static final int RGBX_8888 = 2;
    public static final int RGB_888 = 3;
    public static final int RGB_565 = 4;
    public static final int RGBA_FP16 = 22;
    public static final int RGBA_1010102 = 43;
    public static final int BLOB = 33;
    public static final int YCBCR_420_888 = 35;
    public static final int D_16 = 48;
    public static final int D_24 = 49;
    public static final int DS_24UI8 = 50;
    public static final int D_FP32 = 51;
    public static final int DS_FP32UI8 = 52;
    public static final int S_UI8 = 53;
    public static final int YCBCR_P010 = 54;
    @FlaggedApi(value="android.media.codec.p210_format_support")
    public static final int YCBCR_P210 = 60;
    @FlaggedApi(value="com.android.graphics.hwui.flags.requested_formats_v")
    public static final int R_8 = 56;
    @FlaggedApi(value="com.android.graphics.hwui.flags.requested_formats_v")
    public static final int R_16 = 57;
    @FlaggedApi(value="com.android.graphics.hwui.flags.requested_formats_v")
    public static final int RG_1616 = 58;
    @FlaggedApi(value="com.android.graphics.hwui.flags.requested_formats_v")
    public static final int RGBA_10101010 = 59;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long mNativeObject;
    private Runnable mCleaner;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    public static final long USAGE_CPU_READ_RARELY = 2L;
    public static final long USAGE_CPU_READ_OFTEN = 3L;
    public static final long USAGE_CPU_WRITE_RARELY = 32L;
    public static final long USAGE_CPU_WRITE_OFTEN = 48L;
    public static final long USAGE_GPU_SAMPLED_IMAGE = 256L;
    public static final long USAGE_GPU_COLOR_OUTPUT = 512L;
    public static final long USAGE_COMPOSER_OVERLAY = 2048L;
    public static final long USAGE_PROTECTED_CONTENT = 16384L;
    public static final long USAGE_VIDEO_ENCODE = 65536L;
    public static final long USAGE_SENSOR_DIRECT_DATA = 0x800000L;
    public static final long USAGE_GPU_DATA_BUFFER = 0x1000000L;
    public static final long USAGE_GPU_CUBE_MAP = 0x2000000L;
    public static final long USAGE_GPU_MIPMAP_COMPLETE = 0x4000000L;
    public static final long USAGE_FRONT_BUFFER = 0x100000000L;
    @NonNull
    public static final Parcelable.Creator<HardwareBuffer> CREATOR = new Parcelable.Creator<HardwareBuffer>(){

        @Override
        public HardwareBuffer createFromParcel(Parcel in) {
            if (in == null) {
                throw new NullPointerException("null passed to createFromParcel");
            }
            long nativeObject = HardwareBuffer.nReadHardwareBufferFromParcel(in);
            if (nativeObject != 0L) {
                return new HardwareBuffer(nativeObject);
            }
            throw new BadParcelableException("Failed to read hardware buffer");
        }

        public HardwareBuffer[] newArray(int size) {
            return new HardwareBuffer[size];
        }
    };

    @NonNull
    public static HardwareBuffer create(int width, int height, int format, int layers, long usage) {
        if (width <= 0) {
            throw new IllegalArgumentException("Invalid width " + width);
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Invalid height " + height);
        }
        if (layers <= 0) {
            throw new IllegalArgumentException("Invalid layer count " + layers);
        }
        if (format == 33 && height != 1) {
            throw new IllegalArgumentException("Height must be 1 when using the BLOB format");
        }
        long nativeObject = HardwareBuffer.nCreateHardwareBuffer(width, height, format, layers, usage);
        if (nativeObject == 0L) {
            throw new IllegalArgumentException("Unable to create a HardwareBuffer, either the dimensions passed were too large, too many image layers were requested, or an invalid set of usage flags or invalid format was passed");
        }
        return new HardwareBuffer(nativeObject);
    }

    public static boolean isSupported(int width, int height, int format, int layers, long usage) {
        if (width <= 0) {
            throw new IllegalArgumentException("Invalid width " + width);
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Invalid height " + height);
        }
        if (layers <= 0) {
            throw new IllegalArgumentException("Invalid layer count " + layers);
        }
        if (format == 33 && height != 1) {
            throw new IllegalArgumentException("Height must be 1 when using the BLOB format");
        }
        return HardwareBuffer.nIsSupported(width, height, format, layers, usage);
    }

    @NonNull
    public static HardwareBuffer createFromGraphicBuffer(@NonNull GraphicBuffer graphicBuffer) {
        long nativeObject = HardwareBuffer.nCreateFromGraphicBuffer(graphicBuffer);
        return new HardwareBuffer(nativeObject);
    }

    private static NativeAllocationRegistry getRegistry(long size) {
        long func = HardwareBuffer.nGetNativeFinalizer();
        Class<HardwareBuffer> cls = HardwareBuffer.class;
        return Flags.nativeMetrics() ? NativeAllocationRegistry.createNonmalloced(cls, func, size) : NativeAllocationRegistry.createNonmalloced(cls.getClassLoader(), func, size);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private HardwareBuffer(long nativeObject) {
        this.mNativeObject = nativeObject;
        long bufferSize = HardwareBuffer.nEstimateSize(nativeObject);
        this.mCleaner = HardwareBuffer.getRegistry(bufferSize).registerNativeAllocation(this, this.mNativeObject);
        this.mCloseGuard.open("HardwareBuffer.close");
    }

    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public int getWidth() {
        this.checkClosed("width");
        return HardwareBuffer.nGetWidth(this.mNativeObject);
    }

    public int getHeight() {
        this.checkClosed("height");
        return HardwareBuffer.nGetHeight(this.mNativeObject);
    }

    public int getFormat() {
        this.checkClosed("format");
        return HardwareBuffer.nGetFormat(this.mNativeObject);
    }

    public int getLayers() {
        this.checkClosed("layer count");
        return HardwareBuffer.nGetLayers(this.mNativeObject);
    }

    public long getUsage() {
        this.checkClosed("usage");
        return HardwareBuffer.nGetUsage(this.mNativeObject);
    }

    public long getId() {
        this.checkClosed("id");
        return HardwareBuffer.nGetId(this.mNativeObject);
    }

    private void checkClosed(String name) {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and its " + name + " cannot be obtained.");
        }
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.mCloseGuard.close();
            this.mNativeObject = 0L;
            this.mCleaner.run();
            this.mCleaner = null;
        }
    }

    public boolean isClosed() {
        return this.mNativeObject == 0L;
    }

    @Override
    public int describeContents() {
        return 1;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and cannot be written to a parcel.");
        }
        HardwareBuffer.nWriteHardwareBufferToParcel(this.mNativeObject, dest);
    }

    private static long nCreateHardwareBuffer(int n, int n2, int n3, int n4, long l) {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nCreateHardwareBuffer(IIIIJ)J", true, null);
    }

    private static long nCreateFromGraphicBuffer(GraphicBuffer graphicBuffer) {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nCreateFromGraphicBuffer(Landroid/graphics/GraphicBuffer;)J", true, null);
    }

    private static long nGetNativeFinalizer() {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nGetNativeFinalizer()J", true, null);
    }

    private static void nWriteHardwareBufferToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.hardware.HardwareBuffer#nWriteHardwareBufferToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static long nReadHardwareBufferFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nReadHardwareBufferFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    @FastNative
    private static int nGetWidth(long l) {
        return OverrideMethod.invokeI("android.hardware.HardwareBuffer#nGetWidth(J)I", true, null);
    }

    @FastNative
    private static int nGetHeight(long l) {
        return OverrideMethod.invokeI("android.hardware.HardwareBuffer#nGetHeight(J)I", true, null);
    }

    @FastNative
    private static int nGetFormat(long l) {
        return OverrideMethod.invokeI("android.hardware.HardwareBuffer#nGetFormat(J)I", true, null);
    }

    @FastNative
    private static int nGetLayers(long l) {
        return OverrideMethod.invokeI("android.hardware.HardwareBuffer#nGetLayers(J)I", true, null);
    }

    @FastNative
    private static long nGetUsage(long l) {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nGetUsage(J)J", true, null);
    }

    private static boolean nIsSupported(int n, int n2, int n3, int n4, long l) {
        return OverrideMethod.invokeI("android.hardware.HardwareBuffer#nIsSupported(IIIIJ)Z", true, null) != 0;
    }

    @CriticalNative
    private static long nEstimateSize(long l) {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nEstimateSize(J)J", true, null);
    }

    @CriticalNative
    private static long nGetId(long l) {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nGetId(J)J", true, null);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Usage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Format {
    }
}

