/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.hardware.camera2.params.MultiResolutionStreamInfo;
import android.media.Image;
import android.media.ImageReader;
import android.util.Size;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.Collection;
import java.util.concurrent.Executor;

public class MultiResolutionImageReader
implements AutoCloseable {
    private static final String TAG = "MultiResolutionImageReader";
    private final ImageReader[] mReaders;
    private final MultiResolutionStreamInfo[] mStreamInfo;
    private final int mFormat;
    private final int mMaxImages;

    public MultiResolutionImageReader(@NonNull Collection<MultiResolutionStreamInfo> streams, int format, int maxImages) {
        this.mFormat = format;
        this.mMaxImages = maxImages;
        if (streams == null || streams.size() <= 1) {
            throw new IllegalArgumentException("The streams info collection must contain at least 2 entries");
        }
        if (this.mMaxImages < 1) {
            throw new IllegalArgumentException("Maximum outstanding image count must be at least 1");
        }
        if (format == 17) {
            throw new IllegalArgumentException("NV21 format is not supported");
        }
        int numImageReaders = streams.size();
        this.mReaders = new ImageReader[numImageReaders];
        this.mStreamInfo = new MultiResolutionStreamInfo[numImageReaders];
        int index = 0;
        for (MultiResolutionStreamInfo streamInfo : streams) {
            this.mReaders[index] = ImageReader.newInstance(streamInfo.getWidth(), streamInfo.getHeight(), format, maxImages);
            this.mStreamInfo[index] = streamInfo;
            ++index;
        }
    }

    @FlaggedApi(value="com.android.internal.camera.flags.multiresolution_imagereader_usage_public")
    public MultiResolutionImageReader(@NonNull Collection<MultiResolutionStreamInfo> streams, int format, int maxImages, long usage) {
        this.mFormat = format;
        this.mMaxImages = maxImages;
        if (streams == null || streams.size() <= 1) {
            throw new IllegalArgumentException("The streams info collection must contain at least 2 entries");
        }
        if (this.mMaxImages < 1) {
            throw new IllegalArgumentException("Maximum outstanding image count must be at least 1");
        }
        if (format == 17) {
            throw new IllegalArgumentException("NV21 format is not supported");
        }
        int numImageReaders = streams.size();
        this.mReaders = new ImageReader[numImageReaders];
        this.mStreamInfo = new MultiResolutionStreamInfo[numImageReaders];
        int index = 0;
        for (MultiResolutionStreamInfo streamInfo : streams) {
            this.mReaders[index] = ImageReader.newInstance(streamInfo.getWidth(), streamInfo.getHeight(), format, maxImages, usage);
            this.mStreamInfo[index] = streamInfo;
            ++index;
        }
    }

    @SuppressLint(value={"ExecutorRegistration", "SamShouldBeLast"})
    public void setOnImageAvailableListener(@Nullable ImageReader.OnImageAvailableListener listener, @Nullable Executor executor) {
        for (int i = 0; i < this.mReaders.length; ++i) {
            this.mReaders[i].setOnImageAvailableListenerWithExecutor(listener, executor);
        }
    }

    @Override
    public void close() {
        this.flush();
        for (int i = 0; i < this.mReaders.length; ++i) {
            this.mReaders[i].close();
        }
    }

    protected void finalize() {
        this.close();
    }

    public void flush() {
        this.flushOther(null);
    }

    public void flushOther(ImageReader reader) {
        for (int i = 0; i < this.mReaders.length; ++i) {
            Image image;
            if (reader != null && reader == this.mReaders[i]) continue;
            while ((image = this.mReaders[i].acquireNextImageNoThrowISE()) != null) {
                image.close();
            }
        }
    }

    @NonNull
    public ImageReader[] getReaders() {
        return this.mReaders;
    }

    @FlaggedApi(value="com.android.internal.camera.flags.camera_device_setup")
    @NonNull
    public Surface getSurface(@NonNull Size configuredSize, @NonNull String physicalCameraId) {
        Preconditions.checkNotNull(configuredSize, "configuredSize must not be null");
        Preconditions.checkNotNull(physicalCameraId, "physicalCameraId must not be null");
        for (int i = 0; i < this.mStreamInfo.length; ++i) {
            if (this.mStreamInfo[i].getWidth() != configuredSize.getWidth() || this.mStreamInfo[i].getHeight() != configuredSize.getHeight() || !physicalCameraId.equals(this.mStreamInfo[i].getPhysicalCameraId())) continue;
            return this.mReaders[i].getSurface();
        }
        throw new IllegalArgumentException("configuredSize and physicalCameraId don't match with this MultiResolutionImageReader");
    }

    @NonNull
    public Surface getSurface() {
        int minReaderSize = this.mReaders[0].getWidth() * this.mReaders[0].getHeight();
        Surface candidateSurface = this.mReaders[0].getSurface();
        for (int i = 1; i < this.mReaders.length; ++i) {
            int readerSize = this.mReaders[i].getWidth() * this.mReaders[i].getHeight();
            if (readerSize >= minReaderSize) continue;
            minReaderSize = readerSize;
            candidateSurface = this.mReaders[i].getSurface();
        }
        return candidateSurface;
    }

    @NonNull
    public MultiResolutionStreamInfo getStreamInfoForImageReader(@NonNull ImageReader reader) {
        for (int i = 0; i < this.mReaders.length; ++i) {
            if (reader != this.mReaders[i]) continue;
            return this.mStreamInfo[i];
        }
        throw new IllegalArgumentException("ImageReader doesn't belong to this multi-resolution imagereader");
    }
}

