/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.annotation.FlaggedApi;
import android.content.Context;
import android.hardware.ICameraService;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.SessionConfiguration;
import android.hardware.camera2.utils.ExceptionUtils;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.concurrent.Executor;

@FlaggedApi(value="com.android.internal.camera.flags.camera_device_setup")
public class CameraDeviceSetupImpl
extends CameraDevice.CameraDeviceSetup {
    private final String mCameraId;
    private final CameraManager mCameraManager;
    private final Context mContext;
    private final int mTargetSdkVersion;
    private final Object mInterfaceLock = new Object();

    public CameraDeviceSetupImpl(@NonNull String cameraId, @NonNull CameraManager cameraManager, @NonNull Context context) {
        this.mCameraId = cameraId;
        this.mCameraManager = cameraManager;
        this.mContext = context;
        this.mTargetSdkVersion = context.getApplicationInfo().targetSdkVersion;
    }

    @Override
    @NonNull
    public CaptureRequest.Builder createCaptureRequest(int templateType) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mCameraManager.isCameraServiceDisabled()) {
                throw new IllegalArgumentException("No cameras available on device");
            }
            ICameraService cameraService = this.mCameraManager.getCameraService();
            if (cameraService == null) {
                throw new CameraAccessException(2, "Camera service is currently unavailable.");
            }
            try {
                CameraMetadataNative defaultRequest = cameraService.createDefaultRequest(this.mCameraId, templateType, this.mCameraManager.getClientAttribution(), this.mCameraManager.getDevicePolicyFromContext(this.mContext));
                CameraDeviceImpl.disableZslIfNeeded(defaultRequest, this.mTargetSdkVersion, templateType);
                return new CaptureRequest.Builder(defaultRequest, false, -1, this.mCameraId, null);
            }
            catch (ServiceSpecificException e) {
                throw ExceptionUtils.throwAsPublicException(e);
            }
            catch (RemoteException e) {
                throw ExceptionUtils.throwAsPublicException(e);
            }
        }
    }

    @Override
    public boolean isSessionConfigurationSupported(@NonNull SessionConfiguration config) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mCameraManager.isCameraServiceDisabled()) {
                throw new IllegalArgumentException("No cameras available on device");
            }
            ICameraService cameraService = this.mCameraManager.getCameraService();
            if (cameraService == null) {
                throw new CameraAccessException(2, "Camera service is currently unavailable.");
            }
            try {
                return cameraService.isSessionConfigurationWithParametersSupported(this.mCameraId, this.mTargetSdkVersion, config, this.mCameraManager.getClientAttribution(), this.mCameraManager.getDevicePolicyFromContext(this.mContext));
            }
            catch (ServiceSpecificException e) {
                throw ExceptionUtils.throwAsPublicException(e);
            }
            catch (RemoteException e) {
                throw ExceptionUtils.throwAsPublicException(e);
            }
        }
    }

    @Override
    @NonNull
    public CameraCharacteristics getSessionCharacteristics(@NonNull SessionConfiguration sessionConfig) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mCameraManager.isCameraServiceDisabled()) {
                throw new CameraAccessException(2, "Camera service is currently disabled");
            }
            ICameraService cameraService = this.mCameraManager.getCameraService();
            if (cameraService == null) {
                throw new CameraAccessException(2, "Camera service is currently unavailable");
            }
            try {
                CameraMetadataNative metadata = cameraService.getSessionCharacteristics(this.mCameraId, this.mTargetSdkVersion, CameraManager.getRotationOverride(this.mContext), sessionConfig, this.mCameraManager.getClientAttribution(), this.mCameraManager.getDevicePolicyFromContext(this.mContext));
                return this.mCameraManager.prepareCameraCharacteristics(this.mCameraId, metadata, cameraService);
            }
            catch (ServiceSpecificException e) {
                switch (e.errorCode) {
                    case 10: {
                        throw new UnsupportedOperationException("Session Characteristics Query not supported by device.");
                    }
                    case 3: {
                        throw new IllegalArgumentException("Invalid Session Configuration");
                    }
                }
                throw ExceptionUtils.throwAsPublicException(e);
            }
            catch (RemoteException e) {
                throw ExceptionUtils.throwAsPublicException(e);
            }
        }
    }

    @Override
    public void openCamera(@NonNull Executor executor, @NonNull CameraDevice.StateCallback callback) throws CameraAccessException {
        this.mCameraManager.openCamera(this.mCameraId, executor, callback);
    }

    @Override
    @NonNull
    public String getId() {
        return this.mCameraId;
    }

    public int hashCode() {
        return this.mCameraId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CameraDeviceSetupImpl) {
            CameraDeviceSetupImpl other = (CameraDeviceSetupImpl)obj;
            return this.mCameraId.equals(other.mCameraId);
        }
        return false;
    }

    public String toString() {
        return "CameraDeviceSetup(cameraId='" + this.mCameraId + "')";
    }

    public static boolean isCameraDeviceSetupSupported(CameraCharacteristics chars) {
        Integer queryVersion = chars.get(CameraCharacteristics.INFO_SESSION_CONFIGURATION_QUERY_VERSION);
        return queryVersion != null && queryVersion > 34;
    }
}

