/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.ICameraOfflineSession;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.hardware.camera2.utils.ExceptionUtils;
import android.hardware.camera2.utils.SubmitInfo;
import android.hardware.common.fmq.MQDescriptor;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.view.Surface;

public class ICameraDeviceUserWrapper {
    private final ICameraDeviceUser mRemoteDevice;

    public ICameraDeviceUserWrapper(ICameraDeviceUser remoteDevice) {
        if (remoteDevice == null) {
            throw new NullPointerException("Remote device may not be null");
        }
        this.mRemoteDevice = remoteDevice;
    }

    public void unlinkToDeath(IBinder.DeathRecipient recipient, int flags) {
        if (this.mRemoteDevice.asBinder() != null) {
            this.mRemoteDevice.asBinder().unlinkToDeath(recipient, flags);
        }
    }

    public void disconnect() {
        try {
            this.mRemoteDevice.disconnect();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public SubmitInfo startStreaming(int[] streamIdxArray, int[] surfaceIdxArray) throws CameraAccessException {
        try {
            return this.mRemoteDevice.startStreaming(streamIdxArray, surfaceIdxArray);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public SubmitInfo submitRequest(CaptureRequest request, boolean streaming) throws CameraAccessException {
        try {
            return this.mRemoteDevice.submitRequest(request, streaming);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public SubmitInfo submitRequestList(CaptureRequest[] requestList, boolean streaming) throws CameraAccessException {
        try {
            return this.mRemoteDevice.submitRequestList(requestList, streaming);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public long cancelRequest(int requestId) throws CameraAccessException {
        try {
            return this.mRemoteDevice.cancelRequest(requestId);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public void beginConfigure() throws CameraAccessException {
        try {
            this.mRemoteDevice.beginConfigure();
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public int[] endConfigure(int operatingMode, CameraMetadataNative sessionParams, long startTimeMs) throws CameraAccessException {
        try {
            return this.mRemoteDevice.endConfigure(operatingMode, sessionParams == null ? new CameraMetadataNative() : sessionParams, startTimeMs);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public void deleteStream(int streamId) throws CameraAccessException {
        try {
            this.mRemoteDevice.deleteStream(streamId);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public int createStream(OutputConfiguration outputConfiguration) throws CameraAccessException {
        try {
            return this.mRemoteDevice.createStream(outputConfiguration);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public int createInputStream(int width, int height, int format, boolean isMultiResolution) throws CameraAccessException {
        try {
            return this.mRemoteDevice.createInputStream(width, height, format, isMultiResolution);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public Surface getInputSurface() throws CameraAccessException {
        try {
            return this.mRemoteDevice.getInputSurface();
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public CameraMetadataNative createDefaultRequest(int templateId) throws CameraAccessException {
        try {
            return this.mRemoteDevice.createDefaultRequest(templateId);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public CameraMetadataNative getCameraInfo() throws CameraAccessException {
        try {
            return this.mRemoteDevice.getCameraInfo();
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public void waitUntilIdle() throws CameraAccessException {
        try {
            this.mRemoteDevice.waitUntilIdle();
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public boolean isSessionConfigurationSupported(SessionConfiguration sessionConfig) throws CameraAccessException {
        try {
            return this.mRemoteDevice.isSessionConfigurationSupported(sessionConfig);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 10) {
                throw new UnsupportedOperationException("Session configuration query not supported");
            }
            if (e.errorCode == 3) {
                throw new IllegalArgumentException("Invalid session configuration");
            }
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public long flush() throws CameraAccessException {
        try {
            return this.mRemoteDevice.flush();
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public void prepare(int streamId) throws CameraAccessException {
        try {
            this.mRemoteDevice.prepare(streamId);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public void tearDown(int streamId) throws CameraAccessException {
        try {
            this.mRemoteDevice.tearDown(streamId);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public void prepare2(int maxCount, int streamId) throws CameraAccessException {
        try {
            this.mRemoteDevice.prepare2(maxCount, streamId);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public void updateOutputConfiguration(int streamId, OutputConfiguration config) throws CameraAccessException {
        try {
            this.mRemoteDevice.updateOutputConfiguration(streamId, config);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public ICameraOfflineSession switchToOffline(ICameraDeviceCallbacks cbs, int[] offlineOutputIds) throws CameraAccessException {
        try {
            return this.mRemoteDevice.switchToOffline(cbs, offlineOutputIds);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public void finalizeOutputConfigurations(int streamId, OutputConfiguration deferredConfig) throws CameraAccessException {
        try {
            this.mRemoteDevice.finalizeOutputConfigurations(streamId, deferredConfig);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public void setCameraAudioRestriction(int mode) throws CameraAccessException {
        try {
            this.mRemoteDevice.setCameraAudioRestriction(mode);
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public int getGlobalAudioRestriction() throws CameraAccessException {
        try {
            return this.mRemoteDevice.getGlobalAudioRestriction();
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public boolean isPrimaryClient() throws CameraAccessException {
        try {
            return this.mRemoteDevice.isPrimaryClient();
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }

    public MQDescriptor<Byte, Byte> getCaptureResultMetadataQueue() throws CameraAccessException {
        try {
            return this.mRemoteDevice.getCaptureResultMetadataQueue();
        }
        catch (ServiceSpecificException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
        catch (RemoteException e) {
            throw ExceptionUtils.throwAsPublicException(e);
        }
    }
}

