/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import com.android.internal.util.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public abstract class TypeReference<T> {
    private final Type mType;
    private final int mHash;

    @UnsupportedAppUsage
    protected TypeReference() {
        ParameterizedType thisType = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.mType = thisType.getActualTypeArguments()[0];
        if (TypeReference.containsTypeVariable(this.mType)) {
            throw new IllegalArgumentException("Including a type variable in a type reference is not allowed");
        }
        this.mHash = this.mType.hashCode();
    }

    public Type getType() {
        return this.mType;
    }

    private TypeReference(Type type) {
        this.mType = type;
        if (TypeReference.containsTypeVariable(this.mType)) {
            throw new IllegalArgumentException("Including a type variable in a type reference is not allowed");
        }
        this.mHash = this.mType.hashCode();
    }

    public static <T> TypeReference<T> createSpecializedTypeReference(Class<T> klass) {
        return new SpecializedTypeReference<T>(klass);
    }

    @UnsupportedAppUsage
    public static TypeReference<?> createSpecializedTypeReference(Type type) {
        return new SpecializedBaseTypeReference(type);
    }

    public Class<? super T> getRawType() {
        return TypeReference.getRawType(this.mType);
    }

    private static Class<?> getRawType(Type type) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return TypeReference.getArrayClass(TypeReference.getRawType(((GenericArrayType)type).getGenericComponentType()));
        }
        if (type instanceof WildcardType) {
            return TypeReference.getRawType(((WildcardType)type).getUpperBounds());
        }
        if (type instanceof TypeVariable) {
            throw new AssertionError((Object)"Type variables are not allowed in type references");
        }
        throw new AssertionError((Object)("Unhandled branch to get raw type for type " + type));
    }

    private static Class<?> getRawType(Type[] types) {
        if (types == null) {
            return null;
        }
        for (Type type : types) {
            Class<?> klass = TypeReference.getRawType(type);
            if (klass == null) continue;
            return klass;
        }
        return null;
    }

    private static Class<?> getArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public TypeReference<?> getComponentType() {
        Type componentType = TypeReference.getComponentType(this.mType);
        return componentType != null ? TypeReference.createSpecializedTypeReference(componentType) : null;
    }

    private static Type getComponentType(Type type) {
        Preconditions.checkNotNull(type, "type must not be null");
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof ParameterizedType) {
            return null;
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        if (type instanceof WildcardType) {
            throw new UnsupportedOperationException("TODO: support wild card components");
        }
        if (type instanceof TypeVariable) {
            throw new AssertionError((Object)"Type variables are not allowed in type references");
        }
        throw new AssertionError((Object)("Unhandled branch to get component type for type " + type));
    }

    public boolean equals(@Nullable Object o) {
        return o instanceof TypeReference && this.mType.equals(((TypeReference)o).mType);
    }

    public int hashCode() {
        return this.mHash;
    }

    public static boolean containsTypeVariable(Type type) {
        if (type == null) {
            return false;
        }
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof Class) {
            Class klass = (Class)type;
            if (klass.getTypeParameters().length != 0) {
                return true;
            }
            return TypeReference.containsTypeVariable(klass.getDeclaringClass());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            for (Type arg : p.getActualTypeArguments()) {
                if (!TypeReference.containsTypeVariable(arg)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof WildcardType) {
            WildcardType wild = (WildcardType)type;
            return TypeReference.containsTypeVariable(wild.getLowerBounds()) || TypeReference.containsTypeVariable(wild.getUpperBounds());
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TypeReference<");
        TypeReference.toString(this.getType(), builder);
        builder.append(">");
        return builder.toString();
    }

    private static void toString(Type type, StringBuilder out) {
        if (type == null) {
            return;
        }
        if (type instanceof TypeVariable) {
            out.append(((TypeVariable)type).getName());
        } else if (type instanceof Class) {
            Class klass = (Class)type;
            out.append(klass.getName());
            TypeReference.toString(klass.getTypeParameters(), out);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            out.append(((Class)p.getRawType()).getName());
            TypeReference.toString(p.getActualTypeArguments(), out);
        } else if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            TypeReference.toString(gat.getGenericComponentType(), out);
            out.append("[]");
        } else {
            out.append(type.toString());
        }
    }

    private static void toString(Type[] types, StringBuilder out) {
        if (types == null) {
            return;
        }
        if (types.length == 0) {
            return;
        }
        out.append("<");
        for (int i = 0; i < types.length; ++i) {
            TypeReference.toString(types[i], out);
            if (i == types.length - 1) continue;
            out.append(", ");
        }
        out.append(">");
    }

    private static boolean containsTypeVariable(Type[] typeArray) {
        if (typeArray == null) {
            return false;
        }
        for (Type type : typeArray) {
            if (!TypeReference.containsTypeVariable(type)) continue;
            return true;
        }
        return false;
    }

    private static class SpecializedTypeReference<T>
    extends TypeReference<T> {
        public SpecializedTypeReference(Class<T> klass) {
            super(klass);
        }
    }

    private static class SpecializedBaseTypeReference
    extends TypeReference {
        public SpecializedBaseTypeReference(Type type) {
            super(type);
        }
    }
}

