/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.chre.flags.Flags;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;
import libcore.util.HexEncoding;

@SystemApi
@FlaggedApi(value="android.chre.flags.offload_api")
public class HubMessage
implements Parcelable {
    private static final int DEBUG_LOG_NUM_BYTES = 16;
    private final int mMessageType;
    private final byte[] mMessageBody;
    private final boolean mResponseRequired;
    private int mMessageSequenceNumber;
    @NonNull
    public static final Parcelable.Creator<HubMessage> CREATOR = new Parcelable.Creator<HubMessage>(){

        @Override
        public HubMessage createFromParcel(Parcel in) {
            return new HubMessage(in);
        }

        public HubMessage[] newArray(int size) {
            return new HubMessage[size];
        }
    };

    private HubMessage(int messageType, @NonNull byte[] messageBody, boolean responseRequired) {
        Objects.requireNonNull(messageBody, "messageBody cannot be null");
        this.mMessageType = messageType;
        this.mMessageBody = messageBody;
        this.mResponseRequired = responseRequired;
    }

    public int getMessageType() {
        return this.mMessageType;
    }

    @NonNull
    public byte[] getMessageBody() {
        return this.mMessageBody;
    }

    public boolean isResponseRequired() {
        return this.mResponseRequired;
    }

    public void setMessageSequenceNumber(int messageSequenceNumber) {
        this.mMessageSequenceNumber = messageSequenceNumber;
    }

    public int getMessageSequenceNumber() {
        return this.mMessageSequenceNumber;
    }

    private HubMessage(@NonNull Parcel in) {
        this.mMessageType = in.readInt();
        int msgSize = in.readInt();
        this.mMessageBody = new byte[msgSize];
        in.readByteArray(this.mMessageBody);
        this.mResponseRequired = in.readInt() == 1;
        this.mMessageSequenceNumber = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mMessageType);
        out.writeInt(this.mMessageBody.length);
        out.writeByteArray(this.mMessageBody);
        out.writeInt(this.mResponseRequired ? 1 : 0);
        out.writeInt(this.mMessageSequenceNumber);
    }

    @NonNull
    public String toString() {
        int length = this.mMessageBody.length;
        StringBuilder out = new StringBuilder();
        out.append("HubMessage[type = ").append(this.mMessageType);
        out.append(", length = ").append(this.mMessageBody.length);
        out.append(", messageSequenceNumber = ").append(this.mMessageSequenceNumber);
        out.append(", responseRequired = ").append(this.mResponseRequired);
        out.append("](");
        if (length > 0) {
            out.append("data = 0x");
        }
        for (int i = 0; i < Math.min(length, 16); ++i) {
            out.append(HexEncoding.encodeToString(this.mMessageBody[i], true));
            if ((i + 1) % 4 != 0) continue;
            out.append(" ");
        }
        if (length > 16) {
            out.append("...");
        }
        out.append(")");
        return out.toString();
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        boolean isEqual = false;
        if (object instanceof HubMessage) {
            HubMessage other = (HubMessage)object;
            isEqual = other.getMessageType() == this.mMessageType && Arrays.equals(other.getMessageBody(), this.mMessageBody) && other.isResponseRequired() == this.mResponseRequired && other.getMessageSequenceNumber() == this.mMessageSequenceNumber;
        }
        return isEqual;
    }

    public int hashCode() {
        if (!Flags.fixApiCheck()) {
            return super.hashCode();
        }
        return Objects.hash(this.mMessageType, Arrays.hashCode(this.mMessageBody), this.mResponseRequired, this.mMessageSequenceNumber);
    }

    public static class Builder {
        private int mMessageType;
        private byte[] mMessageBody;
        private boolean mResponseRequired = false;

        public Builder(int messageType, @NonNull byte[] messageBody) {
            this.mMessageType = messageType;
            this.mMessageBody = messageBody;
        }

        @NonNull
        public Builder setResponseRequired(boolean responseRequired) {
            this.mResponseRequired = responseRequired;
            return this;
        }

        @NonNull
        public HubMessage build() {
            return new HubMessage(this.mMessageType, this.mMessageBody, this.mResponseRequired);
        }
    }
}

