/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.FlaggedApi;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.IVirtualDisplayCallback;
import android.view.Display;
import android.view.Surface;
import com.android.internal.hidden_from_bootclasspath.android.companion.virtualdevice.flags.Flags;

public class VirtualDisplay {
    private final DisplayManagerGlobal mGlobal;
    private final Display mDisplay;
    private IVirtualDisplayCallback mToken;
    private Surface mSurface;

    VirtualDisplay(DisplayManagerGlobal global, Display display, IVirtualDisplayCallback token, Surface surface) {
        this.mGlobal = global;
        this.mDisplay = display;
        this.mToken = token;
        this.mSurface = surface;
    }

    public Display getDisplay() {
        return this.mDisplay;
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public IVirtualDisplayCallback getToken() {
        return this.mToken;
    }

    public void setSurface(Surface surface) {
        if (this.mSurface != surface) {
            this.mGlobal.setVirtualDisplaySurface(this.mToken, surface);
            this.mSurface = surface;
        }
    }

    public void resize(int width, int height, int densityDpi) {
        this.mGlobal.resizeVirtualDisplay(this.mToken, width, height, densityDpi);
    }

    public void release() {
        if (this.mToken != null) {
            this.mGlobal.releaseVirtualDisplay(this.mToken);
            this.mToken = null;
        }
    }

    @FlaggedApi(value="android.companion.virtualdevice.flags.virtual_display_rotation_api")
    public void setRotation(int rotation) {
        if (!Flags.virtualDisplayRotationApi()) {
            return;
        }
        if (rotation != 0 && rotation != 1 && rotation != 2 && rotation != 3) {
            throw new IllegalArgumentException("Invalid virtual display rotation value: " + rotation);
        }
        if (this.mToken != null && this.mDisplay.getRotation() != rotation) {
            this.mGlobal.setVirtualDisplayRotation(this.mToken, rotation);
        }
    }

    public String toString() {
        return "VirtualDisplay{display=" + this.mDisplay + ", token=" + this.mToken + ", surface=" + this.mSurface + "}";
    }

    public static abstract class Callback {
        public void onPaused() {
        }

        public void onResumed() {
        }

        public void onStopped() {
        }
    }
}

