/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.face;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.BiometricStateListener;
import android.hardware.biometrics.CryptoObject;
import android.hardware.biometrics.IBiometricServiceLockoutResetCallback;
import android.hardware.face.Face;
import android.hardware.face.FaceAuthenticateOptions;
import android.hardware.face.FaceAuthenticationFrame;
import android.hardware.face.FaceCallback;
import android.hardware.face.FaceEnrollCell;
import android.hardware.face.FaceEnrollFrame;
import android.hardware.face.FaceEnrollOptions;
import android.hardware.face.FaceSensorProperties;
import android.hardware.face.FaceSensorPropertiesInternal;
import android.hardware.face.IFaceAuthenticatorsRegisteredCallback;
import android.hardware.face.IFaceService;
import android.hardware.face.IFaceServiceReceiver;
import android.os.Binder;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.Trace;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Slog;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;

public class FaceManager
implements BiometricAuthenticator {
    private static final String TAG = "FaceManager";
    private final IFaceService mService;
    private final Context mContext;
    private final IBinder mToken = new Binder();
    private Handler mHandler;
    private List<FaceSensorPropertiesInternal> mProps = new ArrayList<FaceSensorPropertiesInternal>();
    private HandlerExecutor mExecutor;

    public FaceManager(Context context, IFaceService service) {
        this.mContext = context;
        this.mService = service;
        if (this.mService == null) {
            Slog.v(TAG, "FaceAuthenticationManagerService was null");
        }
        this.mHandler = context.getMainThreadHandler();
        this.mExecutor = new HandlerExecutor(this.mHandler);
        if (context.checkCallingOrSelfPermission("android.permission.USE_BIOMETRIC_INTERNAL") == 0) {
            this.addAuthenticatorsRegisteredCallback(new IFaceAuthenticatorsRegisteredCallback.Stub(){

                @Override
                public void onAllAuthenticatorsRegistered(@NonNull List<FaceSensorPropertiesInternal> sensors) {
                    FaceManager.this.mProps = sensors;
                }
            });
        }
    }

    private void useHandler(Handler handler) {
        if (handler != null) {
            this.mHandler = handler;
            this.mExecutor = new HandlerExecutor(this.mHandler);
        } else if (this.mHandler != this.mContext.getMainThreadHandler()) {
            this.mHandler = this.mContext.getMainThreadHandler();
            this.mExecutor = new HandlerExecutor(this.mHandler);
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void authenticate(@Nullable CryptoObject crypto, @Nullable CancellationSignal cancel, @NonNull AuthenticationCallback callback, @Nullable Handler handler, int userId) {
        this.authenticate(crypto, cancel, callback, handler, new FaceAuthenticateOptions.Builder().setUserId(userId).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void authenticate(@Nullable CryptoObject crypto, @Nullable CancellationSignal cancel, @NonNull AuthenticationCallback callback, @Nullable Handler handler, @NonNull FaceAuthenticateOptions options) {
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an authentication callback");
        }
        if (cancel != null && cancel.isCanceled()) {
            Slog.w(TAG, "authentication already canceled");
            return;
        }
        options.setOpPackageName(this.mContext.getOpPackageName());
        options.setAttributionTag(this.mContext.getAttributionTag());
        if (this.mService != null) {
            try {
                FaceCallback faceCallback = new FaceCallback(callback, crypto);
                this.useHandler(handler);
                long operationId = crypto != null ? crypto.getOpId() : 0L;
                Trace.beginSection("FaceManager#authenticate");
                long authId = this.mService.authenticate(this.mToken, operationId, new FaceServiceReceiver(faceCallback), options);
                if (cancel != null) {
                    cancel.setOnCancelListener(new OnAuthenticationCancelListener(authId));
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception while authenticating: ", e);
                callback.onAuthenticationError(1, FaceManager.getErrorString(this.mContext, 1, 0));
            }
            finally {
                Trace.endSection();
            }
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void detectFace(@NonNull CancellationSignal cancel, @NonNull FaceDetectionCallback callback, @NonNull FaceAuthenticateOptions options) {
        if (this.mService == null) {
            return;
        }
        if (cancel.isCanceled()) {
            Slog.w(TAG, "Detection already cancelled");
            return;
        }
        options.setOpPackageName(this.mContext.getOpPackageName());
        options.setAttributionTag(this.mContext.getAttributionTag());
        FaceCallback faceCallback = new FaceCallback(callback);
        try {
            long authId = this.mService.detectFace(this.mToken, new FaceServiceReceiver(faceCallback), options);
            cancel.setOnCancelListener(new OnFaceDetectionCancelListener(authId));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Remote exception when requesting finger detect", e);
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void enroll(int userId, byte[] hardwareAuthToken, CancellationSignal cancel, EnrollmentCallback callback, int[] disabledFeatures) {
        this.enroll(userId, hardwareAuthToken, cancel, callback, disabledFeatures, null, false, new FaceEnrollOptions.Builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void enroll(int userId, byte[] hardwareAuthToken, CancellationSignal cancel, EnrollmentCallback callback, int[] disabledFeatures, @Nullable Surface previewSurface, boolean debugConsent, FaceEnrollOptions options) {
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an enrollment callback");
        }
        if (cancel != null && cancel.isCanceled()) {
            Slog.w(TAG, "enrollment already canceled");
            return;
        }
        if (hardwareAuthToken == null) {
            callback.onEnrollmentError(2, FaceManager.getErrorString(this.mContext, 2, 0));
            return;
        }
        if (this.getEnrolledFaces(userId).size() >= this.mContext.getResources().getInteger(17694878)) {
            callback.onEnrollmentError(1, FaceManager.getErrorString(this.mContext, 1, 0));
            return;
        }
        if (this.mService != null) {
            try {
                FaceCallback faceCallback = new FaceCallback(callback);
                Trace.beginSection("FaceManager#enroll");
                long enrollId = this.mService.enroll(userId, this.mToken, hardwareAuthToken, new FaceServiceReceiver(faceCallback), this.mContext.getOpPackageName(), disabledFeatures, previewSurface, debugConsent, options);
                if (cancel != null) {
                    cancel.setOnCancelListener(new OnEnrollCancelListener(enrollId));
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception in enroll: ", e);
                callback.onEnrollmentError(1, FaceManager.getErrorString(this.mContext, 1, 0));
            }
            finally {
                Trace.endSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void enrollRemotely(int userId, byte[] hardwareAuthToken, CancellationSignal cancel, EnrollmentCallback callback, int[] disabledFeatures) {
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an enrollment callback");
        }
        if (cancel != null && cancel.isCanceled()) {
            Slog.w(TAG, "enrollRemotely is already canceled.");
            return;
        }
        if (this.mService != null) {
            try {
                FaceCallback faceCallback = new FaceCallback(callback);
                Trace.beginSection("FaceManager#enrollRemotely");
                long enrolId = this.mService.enrollRemotely(userId, this.mToken, hardwareAuthToken, new FaceServiceReceiver(faceCallback), this.mContext.getOpPackageName(), disabledFeatures);
                if (cancel != null) {
                    cancel.setOnCancelListener(new OnEnrollCancelListener(enrolId));
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception in enrollRemotely: ", e);
                callback.onEnrollmentError(1, FaceManager.getErrorString(this.mContext, 1, 0));
            }
            finally {
                Trace.endSection();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void generateChallenge(int sensorId, int userId, GenerateChallengeCallback callback) {
        if (this.mService != null) {
            try {
                FaceCallback faceCallback = new FaceCallback(callback);
                this.mService.generateChallenge(this.mToken, sensorId, userId, new FaceServiceReceiver(faceCallback), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void generateChallenge(int userId, GenerateChallengeCallback callback) {
        List<FaceSensorPropertiesInternal> faceSensorProperties = this.getSensorPropertiesInternal();
        if (faceSensorProperties.isEmpty()) {
            Slog.e(TAG, "No sensors");
            return;
        }
        int sensorId = faceSensorProperties.get((int)0).sensorId;
        this.generateChallenge(sensorId, userId, callback);
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void revokeChallenge(int sensorId, int userId, long challenge) {
        if (this.mService != null) {
            try {
                this.mService.revokeChallenge(this.mToken, sensorId, userId, this.mContext.getOpPackageName(), challenge);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void resetLockout(int sensorId, int userId, @Nullable byte[] hardwareAuthToken) {
        if (this.mService != null) {
            try {
                this.mService.resetLockout(this.mToken, sensorId, userId, hardwareAuthToken, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void setFeature(int userId, int feature, boolean enabled, byte[] hardwareAuthToken, SetFeatureCallback callback) {
        if (this.mService != null) {
            try {
                FaceCallback faceCallback = new FaceCallback(callback);
                this.mService.setFeature(this.mToken, userId, feature, enabled, hardwareAuthToken, new FaceServiceReceiver(faceCallback), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void getFeature(int userId, int feature, GetFeatureCallback callback) {
        if (this.mService != null) {
            try {
                FaceCallback faceCallback = new FaceCallback(callback);
                this.mService.getFeature(this.mToken, userId, feature, new FaceServiceReceiver(faceCallback), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void remove(Face face, int userId, RemovalCallback callback) {
        if (this.mService != null) {
            try {
                FaceCallback faceCallback = new FaceCallback(callback, face);
                this.mService.remove(this.mToken, face.getBiometricId(), userId, new FaceServiceReceiver(faceCallback), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void removeAll(int userId, @NonNull RemovalCallback callback) {
        if (this.mService != null) {
            try {
                FaceCallback faceCallback = new FaceCallback(callback);
                this.mService.removeAll(this.mToken, userId, new FaceServiceReceiver(faceCallback), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public List<Face> getEnrolledFaces(int userId) {
        List<FaceSensorPropertiesInternal> faceSensorProperties = this.getSensorPropertiesInternal();
        if (faceSensorProperties.isEmpty()) {
            Slog.e(TAG, "No sensors");
            return new ArrayList<Face>();
        }
        if (this.mService != null) {
            try {
                return this.mService.getEnrolledFaces(faceSensorProperties.get((int)0).sensorId, userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public List<Face> getEnrolledFaces() {
        return this.getEnrolledFaces(UserHandle.myUserId());
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public boolean hasEnrolledTemplates() {
        return this.hasEnrolledTemplates(UserHandle.myUserId());
    }

    @RequiresPermission(allOf={"android.permission.USE_BIOMETRIC_INTERNAL", "android.permission.INTERACT_ACROSS_USERS"})
    public boolean hasEnrolledTemplates(int userId) {
        List<FaceSensorPropertiesInternal> faceSensorProperties = this.getSensorPropertiesInternal();
        if (faceSensorProperties.isEmpty()) {
            Slog.e(TAG, "No sensors");
            return false;
        }
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledFaces(faceSensorProperties.get((int)0).sensorId, userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public boolean isHardwareDetected() {
        List<FaceSensorPropertiesInternal> faceSensorProperties = this.getSensorPropertiesInternal();
        if (faceSensorProperties.isEmpty()) {
            Slog.e(TAG, "No sensors");
            return false;
        }
        if (this.mService != null) {
            try {
                return this.mService.isHardwareDetected(faceSensorProperties.get((int)0).sensorId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Slog.w(TAG, "isFaceHardwareDetected(): Service not connected!");
        return false;
    }

    @NonNull
    public List<FaceSensorProperties> getSensorProperties() {
        ArrayList<FaceSensorProperties> properties = new ArrayList<FaceSensorProperties>();
        List<FaceSensorPropertiesInternal> internalProperties = this.getSensorPropertiesInternal();
        for (FaceSensorPropertiesInternal internalProp : internalProperties) {
            properties.add(FaceSensorProperties.from(internalProp));
        }
        return properties;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    @NonNull
    public List<FaceSensorPropertiesInternal> getSensorPropertiesInternal() {
        try {
            if (!this.mProps.isEmpty() || this.mService == null) {
                return this.mProps;
            }
            return this.mService.getSensorPropertiesInternal(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return this.mProps;
        }
    }

    public void registerBiometricStateListener(@NonNull BiometricStateListener listener) {
        try {
            this.mService.registerBiometricStateListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void addAuthenticatorsRegisteredCallback(IFaceAuthenticatorsRegisteredCallback callback) {
        if (this.mService != null) {
            try {
                this.mService.addAuthenticatorsRegisteredCallback(callback);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "addAuthenticatorsRegisteredCallback(): Service not connected!");
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public int getLockoutModeForUser(int sensorId, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getLockoutModeForUser(sensorId, userId);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void addLockoutResetCallback(final LockoutResetCallback callback) {
        if (this.mService != null) {
            try {
                final PowerManager powerManager = this.mContext.getSystemService(PowerManager.class);
                this.mService.addLockoutResetCallback(new IBiometricServiceLockoutResetCallback.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLockoutReset(int sensorId, IRemoteCallback serverCallback) throws RemoteException {
                        try {
                            PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, "faceLockoutResetCallback");
                            wakeLock.acquire();
                            FaceManager.this.mHandler.post(() -> {
                                try {
                                    callback.onLockoutReset(sensorId);
                                }
                                finally {
                                    wakeLock.release();
                                }
                            });
                        }
                        finally {
                            serverCallback.sendResult(null);
                        }
                    }
                }, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "addLockoutResetCallback(): Service not connected!");
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void scheduleWatchdog() {
        try {
            this.mService.scheduleWatchdog();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void cancelEnrollment(long requestId) {
        if (this.mService != null) {
            try {
                this.mService.cancelEnrollment(this.mToken, requestId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void cancelAuthentication(long requestId) {
        if (this.mService != null) {
            try {
                this.mService.cancelAuthentication(this.mToken, this.mContext.getOpPackageName(), requestId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void cancelFaceDetect(long requestId) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.cancelFaceDetect(this.mToken, this.mContext.getOpPackageName(), requestId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static String getErrorString(Context context, int errMsg, int vendorCode) {
        switch (errMsg) {
            case 1: {
                return context.getString(0x1040401);
            }
            case 2: {
                return context.getString(17040394);
            }
            case 3: {
                return context.getString(17040393);
            }
            case 4: {
                return context.getString(17040390);
            }
            case 5: {
                return context.getString(0x1040400);
            }
            case 7: {
                return context.getString(17040387);
            }
            case 9: {
                return context.getString(0x1040404);
            }
            case 10: {
                return context.getString(17040395);
            }
            case 11: {
                return context.getString(17040391);
            }
            case 12: {
                return context.getString(17040386);
            }
            case 15: {
                return context.getString(17040392);
            }
            case 16: {
                return context.getString(0x1040411);
            }
            case 8: {
                String[] msgArray = context.getResources().getStringArray(17236219);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Invalid error message: " + errMsg + ", " + vendorCode);
        return context.getString(17040396);
    }

    public static int getMappedAcquiredInfo(int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 1;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 2;
            }
            case 22: {
                return 1000 + vendorCode;
            }
        }
        return 0;
    }

    @Nullable
    public static String getAuthHelpMessage(Context context, int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: 
            case 20: {
                return null;
            }
            case 11: {
                return context.getString(17040358);
            }
            case 4: {
                return context.getString(17040368);
            }
            case 5: {
                return context.getString(17040371);
            }
            case 6: {
                return context.getString(17040374);
            }
            case 7: {
                return context.getString(17040372);
            }
            case 8: {
                return context.getString(17040373);
            }
            case 9: {
                return context.getString(17040376);
            }
            case 10: {
                return context.getString(17040361);
            }
            case 16: {
                return context.getString(17040360);
            }
            case 17: {
                return context.getString(17040366);
            }
            case 18: {
                return context.getString(17040364);
            }
            case 1: {
                return context.getString(17040355);
            }
            case 2: {
                return context.getString(17040367);
            }
            case 3: {
                return context.getString(17040369);
            }
            case 12: {
                return context.getString(17040375);
            }
            case 13: {
                return context.getString(17040362);
            }
            case 14: {
                return context.getString(17040370);
            }
            case 15: {
                return context.getString(17040377);
            }
            case 19: {
                return context.getString(17040359);
            }
            case 21: {
                return context.getString(17040365);
            }
            case 25: {
                return context.getString(17040353);
            }
            case 26: {
                return context.getString(17040356);
            }
            case 22: {
                String[] msgArray = context.getResources().getStringArray(17236218);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Unknown authentication acquired message: " + acquireInfo + ", " + vendorCode);
        return null;
    }

    @Nullable
    public static String getEnrollHelpMessage(Context context, int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: 
            case 20: {
                return null;
            }
            case 1: {
                return context.getString(17040355);
            }
            case 2: {
                return context.getString(17040367);
            }
            case 3: {
                return context.getString(17040369);
            }
            case 4: {
                return context.getString(17040368);
            }
            case 5: {
                return context.getString(17040371);
            }
            case 6: {
                return context.getString(17040374);
            }
            case 7: {
                return context.getString(17040372);
            }
            case 8: {
                return context.getString(17040373);
            }
            case 9: {
                return context.getString(17040376);
            }
            case 10: {
                return context.getString(17040361);
            }
            case 11: {
                return context.getString(17040358);
            }
            case 12: {
                return context.getString(17040375);
            }
            case 13: {
                return context.getString(17040362);
            }
            case 14: {
                return context.getString(17040370);
            }
            case 15: {
                return context.getString(17040377);
            }
            case 16: {
                return context.getString(17040360);
            }
            case 17: {
                return context.getString(17040366);
            }
            case 18: {
                return context.getString(17040364);
            }
            case 19: {
                return context.getString(17040359);
            }
            case 21: {
                return context.getString(17040365);
            }
            case 25: {
                return context.getString(17040353);
            }
            case 26: {
                return context.getString(17040356);
            }
            case 22: {
                String[] msgArray = context.getResources().getStringArray(17236218);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Unknown enrollment acquired message: " + acquireInfo + ", " + vendorCode);
        return null;
    }

    public static abstract class AuthenticationCallback
    extends BiometricAuthenticator.AuthenticationCallback {
        @Override
        public void onAuthenticationError(int errorCode, CharSequence errString) {
        }

        @Override
        public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
        }

        public void onAuthenticationSucceeded(AuthenticationResult result) {
        }

        @Override
        public void onAuthenticationFailed() {
        }

        @Override
        public void onAuthenticationAcquired(int acquireInfo) {
        }
    }

    private class FaceServiceReceiver
    extends IFaceServiceReceiver.Stub {
        private final FaceCallback mFaceCallback;

        FaceServiceReceiver(FaceCallback faceCallback) {
            this.mFaceCallback = faceCallback;
        }

        @Override
        public void onEnrollResult(Face face, int remaining) {
            FaceManager.this.mExecutor.execute(() -> this.mFaceCallback.sendEnrollResult(remaining));
        }

        @Override
        public void onAcquired(int acquireInfo, int vendorCode) {
            FaceManager.this.mExecutor.execute(() -> this.mFaceCallback.sendAcquiredResult(FaceManager.this.mContext, acquireInfo, vendorCode));
        }

        @Override
        public void onAuthenticationSucceeded(Face face, int userId, boolean isStrongBiometric) {
            FaceManager.this.mExecutor.execute(() -> this.mFaceCallback.sendAuthenticatedSucceeded(face, userId, isStrongBiometric));
        }

        @Override
        public void onFaceDetected(int sensorId, int userId, boolean isStrongBiometric) {
            FaceManager.this.mExecutor.execute(() -> this.mFaceCallback.sendFaceDetected(sensorId, userId, isStrongBiometric));
        }

        @Override
        public void onAuthenticationFailed() {
            FaceManager.this.mExecutor.execute(this.mFaceCallback::sendAuthenticatedFailed);
        }

        @Override
        public void onError(int error, int vendorCode) {
            FaceManager.this.mExecutor.execute(() -> this.mFaceCallback.sendErrorResult(FaceManager.this.mContext, error, vendorCode));
        }

        @Override
        public void onRemoved(Face face, int remaining) {
            FaceManager.this.mExecutor.execute(() -> this.mFaceCallback.sendRemovedResult(face, remaining));
            if (remaining == 0) {
                Settings.Secure.putIntForUser(FaceManager.this.mContext.getContentResolver(), "face_unlock_re_enroll", 0, -2);
            }
        }

        @Override
        public void onFeatureSet(boolean success, int feature) {
            FaceManager.this.mExecutor.execute(() -> this.mFaceCallback.sendSetFeatureCompleted(success, feature));
        }

        @Override
        public void onFeatureGet(boolean success, int[] features, boolean[] featureState) {
            FaceManager.this.mExecutor.execute(() -> this.mFaceCallback.sendGetFeatureCompleted(success, features, featureState));
        }

        @Override
        public void onChallengeGenerated(int sensorId, int userId, long challenge) {
            FaceManager.this.mExecutor.execute(() -> this.mFaceCallback.sendChallengeGenerated(sensorId, userId, challenge));
        }

        @Override
        public void onAuthenticationFrame(FaceAuthenticationFrame frame) {
            FaceManager.this.mExecutor.execute(() -> this.mFaceCallback.sendAuthenticationFrame(FaceManager.this.mContext, frame));
        }

        @Override
        public void onEnrollmentFrame(FaceEnrollFrame frame) {
            FaceManager.this.mExecutor.execute(() -> this.mFaceCallback.sendEnrollmentFrame(FaceManager.this.mContext, frame));
        }
    }

    private class OnAuthenticationCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        OnAuthenticationCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FaceManager.TAG, "Cancel face authentication requested for: " + this.mAuthRequestId);
            FaceManager.this.cancelAuthentication(this.mAuthRequestId);
        }
    }

    public static interface FaceDetectionCallback {
        public void onFaceDetected(int var1, int var2, boolean var3);

        default public void onDetectionError(int errorMsgId) {
        }
    }

    private class OnFaceDetectionCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        OnFaceDetectionCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FaceManager.TAG, "Cancel face detect requested for: " + this.mAuthRequestId);
            FaceManager.this.cancelFaceDetect(this.mAuthRequestId);
        }
    }

    public static abstract class EnrollmentCallback {
        public void onEnrollmentError(int errMsgId, CharSequence errString) {
        }

        public void onEnrollmentHelp(int helpMsgId, CharSequence helpString) {
        }

        public void onEnrollmentFrame(int helpCode, @Nullable CharSequence helpMessage, @Nullable FaceEnrollCell cell, int stage, float pan, float tilt, float distance) {
            this.onEnrollmentHelp(helpCode, helpMessage);
        }

        public void onEnrollmentProgress(int remaining) {
        }
    }

    private class OnEnrollCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        private OnEnrollCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FaceManager.TAG, "Cancel face enrollment requested for: " + this.mAuthRequestId);
            FaceManager.this.cancelEnrollment(this.mAuthRequestId);
        }
    }

    public static interface GenerateChallengeCallback {
        public void onGenerateChallengeResult(int var1, int var2, long var3);
    }

    public static abstract class SetFeatureCallback {
        public abstract void onCompleted(boolean var1, int var2);
    }

    public static abstract class GetFeatureCallback {
        public abstract void onCompleted(boolean var1, int[] var2, boolean[] var3);
    }

    public static abstract class RemovalCallback {
        public void onRemovalError(Face face, int errMsgId, CharSequence errString) {
        }

        public void onRemovalSucceeded(@Nullable Face face, int remaining) {
        }
    }

    public static abstract class LockoutResetCallback {
        public void onLockoutReset(int sensorId) {
        }
    }

    public static class AuthenticationResult {
        private final Face mFace;
        private final CryptoObject mCryptoObject;
        private final int mUserId;
        private final boolean mIsStrongBiometric;

        public AuthenticationResult(CryptoObject crypto, Face face, int userId, boolean isStrongBiometric) {
            this.mCryptoObject = crypto;
            this.mFace = face;
            this.mUserId = userId;
            this.mIsStrongBiometric = isStrongBiometric;
        }

        public CryptoObject getCryptoObject() {
            return this.mCryptoObject;
        }

        public Face getFace() {
            return this.mFace;
        }

        public int getUserId() {
            return this.mUserId;
        }

        public boolean isStrongBiometric() {
            return this.mIsStrongBiometric;
        }
    }
}

