/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.face;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.hardware.biometrics.AuthenticationStateListener;
import android.hardware.biometrics.IBiometricSensorReceiver;
import android.hardware.biometrics.IBiometricServiceLockoutResetCallback;
import android.hardware.biometrics.IBiometricStateListener;
import android.hardware.biometrics.IInvalidationCallback;
import android.hardware.biometrics.ITestSession;
import android.hardware.biometrics.ITestSessionCallback;
import android.hardware.face.Face;
import android.hardware.face.FaceAuthenticateOptions;
import android.hardware.face.FaceEnrollOptions;
import android.hardware.face.FaceSensorConfigurations;
import android.hardware.face.FaceSensorPropertiesInternal;
import android.hardware.face.IFaceAuthenticatorsRegisteredCallback;
import android.hardware.face.IFaceServiceReceiver;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;

public interface IFaceService
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.face.IFaceService";

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public ITestSession createTestSession(int var1, ITestSessionCallback var2, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public byte[] dumpSensorServiceStateProto(int var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public List<FaceSensorPropertiesInternal> getSensorPropertiesInternal(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public FaceSensorPropertiesInternal getSensorProperties(int var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public long authenticate(IBinder var1, long var2, IFaceServiceReceiver var4, FaceAuthenticateOptions var5) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public long detectFace(IBinder var1, IFaceServiceReceiver var2, FaceAuthenticateOptions var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void prepareForAuthentication(boolean var1, IBinder var2, long var3, IBiometricSensorReceiver var5, FaceAuthenticateOptions var6, long var7, int var9, boolean var10) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void startPreparedClient(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void cancelAuthentication(IBinder var1, String var2, long var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void cancelFaceDetect(IBinder var1, String var2, long var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void cancelAuthenticationFromService(int var1, IBinder var2, String var3, long var4) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_BIOMETRIC")
    public long enroll(int var1, IBinder var2, byte[] var3, IFaceServiceReceiver var4, String var5, int[] var6, Surface var7, boolean var8, FaceEnrollOptions var9) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_BIOMETRIC")
    public long enrollRemotely(int var1, IBinder var2, byte[] var3, IFaceServiceReceiver var4, String var5, int[] var6) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_BIOMETRIC")
    public void cancelEnrollment(IBinder var1, long var2) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void remove(IBinder var1, int var2, int var3, IFaceServiceReceiver var4, String var5) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void removeAll(IBinder var1, int var2, IFaceServiceReceiver var3, String var4) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public List<Face> getEnrolledFaces(int var1, int var2, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public boolean isHardwareDetected(int var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_BIOMETRIC")
    public void generateChallenge(IBinder var1, int var2, int var3, IFaceServiceReceiver var4, String var5) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_BIOMETRIC")
    public void revokeChallenge(IBinder var1, int var2, int var3, String var4, long var5) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public boolean hasEnrolledFaces(int var1, int var2, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public int getLockoutModeForUser(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void invalidateAuthenticatorId(int var1, int var2, IInvalidationCallback var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public long getAuthenticatorId(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void resetLockout(IBinder var1, int var2, int var3, byte[] var4, String var5) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void addLockoutResetCallback(IBiometricServiceLockoutResetCallback var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void setFeature(IBinder var1, int var2, int var3, boolean var4, byte[] var5, IFaceServiceReceiver var6, String var7) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_BIOMETRIC")
    public void getFeature(IBinder var1, int var2, int var3, IFaceServiceReceiver var4, String var5) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void registerAuthenticators(FaceSensorConfigurations var1) throws RemoteException;

    public void addAuthenticatorsRegisteredCallback(IFaceAuthenticatorsRegisteredCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void registerAuthenticationStateListener(AuthenticationStateListener var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void unregisterAuthenticationStateListener(AuthenticationStateListener var1) throws RemoteException;

    public void registerBiometricStateListener(IBiometricStateListener var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void scheduleWatchdog() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IFaceService {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_createTestSession = 1;
        static final int TRANSACTION_dumpSensorServiceStateProto = 2;
        static final int TRANSACTION_getSensorPropertiesInternal = 3;
        static final int TRANSACTION_getSensorProperties = 4;
        static final int TRANSACTION_authenticate = 5;
        static final int TRANSACTION_detectFace = 6;
        static final int TRANSACTION_prepareForAuthentication = 7;
        static final int TRANSACTION_startPreparedClient = 8;
        static final int TRANSACTION_cancelAuthentication = 9;
        static final int TRANSACTION_cancelFaceDetect = 10;
        static final int TRANSACTION_cancelAuthenticationFromService = 11;
        static final int TRANSACTION_enroll = 12;
        static final int TRANSACTION_enrollRemotely = 13;
        static final int TRANSACTION_cancelEnrollment = 14;
        static final int TRANSACTION_remove = 15;
        static final int TRANSACTION_removeAll = 16;
        static final int TRANSACTION_getEnrolledFaces = 17;
        static final int TRANSACTION_isHardwareDetected = 18;
        static final int TRANSACTION_generateChallenge = 19;
        static final int TRANSACTION_revokeChallenge = 20;
        static final int TRANSACTION_hasEnrolledFaces = 21;
        static final int TRANSACTION_getLockoutModeForUser = 22;
        static final int TRANSACTION_invalidateAuthenticatorId = 23;
        static final int TRANSACTION_getAuthenticatorId = 24;
        static final int TRANSACTION_resetLockout = 25;
        static final int TRANSACTION_addLockoutResetCallback = 26;
        static final int TRANSACTION_setFeature = 27;
        static final int TRANSACTION_getFeature = 28;
        static final int TRANSACTION_registerAuthenticators = 29;
        static final int TRANSACTION_addAuthenticatorsRegisteredCallback = 30;
        static final int TRANSACTION_registerAuthenticationStateListener = 31;
        static final int TRANSACTION_unregisterAuthenticationStateListener = 32;
        static final int TRANSACTION_registerBiometricStateListener = 33;
        static final int TRANSACTION_scheduleWatchdog = 34;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IFaceService.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IFaceService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IFaceService.DESCRIPTOR);
            if (iin != null && iin instanceof IFaceService) {
                return (IFaceService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createTestSession";
                }
                case 2: {
                    return "dumpSensorServiceStateProto";
                }
                case 3: {
                    return "getSensorPropertiesInternal";
                }
                case 4: {
                    return "getSensorProperties";
                }
                case 5: {
                    return "authenticate";
                }
                case 6: {
                    return "detectFace";
                }
                case 7: {
                    return "prepareForAuthentication";
                }
                case 8: {
                    return "startPreparedClient";
                }
                case 9: {
                    return "cancelAuthentication";
                }
                case 10: {
                    return "cancelFaceDetect";
                }
                case 11: {
                    return "cancelAuthenticationFromService";
                }
                case 12: {
                    return "enroll";
                }
                case 13: {
                    return "enrollRemotely";
                }
                case 14: {
                    return "cancelEnrollment";
                }
                case 15: {
                    return "remove";
                }
                case 16: {
                    return "removeAll";
                }
                case 17: {
                    return "getEnrolledFaces";
                }
                case 18: {
                    return "isHardwareDetected";
                }
                case 19: {
                    return "generateChallenge";
                }
                case 20: {
                    return "revokeChallenge";
                }
                case 21: {
                    return "hasEnrolledFaces";
                }
                case 22: {
                    return "getLockoutModeForUser";
                }
                case 23: {
                    return "invalidateAuthenticatorId";
                }
                case 24: {
                    return "getAuthenticatorId";
                }
                case 25: {
                    return "resetLockout";
                }
                case 26: {
                    return "addLockoutResetCallback";
                }
                case 27: {
                    return "setFeature";
                }
                case 28: {
                    return "getFeature";
                }
                case 29: {
                    return "registerAuthenticators";
                }
                case 30: {
                    return "addAuthenticatorsRegisteredCallback";
                }
                case 31: {
                    return "registerAuthenticationStateListener";
                }
                case 32: {
                    return "unregisterAuthenticationStateListener";
                }
                case 33: {
                    return "registerBiometricStateListener";
                }
                case 34: {
                    return "scheduleWatchdog";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IFaceService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    ITestSessionCallback _arg1 = ITestSessionCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    ITestSession _result = this.createTestSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    byte[] _result = this.dumpSensorServiceStateProto(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<FaceSensorPropertiesInternal> _result = this.getSensorPropertiesInternal(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    FaceSensorPropertiesInternal _result = this.getSensorProperties(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    long _arg1 = data.readLong();
                    IFaceServiceReceiver _arg2 = IFaceServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    FaceAuthenticateOptions _arg3 = data.readTypedObject(FaceAuthenticateOptions.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.authenticate(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 6: {
                    IBinder _arg0 = data.readStrongBinder();
                    IFaceServiceReceiver _arg1 = IFaceServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    FaceAuthenticateOptions _arg2 = data.readTypedObject(FaceAuthenticateOptions.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.detectFace(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    IBinder _arg1 = data.readStrongBinder();
                    long _arg2 = data.readLong();
                    IBiometricSensorReceiver _arg3 = IBiometricSensorReceiver.Stub.asInterface(data.readStrongBinder());
                    FaceAuthenticateOptions _arg4 = data.readTypedObject(FaceAuthenticateOptions.CREATOR);
                    long _arg5 = data.readLong();
                    int _arg6 = data.readInt();
                    boolean _arg7 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.prepareForAuthentication(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startPreparedClient(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.cancelAuthentication(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.cancelFaceDetect(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    this.cancelAuthenticationFromService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    byte[] _arg2 = data.createByteArray();
                    IFaceServiceReceiver _arg3 = IFaceServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    int[] _arg5 = data.createIntArray();
                    Surface _arg6 = data.readTypedObject(Surface.CREATOR);
                    boolean _arg7 = data.readBoolean();
                    FaceEnrollOptions _arg8 = data.readTypedObject(FaceEnrollOptions.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.enroll(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    byte[] _arg2 = data.createByteArray();
                    IFaceServiceReceiver _arg3 = IFaceServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    int[] _arg5 = data.createIntArray();
                    data.enforceNoDataAvail();
                    long _result = this.enrollRemotely(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 14: {
                    IBinder _arg0 = data.readStrongBinder();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.cancelEnrollment(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IFaceServiceReceiver _arg3 = IFaceServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.remove(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    IFaceServiceReceiver _arg2 = IFaceServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeAll(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    List<Face> _result = this.getEnrolledFaces(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isHardwareDetected(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IFaceServiceReceiver _arg3 = IFaceServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.generateChallenge(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    long _arg4 = data.readLong();
                    data.enforceNoDataAvail();
                    this.revokeChallenge(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasEnrolledFaces(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getLockoutModeForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IInvalidationCallback _arg2 = IInvalidationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.invalidateAuthenticatorId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getAuthenticatorId(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 25: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.resetLockout(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    IBiometricServiceLockoutResetCallback _arg0 = IBiometricServiceLockoutResetCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.addLockoutResetCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    byte[] _arg4 = data.createByteArray();
                    IFaceServiceReceiver _arg5 = IFaceServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg6 = data.readString();
                    data.enforceNoDataAvail();
                    this.setFeature(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IFaceServiceReceiver _arg3 = IFaceServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.getFeature(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    FaceSensorConfigurations _arg0 = data.readTypedObject(FaceSensorConfigurations.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerAuthenticators(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    IFaceAuthenticatorsRegisteredCallback _arg0 = IFaceAuthenticatorsRegisteredCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addAuthenticatorsRegisteredCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    AuthenticationStateListener _arg0 = AuthenticationStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerAuthenticationStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    AuthenticationStateListener _arg0 = AuthenticationStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAuthenticationStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    IBiometricStateListener _arg0 = IBiometricStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerBiometricStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    this.scheduleWatchdog();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void createTestSession_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void dumpSensorServiceStateProto_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSensorPropertiesInternal_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSensorProperties_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void authenticate_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void detectFace_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void prepareForAuthentication_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void startPreparedClient_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void cancelAuthentication_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void cancelFaceDetect_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void cancelAuthenticationFromService_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void enroll_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void enrollRemotely_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void cancelEnrollment_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void remove_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeAll_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getEnrolledFaces_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isHardwareDetected_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void generateChallenge_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void revokeChallenge_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void hasEnrolledFaces_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getLockoutModeForUser_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void invalidateAuthenticatorId_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAuthenticatorId_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void resetLockout_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addLockoutResetCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setFeature_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getFeature_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerAuthenticators_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerAuthenticationStateListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterAuthenticationStateListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void scheduleWatchdog_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 33;
        }

        private static class Proxy
        implements IFaceService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IFaceService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ITestSession createTestSession(int sensorId, ITestSessionCallback callback, String opPackageName) throws RemoteException {
                ITestSession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeStrongInterface(callback);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = ITestSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] dumpSensorServiceStateProto(int sensorId, boolean clearSchedulerBuffer) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeBoolean(clearSchedulerBuffer);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<FaceSensorPropertiesInternal> getSensorPropertiesInternal(String opPackageName) throws RemoteException {
                ArrayList<FaceSensorPropertiesInternal> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(FaceSensorPropertiesInternal.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FaceSensorPropertiesInternal getSensorProperties(int sensorId, String opPackageName) throws RemoteException {
                FaceSensorPropertiesInternal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(FaceSensorPropertiesInternal.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long authenticate(IBinder token, long operationId, IFaceServiceReceiver receiver, FaceAuthenticateOptions options) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeLong(operationId);
                    _data.writeStrongInterface(receiver);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long detectFace(IBinder token, IFaceServiceReceiver receiver, FaceAuthenticateOptions options) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeStrongInterface(receiver);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareForAuthentication(boolean requireConfirmation, IBinder token, long operationId, IBiometricSensorReceiver sensorReceiver, FaceAuthenticateOptions options, long requestId, int cookie, boolean allowBackgroundAuthentication) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeBoolean(requireConfirmation);
                    _data.writeStrongBinder(token);
                    _data.writeLong(operationId);
                    _data.writeStrongInterface(sensorReceiver);
                    _data.writeTypedObject(options, 0);
                    _data.writeLong(requestId);
                    _data.writeInt(cookie);
                    _data.writeBoolean(allowBackgroundAuthentication);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPreparedClient(int sensorId, int cookie) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(cookie);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAuthentication(IBinder token, String opPackageName, long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(opPackageName);
                    _data.writeLong(requestId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelFaceDetect(IBinder token, String opPackageName, long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(opPackageName);
                    _data.writeLong(requestId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAuthenticationFromService(int sensorId, IBinder token, String opPackageName, long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeStrongBinder(token);
                    _data.writeString(opPackageName);
                    _data.writeLong(requestId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long enroll(int userId, IBinder token, byte[] hardwareAuthToken, IFaceServiceReceiver receiver, String opPackageName, int[] disabledFeatures, Surface previewSurface, boolean debugConsent, FaceEnrollOptions options) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeStrongBinder(token);
                    _data.writeByteArray(hardwareAuthToken);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    _data.writeIntArray(disabledFeatures);
                    _data.writeTypedObject(previewSurface, 0);
                    _data.writeBoolean(debugConsent);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long enrollRemotely(int userId, IBinder token, byte[] hardwareAuthToken, IFaceServiceReceiver receiver, String opPackageName, int[] disabledFeatures) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeStrongBinder(token);
                    _data.writeByteArray(hardwareAuthToken);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    _data.writeIntArray(disabledFeatures);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelEnrollment(IBinder token, long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeLong(requestId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove(IBinder token, int faceId, int userId, IFaceServiceReceiver receiver, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(faceId);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAll(IBinder token, int userId, IFaceServiceReceiver receiver, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Face> getEnrolledFaces(int sensorId, int userId, String opPackageName) throws RemoteException {
                ArrayList<Face> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(Face.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHardwareDetected(int sensorId, String opPackageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generateChallenge(IBinder token, int sensorId, int userId, IFaceServiceReceiver receiver, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeChallenge(IBinder token, int sensorId, int userId, String opPackageName, long challenge) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    _data.writeLong(challenge);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasEnrolledFaces(int sensorId, int userId, String opPackageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLockoutModeForUser(int sensorId, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidateAuthenticatorId(int sensorId, int userId, IInvalidationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAuthenticatorId(int sensorId, int callingUserId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(callingUserId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetLockout(IBinder token, int sensorId, int userId, byte[] hardwareAuthToken, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeByteArray(hardwareAuthToken);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addLockoutResetCallback(IBiometricServiceLockoutResetCallback callback, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFeature(IBinder token, int userId, int feature, boolean enabled, byte[] hardwareAuthToken, IFaceServiceReceiver receiver, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(userId);
                    _data.writeInt(feature);
                    _data.writeBoolean(enabled);
                    _data.writeByteArray(hardwareAuthToken);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getFeature(IBinder token, int userId, int feature, IFaceServiceReceiver receiver, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(userId);
                    _data.writeInt(feature);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAuthenticators(FaceSensorConfigurations faceSensorConfigurations) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeTypedObject(faceSensorConfigurations, 0);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAuthenticatorsRegisteredCallback(IFaceAuthenticatorsRegisteredCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerBiometricStateListener(IBiometricStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void scheduleWatchdog() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceService.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(34, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IFaceService {
        @Override
        public ITestSession createTestSession(int sensorId, ITestSessionCallback callback, String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public byte[] dumpSensorServiceStateProto(int sensorId, boolean clearSchedulerBuffer) throws RemoteException {
            return null;
        }

        @Override
        public List<FaceSensorPropertiesInternal> getSensorPropertiesInternal(String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public FaceSensorPropertiesInternal getSensorProperties(int sensorId, String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public long authenticate(IBinder token, long operationId, IFaceServiceReceiver receiver, FaceAuthenticateOptions options) throws RemoteException {
            return 0L;
        }

        @Override
        public long detectFace(IBinder token, IFaceServiceReceiver receiver, FaceAuthenticateOptions options) throws RemoteException {
            return 0L;
        }

        @Override
        public void prepareForAuthentication(boolean requireConfirmation, IBinder token, long operationId, IBiometricSensorReceiver sensorReceiver, FaceAuthenticateOptions options, long requestId, int cookie, boolean allowBackgroundAuthentication) throws RemoteException {
        }

        @Override
        public void startPreparedClient(int sensorId, int cookie) throws RemoteException {
        }

        @Override
        public void cancelAuthentication(IBinder token, String opPackageName, long requestId) throws RemoteException {
        }

        @Override
        public void cancelFaceDetect(IBinder token, String opPackageName, long requestId) throws RemoteException {
        }

        @Override
        public void cancelAuthenticationFromService(int sensorId, IBinder token, String opPackageName, long requestId) throws RemoteException {
        }

        @Override
        public long enroll(int userId, IBinder token, byte[] hardwareAuthToken, IFaceServiceReceiver receiver, String opPackageName, int[] disabledFeatures, Surface previewSurface, boolean debugConsent, FaceEnrollOptions options) throws RemoteException {
            return 0L;
        }

        @Override
        public long enrollRemotely(int userId, IBinder token, byte[] hardwareAuthToken, IFaceServiceReceiver receiver, String opPackageName, int[] disabledFeatures) throws RemoteException {
            return 0L;
        }

        @Override
        public void cancelEnrollment(IBinder token, long requestId) throws RemoteException {
        }

        @Override
        public void remove(IBinder token, int faceId, int userId, IFaceServiceReceiver receiver, String opPackageName) throws RemoteException {
        }

        @Override
        public void removeAll(IBinder token, int userId, IFaceServiceReceiver receiver, String opPackageName) throws RemoteException {
        }

        @Override
        public List<Face> getEnrolledFaces(int sensorId, int userId, String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public boolean isHardwareDetected(int sensorId, String opPackageName) throws RemoteException {
            return false;
        }

        @Override
        public void generateChallenge(IBinder token, int sensorId, int userId, IFaceServiceReceiver receiver, String opPackageName) throws RemoteException {
        }

        @Override
        public void revokeChallenge(IBinder token, int sensorId, int userId, String opPackageName, long challenge) throws RemoteException {
        }

        @Override
        public boolean hasEnrolledFaces(int sensorId, int userId, String opPackageName) throws RemoteException {
            return false;
        }

        @Override
        public int getLockoutModeForUser(int sensorId, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void invalidateAuthenticatorId(int sensorId, int userId, IInvalidationCallback callback) throws RemoteException {
        }

        @Override
        public long getAuthenticatorId(int sensorId, int callingUserId) throws RemoteException {
            return 0L;
        }

        @Override
        public void resetLockout(IBinder token, int sensorId, int userId, byte[] hardwareAuthToken, String opPackageName) throws RemoteException {
        }

        @Override
        public void addLockoutResetCallback(IBiometricServiceLockoutResetCallback callback, String opPackageName) throws RemoteException {
        }

        @Override
        public void setFeature(IBinder token, int userId, int feature, boolean enabled, byte[] hardwareAuthToken, IFaceServiceReceiver receiver, String opPackageName) throws RemoteException {
        }

        @Override
        public void getFeature(IBinder token, int userId, int feature, IFaceServiceReceiver receiver, String opPackageName) throws RemoteException {
        }

        @Override
        public void registerAuthenticators(FaceSensorConfigurations faceSensorConfigurations) throws RemoteException {
        }

        @Override
        public void addAuthenticatorsRegisteredCallback(IFaceAuthenticatorsRegisteredCallback callback) throws RemoteException {
        }

        @Override
        public void registerAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
        }

        @Override
        public void unregisterAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
        }

        @Override
        public void registerBiometricStateListener(IBiometricStateListener listener) throws RemoteException {
        }

        @Override
        public void scheduleWatchdog() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

