/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.face;

import android.hardware.face.Face;
import android.hardware.face.FaceAuthenticationFrame;
import android.hardware.face.FaceEnrollFrame;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IFaceServiceReceiver
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.face.IFaceServiceReceiver";

    public void onEnrollResult(Face var1, int var2) throws RemoteException;

    public void onAcquired(int var1, int var2) throws RemoteException;

    public void onAuthenticationSucceeded(Face var1, int var2, boolean var3) throws RemoteException;

    public void onFaceDetected(int var1, int var2, boolean var3) throws RemoteException;

    public void onAuthenticationFailed() throws RemoteException;

    public void onError(int var1, int var2) throws RemoteException;

    public void onRemoved(Face var1, int var2) throws RemoteException;

    public void onFeatureSet(boolean var1, int var2) throws RemoteException;

    public void onFeatureGet(boolean var1, int[] var2, boolean[] var3) throws RemoteException;

    public void onChallengeGenerated(int var1, int var2, long var3) throws RemoteException;

    public void onAuthenticationFrame(FaceAuthenticationFrame var1) throws RemoteException;

    public void onEnrollmentFrame(FaceEnrollFrame var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IFaceServiceReceiver {
        static final int TRANSACTION_onEnrollResult = 1;
        static final int TRANSACTION_onAcquired = 2;
        static final int TRANSACTION_onAuthenticationSucceeded = 3;
        static final int TRANSACTION_onFaceDetected = 4;
        static final int TRANSACTION_onAuthenticationFailed = 5;
        static final int TRANSACTION_onError = 6;
        static final int TRANSACTION_onRemoved = 7;
        static final int TRANSACTION_onFeatureSet = 8;
        static final int TRANSACTION_onFeatureGet = 9;
        static final int TRANSACTION_onChallengeGenerated = 10;
        static final int TRANSACTION_onAuthenticationFrame = 11;
        static final int TRANSACTION_onEnrollmentFrame = 12;

        public Stub() {
            this.attachInterface(this, IFaceServiceReceiver.DESCRIPTOR);
        }

        public static IFaceServiceReceiver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IFaceServiceReceiver.DESCRIPTOR);
            if (iin != null && iin instanceof IFaceServiceReceiver) {
                return (IFaceServiceReceiver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onEnrollResult";
                }
                case 2: {
                    return "onAcquired";
                }
                case 3: {
                    return "onAuthenticationSucceeded";
                }
                case 4: {
                    return "onFaceDetected";
                }
                case 5: {
                    return "onAuthenticationFailed";
                }
                case 6: {
                    return "onError";
                }
                case 7: {
                    return "onRemoved";
                }
                case 8: {
                    return "onFeatureSet";
                }
                case 9: {
                    return "onFeatureGet";
                }
                case 10: {
                    return "onChallengeGenerated";
                }
                case 11: {
                    return "onAuthenticationFrame";
                }
                case 12: {
                    return "onEnrollmentFrame";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IFaceServiceReceiver.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    Face _arg0 = data.readTypedObject(Face.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onEnrollResult(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAcquired(_arg0, _arg1);
                    break;
                }
                case 3: {
                    Face _arg0 = data.readTypedObject(Face.CREATOR);
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onAuthenticationSucceeded(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onFaceDetected(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    this.onAuthenticationFailed();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1);
                    break;
                }
                case 7: {
                    Face _arg0 = data.readTypedObject(Face.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRemoved(_arg0, _arg1);
                    break;
                }
                case 8: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onFeatureSet(_arg0, _arg1);
                    break;
                }
                case 9: {
                    boolean _arg0 = data.readBoolean();
                    int[] _arg1 = data.createIntArray();
                    boolean[] _arg2 = data.createBooleanArray();
                    data.enforceNoDataAvail();
                    this.onFeatureGet(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onChallengeGenerated(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    FaceAuthenticationFrame _arg0 = data.readTypedObject(FaceAuthenticationFrame.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAuthenticationFrame(_arg0);
                    break;
                }
                case 12: {
                    FaceEnrollFrame _arg0 = data.readTypedObject(FaceEnrollFrame.CREATOR);
                    data.enforceNoDataAvail();
                    this.onEnrollmentFrame(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IFaceServiceReceiver {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IFaceServiceReceiver.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollResult(Face face, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeTypedObject(face, 0);
                    _data.writeInt(remaining);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAcquired(int acquiredInfo, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeInt(acquiredInfo);
                    _data.writeInt(vendorCode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSucceeded(Face face, int userId, boolean isStrongBiometric) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeTypedObject(face, 0);
                    _data.writeInt(userId);
                    _data.writeBoolean(isStrongBiometric);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFaceDetected(int sensorId, int userId, boolean isStrongBiometric) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeBoolean(isStrongBiometric);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onAuthenticationFailed() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeInt(error);
                    _data.writeInt(vendorCode);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoved(Face face, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeTypedObject(face, 0);
                    _data.writeInt(remaining);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFeatureSet(boolean success, int feature) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeBoolean(success);
                    _data.writeInt(feature);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFeatureGet(boolean success, int[] features, boolean[] featureState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeBoolean(success);
                    _data.writeIntArray(features);
                    _data.writeBooleanArray(featureState);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChallengeGenerated(int sensorId, int userId, long challenge) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeLong(challenge);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationFrame(FaceAuthenticationFrame frame) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeTypedObject(frame, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollmentFrame(FaceEnrollFrame frame) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IFaceServiceReceiver.DESCRIPTOR);
                    _data.writeTypedObject(frame, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IFaceServiceReceiver {
        @Override
        public void onEnrollResult(Face face, int remaining) throws RemoteException {
        }

        @Override
        public void onAcquired(int acquiredInfo, int vendorCode) throws RemoteException {
        }

        @Override
        public void onAuthenticationSucceeded(Face face, int userId, boolean isStrongBiometric) throws RemoteException {
        }

        @Override
        public void onFaceDetected(int sensorId, int userId, boolean isStrongBiometric) throws RemoteException {
        }

        @Override
        public void onAuthenticationFailed() throws RemoteException {
        }

        @Override
        public void onError(int error, int vendorCode) throws RemoteException {
        }

        @Override
        public void onRemoved(Face face, int remaining) throws RemoteException {
        }

        @Override
        public void onFeatureSet(boolean success, int feature) throws RemoteException {
        }

        @Override
        public void onFeatureGet(boolean success, int[] features, boolean[] featureState) throws RemoteException {
        }

        @Override
        public void onChallengeGenerated(int sensorId, int userId, long challenge) throws RemoteException {
        }

        @Override
        public void onAuthenticationFrame(FaceAuthenticationFrame frame) throws RemoteException {
        }

        @Override
        public void onEnrollmentFrame(FaceEnrollFrame frame) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

