/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.content.Context;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.FingerprintManager;
import android.util.Slog;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;

public class FingerprintCallback {
    private static final String TAG = "FingerprintCallback";
    public static final int REMOVE_SINGLE = 1;
    public static final int REMOVE_ALL = 2;
    @Nullable
    private FingerprintManager.AuthenticationCallback mAuthenticationCallback;
    @Nullable
    private FingerprintManager.EnrollmentCallback mEnrollmentCallback;
    @Nullable
    private FingerprintManager.RemovalCallback mRemovalCallback;
    @Nullable
    private FingerprintManager.GenerateChallengeCallback mGenerateChallengeCallback;
    @Nullable
    private FingerprintManager.FingerprintDetectionCallback mFingerprintDetectionCallback;
    @Nullable
    private FingerprintManager.CryptoObject mCryptoObject;
    @Nullable
    @RemoveRequest
    private int mRemoveRequest;
    @Nullable
    private Fingerprint mRemoveFingerprint;

    FingerprintCallback(@NonNull FingerprintManager.AuthenticationCallback authenticationCallback, @Nullable FingerprintManager.CryptoObject cryptoObject) {
        this.mAuthenticationCallback = authenticationCallback;
        this.mCryptoObject = cryptoObject;
    }

    FingerprintCallback(@NonNull FingerprintManager.FingerprintDetectionCallback fingerprintDetectionCallback) {
        this.mFingerprintDetectionCallback = fingerprintDetectionCallback;
    }

    FingerprintCallback(@NonNull FingerprintManager.EnrollmentCallback enrollmentCallback) {
        this.mEnrollmentCallback = enrollmentCallback;
    }

    FingerprintCallback(@NonNull FingerprintManager.GenerateChallengeCallback generateChallengeCallback) {
        this.mGenerateChallengeCallback = generateChallengeCallback;
    }

    FingerprintCallback(@NonNull FingerprintManager.RemovalCallback removalCallback, @RemoveRequest int removeRequest, @Nullable Fingerprint removeFingerprint) {
        this.mRemovalCallback = removalCallback;
        this.mRemoveRequest = removeRequest;
        this.mRemoveFingerprint = removeFingerprint;
    }

    public void sendEnrollResult(int remaining) {
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentProgress(remaining);
        }
    }

    public void sendRemovedResult(@Nullable Fingerprint fingerprint, int remaining) {
        if (this.mRemovalCallback == null) {
            return;
        }
        if (this.mRemoveRequest == 1) {
            if (fingerprint == null) {
                Slog.e(TAG, "Received MSG_REMOVED, but fingerprint is null");
                return;
            }
            if (this.mRemoveFingerprint == null) {
                Slog.e(TAG, "Missing fingerprint");
                return;
            }
            int fingerId = fingerprint.getBiometricId();
            int reqFingerId = this.mRemoveFingerprint.getBiometricId();
            if (reqFingerId != 0 && fingerId != 0 && fingerId != reqFingerId) {
                Slog.w(TAG, "Finger id didn't match: " + fingerId + " != " + reqFingerId);
                return;
            }
        }
        this.mRemovalCallback.onRemovalSucceeded(fingerprint, remaining);
    }

    public void sendAuthenticatedSucceeded(@NonNull Fingerprint fingerprint, int userId, boolean isStrongBiometric) {
        if (this.mAuthenticationCallback == null) {
            Slog.e(TAG, "Authentication succeeded but callback is null.");
            return;
        }
        FingerprintManager.AuthenticationResult result = new FingerprintManager.AuthenticationResult(this.mCryptoObject, fingerprint, userId, isStrongBiometric);
        this.mAuthenticationCallback.onAuthenticationSucceeded(result);
    }

    public void sendAuthenticatedFailed() {
        if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationFailed();
        }
    }

    public void sendAcquiredResult(@NonNull Context context, int acquireInfo, int vendorCode) {
        int clientInfo;
        String msg;
        if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationAcquired(acquireInfo);
        }
        if (this.mEnrollmentCallback != null && acquireInfo != 7) {
            this.mEnrollmentCallback.onAcquired(acquireInfo == 0);
        }
        if ((msg = FingerprintManager.getAcquiredString(context, acquireInfo, vendorCode)) == null) {
            return;
        }
        int n = clientInfo = acquireInfo == 6 ? vendorCode + 1000 : acquireInfo;
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentHelp(clientInfo, msg);
        } else if (this.mAuthenticationCallback != null && acquireInfo != 7) {
            this.mAuthenticationCallback.onAuthenticationHelp(clientInfo, msg);
        }
    }

    public void sendErrorResult(@NonNull Context context, int errMsgId, int vendorCode) {
        int clientErrMsgId;
        int n = clientErrMsgId = errMsgId == 8 ? vendorCode + 1000 : errMsgId;
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentError(clientErrMsgId, FingerprintManager.getErrorString(context, errMsgId, vendorCode));
        } else if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationError(clientErrMsgId, FingerprintManager.getErrorString(context, errMsgId, vendorCode));
        } else if (this.mRemovalCallback != null) {
            this.mRemovalCallback.onRemovalError(this.mRemoveFingerprint, clientErrMsgId, FingerprintManager.getErrorString(context, errMsgId, vendorCode));
        } else if (this.mFingerprintDetectionCallback != null) {
            this.mFingerprintDetectionCallback.onDetectionError(errMsgId);
            this.mFingerprintDetectionCallback = null;
        }
    }

    public void sendChallengeGenerated(long challenge, int sensorId, int userId) {
        if (this.mGenerateChallengeCallback == null) {
            Slog.e(TAG, "sendChallengeGenerated, callback null");
            return;
        }
        this.mGenerateChallengeCallback.onChallengeGenerated(sensorId, userId, challenge);
    }

    public void sendFingerprintDetected(int sensorId, int userId, boolean isStrongBiometric) {
        if (this.mFingerprintDetectionCallback == null) {
            Slog.e(TAG, "sendFingerprintDetected, callback null");
            return;
        }
        this.mFingerprintDetectionCallback.onFingerprintDetected(sensorId, userId, isStrongBiometric);
    }

    public void sendUdfpsPointerDown(int sensorId) {
        if (this.mAuthenticationCallback == null) {
            Slog.e(TAG, "sendUdfpsPointerDown, callback null");
        } else {
            this.mAuthenticationCallback.onUdfpsPointerDown(sensorId);
        }
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onUdfpsPointerDown(sensorId);
        }
    }

    public void sendUdfpsPointerUp(int sensorId) {
        if (this.mAuthenticationCallback == null) {
            Slog.e(TAG, "sendUdfpsPointerUp, callback null");
        } else {
            this.mAuthenticationCallback.onUdfpsPointerUp(sensorId);
        }
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onUdfpsPointerUp(sensorId);
        }
    }

    public void sendUdfpsOverlayShown() {
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onUdfpsOverlayShown();
        }
    }

    public static @interface RemoveRequest {
    }
}

