/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.app.ActivityManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.BiometricFingerprintConstants;
import android.hardware.biometrics.BiometricStateListener;
import android.hardware.biometrics.BiometricTestSession;
import android.hardware.biometrics.IBiometricServiceLockoutResetCallback;
import android.hardware.biometrics.SensorProperties;
import android.hardware.biometrics.fingerprint.PointerContext;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.FingerprintAuthenticateOptions;
import android.hardware.fingerprint.FingerprintCallback;
import android.hardware.fingerprint.FingerprintEnrollOptions;
import android.hardware.fingerprint.FingerprintSensorProperties;
import android.hardware.fingerprint.FingerprintSensorPropertiesInternal;
import android.hardware.fingerprint.IFingerprintAuthenticatorsRegisteredCallback;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.hardware.fingerprint.IUdfpsOverlayController;
import android.os.Binder;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.security.identity.IdentityCredential;
import android.security.identity.PresentationSession;
import android.util.Slog;
import com.android.internal.util.FrameworkStatsLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.Signature;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;

@Deprecated
public class FingerprintManager
implements BiometricAuthenticator,
BiometricFingerprintConstants {
    private static final String TAG = "FingerprintManager";
    public static final int ENROLL_FIND_SENSOR = 1;
    public static final int ENROLL_ENROLL = 2;
    public static final int UDFPS_UI_OVERLAY_SHOWN = 1;
    public static final int UDFPS_UI_READY = 2;
    public static final int SENSOR_ID_ANY = -1;
    private final IFingerprintService mService;
    private final Context mContext;
    private final IBinder mToken = new Binder();
    private Handler mHandler;
    @Nullable
    private float[] mEnrollStageThresholds;
    private List<FingerprintSensorPropertiesInternal> mProps = new ArrayList<FingerprintSensorPropertiesInternal>();
    private HandlerExecutor mExecutor;

    @NonNull
    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public List<SensorProperties> getSensorProperties() {
        ArrayList<SensorProperties> properties = new ArrayList<SensorProperties>();
        List<FingerprintSensorPropertiesInternal> internalProperties = this.getSensorPropertiesInternal();
        for (FingerprintSensorPropertiesInternal internalProp : internalProperties) {
            properties.add(FingerprintSensorProperties.from(internalProp));
        }
        return properties;
    }

    @NonNull
    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public BiometricTestSession createTestSession(int sensorId) {
        try {
            return new BiometricTestSession(this.mContext, this.getSensorProperties(), sensorId, (context, sensorId1, callback) -> this.mService.createTestSession(sensorId1, callback, context.getOpPackageName()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void useHandler(Handler handler) {
        if (handler != null) {
            this.mHandler = handler;
            this.mExecutor = new HandlerExecutor(this.mHandler);
        } else if (this.mHandler != this.mContext.getMainThreadHandler()) {
            this.mHandler = this.mContext.getMainThreadHandler();
            this.mExecutor = new HandlerExecutor(this.mHandler);
        }
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.USE_BIOMETRIC", "android.permission.USE_FINGERPRINT"})
    public void authenticate(@Nullable CryptoObject crypto, @Nullable CancellationSignal cancel, int flags, @NonNull AuthenticationCallback callback, @Nullable Handler handler) {
        this.authenticate(crypto, cancel, callback, handler, -1, this.mContext.getUserId(), flags);
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.USE_BIOMETRIC", "android.permission.USE_FINGERPRINT"})
    public void authenticate(@Nullable CryptoObject crypto, @Nullable CancellationSignal cancel, @NonNull AuthenticationCallback callback, Handler handler, int userId) {
        this.authenticate(crypto, cancel, callback, handler, -1, userId, 0);
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.USE_BIOMETRIC", "android.permission.USE_FINGERPRINT"})
    public void authenticate(@Nullable CryptoObject crypto, @Nullable CancellationSignal cancel, @NonNull AuthenticationCallback callback, Handler handler, int sensorId, int userId, int flags) {
        this.authenticate(crypto, cancel, callback, handler, new FingerprintAuthenticateOptions.Builder().setSensorId(sensorId).setUserId(userId).setIgnoreEnrollmentState(flags != 0).build());
    }

    @RequiresPermission(anyOf={"android.permission.USE_BIOMETRIC", "android.permission.USE_FINGERPRINT"})
    public void authenticate(@Nullable CryptoObject crypto, @Nullable CancellationSignal cancel, @NonNull AuthenticationCallback callback, @NonNull Handler handler, @NonNull FingerprintAuthenticateOptions options) {
        FrameworkStatsLog.write(356, 1, this.mContext.getApplicationInfo().uid, this.mContext.getApplicationInfo().targetSdkVersion);
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an authentication callback");
        }
        if (cancel != null && cancel.isCanceled()) {
            Slog.w(TAG, "authentication already canceled");
            return;
        }
        options.setOpPackageName(this.mContext.getOpPackageName());
        options.setAttributionTag(this.mContext.getAttributionTag());
        if (this.mService != null) {
            try {
                FingerprintCallback fingerprintCallback = new FingerprintCallback(callback, crypto);
                this.useHandler(handler);
                long operationId = crypto != null ? crypto.getOpId() : 0L;
                long authId = this.mService.authenticate(this.mToken, operationId, new FingerprintServiceReceiver(fingerprintCallback), options);
                if (cancel != null) {
                    cancel.setOnCancelListener(new OnAuthenticationCancelListener(authId));
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception while authenticating: ", e);
                callback.onAuthenticationError(1, FingerprintManager.getErrorString(this.mContext, 1, 0));
            }
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void detectFingerprint(@NonNull CancellationSignal cancel, @NonNull FingerprintDetectionCallback callback, @NonNull FingerprintAuthenticateOptions options) {
        if (this.mService == null) {
            return;
        }
        if (cancel.isCanceled()) {
            Slog.w(TAG, "Detection already cancelled");
            return;
        }
        options.setOpPackageName(this.mContext.getOpPackageName());
        options.setAttributionTag(this.mContext.getAttributionTag());
        FingerprintCallback fingerprintCallback = new FingerprintCallback(callback);
        try {
            long authId = this.mService.detectFingerprint(this.mToken, new FingerprintServiceReceiver(fingerprintCallback), options);
            cancel.setOnCancelListener(new OnFingerprintDetectionCancelListener(authId));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Remote exception when requesting finger detect", e);
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void setIgnoreDisplayTouches(long requestId, int sensorId, boolean ignoreTouch) {
        if (this.mService == null) {
            Slog.w(TAG, "setIgnoreDisplayTouches: no fingerprint service");
            return;
        }
        try {
            this.mService.setIgnoreDisplayTouches(requestId, sensorId, ignoreTouch);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void enroll(byte[] hardwareAuthToken, CancellationSignal cancel, int userId, EnrollmentCallback callback, int enrollReason, FingerprintEnrollOptions options) {
        if (userId == -2) {
            userId = this.getCurrentUserId();
        }
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an enrollment callback");
        }
        if (cancel != null && cancel.isCanceled()) {
            Slog.w(TAG, "enrollment already canceled");
            return;
        }
        if (hardwareAuthToken == null) {
            callback.onEnrollmentError(2, FingerprintManager.getErrorString(this.mContext, 2, 0));
            return;
        }
        if (this.mService != null) {
            try {
                FingerprintCallback fingerprintCallback = new FingerprintCallback(callback);
                long enrollId = this.mService.enroll(this.mToken, hardwareAuthToken, userId, new FingerprintServiceReceiver(fingerprintCallback), this.mContext.getOpPackageName(), enrollReason, options);
                if (cancel != null) {
                    cancel.setOnCancelListener(new OnEnrollCancelListener(enrollId));
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception in enroll: ", e);
                callback.onEnrollmentError(1, FingerprintManager.getErrorString(this.mContext, 1, 0));
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void generateChallenge(int sensorId, int userId, GenerateChallengeCallback callback) {
        if (this.mService != null) {
            try {
                FingerprintCallback fingerprintCallback = new FingerprintCallback(callback);
                this.mService.generateChallenge(this.mToken, sensorId, userId, new FingerprintServiceReceiver(fingerprintCallback), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void generateChallenge(int userId, GenerateChallengeCallback callback) {
        FingerprintSensorPropertiesInternal sensorProps = this.getFirstFingerprintSensor();
        if (sensorProps == null) {
            Slog.e(TAG, "No sensors");
            return;
        }
        this.generateChallenge(sensorProps.sensorId, userId, callback);
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void revokeChallenge(int userId, long challenge) {
        if (this.mService != null) {
            try {
                FingerprintSensorPropertiesInternal sensorProps = this.getFirstFingerprintSensor();
                if (sensorProps == null) {
                    Slog.e(TAG, "No sensors");
                    return;
                }
                this.mService.revokeChallenge(this.mToken, sensorProps.sensorId, userId, this.mContext.getOpPackageName(), challenge);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.RESET_FINGERPRINT_LOCKOUT")
    public void resetLockout(int sensorId, int userId, @Nullable byte[] hardwareAuthToken) {
        if (this.mService != null) {
            try {
                this.mService.resetLockout(this.mToken, sensorId, userId, hardwareAuthToken, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void remove(Fingerprint fp, int userId, RemovalCallback callback) {
        if (this.mService != null) {
            try {
                FingerprintCallback fingerprintCallback = new FingerprintCallback(callback, 1, fp);
                this.mService.remove(this.mToken, fp.getBiometricId(), userId, new FingerprintServiceReceiver(fingerprintCallback), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void removeAll(int userId, @NonNull RemovalCallback callback) {
        if (this.mService != null) {
            try {
                FingerprintCallback fingerprintCallback = new FingerprintCallback(callback, 2, null);
                this.mService.removeAll(this.mToken, userId, new FingerprintServiceReceiver(fingerprintCallback), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void rename(int fpId, int userId, String newName) {
        if (this.mService != null) {
            try {
                this.mService.rename(fpId, userId, newName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "rename(): Service not connected!");
        }
    }

    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public List<Fingerprint> getEnrolledFingerprints(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getEnrolledFingerprints(userId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    @UnsupportedAppUsage
    public List<Fingerprint> getEnrolledFingerprints() {
        return this.getEnrolledFingerprints(this.mContext.getUserId());
    }

    public boolean hasEnrolledTemplates() {
        return this.hasEnrolledFingerprints();
    }

    public boolean hasEnrolledTemplates(int userId) {
        return this.hasEnrolledFingerprints(userId);
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void setUdfpsOverlayController(@NonNull IUdfpsOverlayController controller) {
        if (this.mService == null) {
            Slog.w(TAG, "setUdfpsOverlayController: no fingerprint service");
            return;
        }
        try {
            this.mService.setUdfpsOverlayController(controller);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void registerBiometricStateListener(@NonNull BiometricStateListener listener) {
        try {
            this.mService.registerBiometricStateListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onPointerDown(long requestId, int sensorId, int x, int y, float minor, float major) {
        if (this.mService == null) {
            Slog.w(TAG, "onPointerDown: no fingerprint service");
            return;
        }
        PointerContext pc = new PointerContext();
        pc.x = x;
        pc.y = y;
        pc.minor = minor;
        pc.major = major;
        try {
            this.mService.onPointerDown(requestId, sensorId, pc);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onPointerUp(long requestId, int sensorId) {
        if (this.mService == null) {
            Slog.w(TAG, "onPointerUp: no fingerprint service");
            return;
        }
        PointerContext pc = new PointerContext();
        try {
            this.mService.onPointerUp(requestId, sensorId, pc);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onPointerDown(long requestId, int sensorId, int pointerId, float x, float y, float minor, float major, float orientation, long time, long gestureStart, boolean isAod) {
        if (this.mService == null) {
            Slog.w(TAG, "onPointerDown: no fingerprint service");
            return;
        }
        PointerContext pc = new PointerContext();
        pc.pointerId = pointerId;
        pc.x = x;
        pc.y = y;
        pc.minor = minor;
        pc.major = major;
        pc.orientation = orientation;
        pc.time = time;
        pc.gestureStart = gestureStart;
        pc.isAod = isAod;
        try {
            this.mService.onPointerDown(requestId, sensorId, pc);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onPointerUp(long requestId, int sensorId, int pointerId, float x, float y, float minor, float major, float orientation, long time, long gestureStart, boolean isAod) {
        if (this.mService == null) {
            Slog.w(TAG, "onPointerUp: no fingerprint service");
            return;
        }
        PointerContext pc = new PointerContext();
        pc.pointerId = pointerId;
        pc.x = x;
        pc.y = y;
        pc.minor = minor;
        pc.major = major;
        pc.orientation = orientation;
        pc.time = time;
        pc.gestureStart = gestureStart;
        pc.isAod = isAod;
        try {
            this.mService.onPointerUp(requestId, sensorId, pc);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onUdfpsUiEvent(int event, long requestId, int sensorId) {
        if (this.mService == null) {
            Slog.w(TAG, "onUdfpsUiEvent: no fingerprint service");
            return;
        }
        try {
            this.mService.onUdfpsUiEvent(event, requestId, sensorId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onPowerPressed() {
        Slog.i(TAG, "onPowerPressed");
        this.mExecutor.execute(() -> this.sendPowerPressed());
    }

    @Deprecated
    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    public boolean hasEnrolledFingerprints() {
        FrameworkStatsLog.write(356, 2, this.mContext.getApplicationInfo().uid, this.mContext.getApplicationInfo().targetSdkVersion);
        return this.hasEnrolledFingerprints(UserHandle.myUserId());
    }

    @RequiresPermission(allOf={"android.permission.USE_FINGERPRINT", "android.permission.INTERACT_ACROSS_USERS"})
    public boolean hasEnrolledFingerprints(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledFingerprintsDeprecated(userId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    public boolean isHardwareDetected() {
        FrameworkStatsLog.write(356, 3, this.mContext.getApplicationInfo().uid, this.mContext.getApplicationInfo().targetSdkVersion);
        if (this.mService != null) {
            try {
                return this.mService.isHardwareDetectedDeprecated(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Slog.w(TAG, "isFingerprintHardwareDetected(): Service not connected!");
        return false;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    @NonNull
    public List<FingerprintSensorPropertiesInternal> getSensorPropertiesInternal() {
        try {
            if (!this.mProps.isEmpty() || this.mService == null) {
                return this.mProps;
            }
            return this.mService.getSensorPropertiesInternal(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isPowerbuttonFps() {
        FingerprintSensorPropertiesInternal sensorProps = this.getFirstFingerprintSensor();
        return sensorProps == null ? false : sensorProps.sensorType == 4;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void addAuthenticatorsRegisteredCallback(IFingerprintAuthenticatorsRegisteredCallback callback) {
        if (this.mService != null) {
            try {
                this.mService.addAuthenticatorsRegisteredCallback(callback);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "addProvidersAvailableCallback(): Service not connected!");
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public int getLockoutModeForUser(int sensorId, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getLockoutModeForUser(sensorId, userId);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void scheduleWatchdog() {
        try {
            this.mService.scheduleWatchdog();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addLockoutResetCallback(final LockoutResetCallback callback) {
        if (this.mService != null) {
            try {
                final PowerManager powerManager = this.mContext.getSystemService(PowerManager.class);
                this.mService.addLockoutResetCallback(new IBiometricServiceLockoutResetCallback.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLockoutReset(int sensorId, IRemoteCallback serverCallback) throws RemoteException {
                        try {
                            PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, "lockoutResetCallback");
                            wakeLock.acquire();
                            FingerprintManager.this.mHandler.post(() -> {
                                try {
                                    callback.onLockoutReset(sensorId);
                                }
                                finally {
                                    wakeLock.release();
                                }
                            });
                        }
                        finally {
                            serverCallback.sendResult(null);
                        }
                    }
                }, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "addLockoutResetCallback(): Service not connected!");
        }
    }

    private void sendPowerPressed() {
        try {
            this.mService.onPowerPressed();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error sending power press", e);
        }
    }

    public FingerprintManager(Context context, IFingerprintService service) {
        this.mContext = context;
        this.mService = service;
        if (this.mService == null) {
            Slog.v(TAG, "FingerprintService was null");
        }
        if (context.checkCallingOrSelfPermission("android.permission.USE_BIOMETRIC_INTERNAL") == 0) {
            this.addAuthenticatorsRegisteredCallback(new IFingerprintAuthenticatorsRegisteredCallback.Stub(){

                @Override
                public void onAllAuthenticatorsRegistered(@NonNull List<FingerprintSensorPropertiesInternal> sensors) {
                    FingerprintManager.this.mProps = sensors;
                }
            });
        }
        this.mHandler = context.getMainThreadHandler();
        this.mExecutor = new HandlerExecutor(this.mHandler);
    }

    private int getCurrentUserId() {
        try {
            return ActivityManager.getService().getCurrentUser().id;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    private FingerprintSensorPropertiesInternal getFirstFingerprintSensor() {
        List<FingerprintSensorPropertiesInternal> allSensors = this.getSensorPropertiesInternal();
        return allSensors.isEmpty() ? null : allSensors.get(0);
    }

    private void cancelEnrollment(long requestId) {
        if (this.mService != null) {
            try {
                this.mService.cancelEnrollment(this.mToken, requestId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void cancelAuthentication(long requestId) {
        if (this.mService != null) {
            try {
                this.mService.cancelAuthentication(this.mToken, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), requestId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void cancelFingerprintDetect(long requestId) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.cancelFingerprintDetect(this.mToken, this.mContext.getOpPackageName(), requestId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getEnrollStageCount() {
        if (this.mEnrollStageThresholds == null) {
            this.mEnrollStageThresholds = this.createEnrollStageThresholds(this.mContext);
        }
        return this.mEnrollStageThresholds.length + 1;
    }

    public float getEnrollStageThreshold(int index) {
        if (this.mEnrollStageThresholds == null) {
            this.mEnrollStageThresholds = this.createEnrollStageThresholds(this.mContext);
        }
        if (index < 0 || index > this.mEnrollStageThresholds.length) {
            Slog.w(TAG, "Unsupported enroll stage index: " + index);
            return index < 0 ? 0.0f : 1.0f;
        }
        return index == this.mEnrollStageThresholds.length ? 1.0f : this.mEnrollStageThresholds[index];
    }

    @NonNull
    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    private float[] createEnrollStageThresholds(@NonNull Context context) {
        String[] enrollStageThresholdStrings = this.isPowerbuttonFps() ? context.getResources().getStringArray(17236169) : context.getResources().getStringArray(17236192);
        float[] enrollStageThresholds = new float[enrollStageThresholdStrings.length];
        for (int i = 0; i < enrollStageThresholds.length; ++i) {
            enrollStageThresholds[i] = Float.parseFloat(enrollStageThresholdStrings[i]);
        }
        return enrollStageThresholds;
    }

    public static String getErrorString(Context context, int errMsg, int vendorCode) {
        switch (errMsg) {
            case 1: {
                return context.getString(17040446);
            }
            case 2: {
                return context.getString(17040456);
            }
            case 3: {
                return context.getString(17040455);
            }
            case 4: {
                return context.getString(17040451);
            }
            case 5: {
                return context.getString(17040445);
            }
            case 7: {
                return context.getString(0x1040440);
            }
            case 9: {
                return context.getString(0x1040441);
            }
            case 10: {
                return context.getString(17040457);
            }
            case 11: {
                return context.getString(17040450);
            }
            case 12: {
                return context.getString(17040447);
            }
            case 15: {
                return context.getString(17040454);
            }
            case 18: {
                return context.getString(17040444);
            }
            case 19: {
                return context.getString(17040453);
            }
            case 8: {
                String[] msgArray = context.getResources().getStringArray(17236221);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Invalid error message: " + errMsg + ", " + vendorCode);
        return context.getString(17040458);
    }

    public static String getAcquiredString(Context context, int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: 
            case 7: {
                return null;
            }
            case 1: {
                return context.getString(17040429);
            }
            case 2: {
                return context.getString(17040428);
            }
            case 3: {
                return context.getString(17040425);
            }
            case 4: {
                return context.getString(17040433);
            }
            case 5: {
                return context.getString(17040432);
            }
            case 9: {
                return context.getString(17040427);
            }
            case 10: {
                return context.getString(17040431);
            }
            case 11: {
                return context.getString(17040430);
            }
            case 6: {
                String[] msgArray = context.getResources().getStringArray(17236220);
                if (vendorCode >= msgArray.length || msgArray[vendorCode].isEmpty()) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Invalid acquired message: " + acquireInfo + ", " + vendorCode);
        return null;
    }

    @Deprecated
    public static class CryptoObject
    extends android.hardware.biometrics.CryptoObject {
        public CryptoObject(@NonNull Signature signature) {
            super(signature);
        }

        public CryptoObject(@NonNull Cipher cipher) {
            super(cipher);
        }

        public CryptoObject(@NonNull Mac mac) {
            super(mac);
        }

        @Override
        public Signature getSignature() {
            return super.getSignature();
        }

        @Override
        public Cipher getCipher() {
            return super.getCipher();
        }

        @Override
        public Mac getMac() {
            return super.getMac();
        }

        @Override
        @Deprecated
        public IdentityCredential getIdentityCredential() {
            return super.getIdentityCredential();
        }

        @Override
        public PresentationSession getPresentationSession() {
            return super.getPresentationSession();
        }

        @Override
        @FlaggedApi(value="android.hardware.biometrics.add_key_agreement_crypto_object")
        public KeyAgreement getKeyAgreement() {
            return super.getKeyAgreement();
        }
    }

    @Deprecated
    public static abstract class AuthenticationCallback
    extends BiometricAuthenticator.AuthenticationCallback {
        @Override
        public void onAuthenticationError(int errorCode, CharSequence errString) {
        }

        @Override
        public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
        }

        public void onAuthenticationSucceeded(AuthenticationResult result) {
        }

        @Override
        public void onAuthenticationFailed() {
        }

        @Override
        public void onAuthenticationAcquired(int acquireInfo) {
        }

        public void onUdfpsPointerDown(int sensorId) {
        }

        public void onUdfpsPointerUp(int sensorId) {
        }
    }

    class FingerprintServiceReceiver
    extends IFingerprintServiceReceiver.Stub {
        private final FingerprintCallback mFingerprintCallback;

        FingerprintServiceReceiver(FingerprintCallback fingerprintCallback) {
            this.mFingerprintCallback = fingerprintCallback;
        }

        @Override
        public void onEnrollResult(Fingerprint fp, int remaining) {
            FingerprintManager.this.mExecutor.execute(() -> this.mFingerprintCallback.sendEnrollResult(remaining));
        }

        @Override
        public void onAcquired(int acquireInfo, int vendorCode) {
            FingerprintManager.this.mExecutor.execute(() -> this.mFingerprintCallback.sendAcquiredResult(FingerprintManager.this.mContext, acquireInfo, vendorCode));
        }

        @Override
        public void onAuthenticationSucceeded(Fingerprint fp, int userId, boolean isStrongBiometric) {
            FingerprintManager.this.mExecutor.execute(() -> this.mFingerprintCallback.sendAuthenticatedSucceeded(fp, userId, isStrongBiometric));
        }

        @Override
        public void onFingerprintDetected(int sensorId, int userId, boolean isStrongBiometric) {
            FingerprintManager.this.mExecutor.execute(() -> this.mFingerprintCallback.sendFingerprintDetected(sensorId, userId, isStrongBiometric));
        }

        @Override
        public void onAuthenticationFailed() {
            FingerprintManager.this.mExecutor.execute(this.mFingerprintCallback::sendAuthenticatedFailed);
        }

        @Override
        public void onError(int error, int vendorCode) {
            FingerprintManager.this.mExecutor.execute(() -> this.mFingerprintCallback.sendErrorResult(FingerprintManager.this.mContext, error, vendorCode));
        }

        @Override
        public void onRemoved(Fingerprint fp, int remaining) {
            FingerprintManager.this.mExecutor.execute(() -> this.mFingerprintCallback.sendRemovedResult(fp, remaining));
        }

        @Override
        public void onChallengeGenerated(int sensorId, int userId, long challenge) {
            FingerprintManager.this.mExecutor.execute(() -> this.mFingerprintCallback.sendChallengeGenerated(challenge, sensorId, userId));
        }

        @Override
        public void onUdfpsPointerDown(int sensorId) {
            FingerprintManager.this.mExecutor.execute(() -> this.mFingerprintCallback.sendUdfpsPointerDown(sensorId));
        }

        @Override
        public void onUdfpsPointerUp(int sensorId) {
            FingerprintManager.this.mExecutor.execute(() -> this.mFingerprintCallback.sendUdfpsPointerUp(sensorId));
        }

        @Override
        public void onUdfpsOverlayShown() {
            FingerprintManager.this.mExecutor.execute(this.mFingerprintCallback::sendUdfpsOverlayShown);
        }
    }

    private class OnAuthenticationCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        OnAuthenticationCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FingerprintManager.TAG, "Cancel fingerprint authentication requested for: " + this.mAuthRequestId);
            FingerprintManager.this.cancelAuthentication(this.mAuthRequestId);
        }
    }

    public static interface FingerprintDetectionCallback {
        public void onFingerprintDetected(int var1, int var2, boolean var3);

        default public void onDetectionError(int errorMsgId) {
        }
    }

    private class OnFingerprintDetectionCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        OnFingerprintDetectionCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FingerprintManager.TAG, "Cancel fingerprint detect requested for: " + this.mAuthRequestId);
            FingerprintManager.this.cancelFingerprintDetect(this.mAuthRequestId);
        }
    }

    public static abstract class EnrollmentCallback {
        public void onEnrollmentError(int errMsgId, CharSequence errString) {
        }

        public void onEnrollmentHelp(int helpMsgId, CharSequence helpString) {
        }

        public void onEnrollmentProgress(int remaining) {
        }

        public void onAcquired(boolean isAcquiredGood) {
        }

        public void onUdfpsPointerDown(int sensorId) {
        }

        public void onUdfpsPointerUp(int sensorId) {
        }

        public void onUdfpsOverlayShown() {
        }
    }

    private class OnEnrollCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        private OnEnrollCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FingerprintManager.TAG, "Cancel fingerprint enrollment requested for: " + this.mAuthRequestId);
            FingerprintManager.this.cancelEnrollment(this.mAuthRequestId);
        }
    }

    public static interface GenerateChallengeCallback {
        public void onChallengeGenerated(int var1, int var2, long var3);
    }

    public static abstract class RemovalCallback {
        public void onRemovalError(Fingerprint fp, int errMsgId, CharSequence errString) {
        }

        public void onRemovalSucceeded(@Nullable Fingerprint fp, int remaining) {
        }
    }

    public static abstract class LockoutResetCallback {
        public void onLockoutReset(int sensorId) {
        }
    }

    @Deprecated
    public static class AuthenticationResult {
        private Fingerprint mFingerprint;
        private CryptoObject mCryptoObject;
        private int mUserId;
        private boolean mIsStrongBiometric;

        public AuthenticationResult(CryptoObject crypto, Fingerprint fingerprint, int userId, boolean isStrongBiometric) {
            this.mCryptoObject = crypto;
            this.mFingerprint = fingerprint;
            this.mUserId = userId;
            this.mIsStrongBiometric = isStrongBiometric;
        }

        public CryptoObject getCryptoObject() {
            return this.mCryptoObject;
        }

        @UnsupportedAppUsage
        public Fingerprint getFingerprint() {
            return this.mFingerprint;
        }

        public int getUserId() {
            return this.mUserId;
        }

        public boolean isStrongBiometric() {
            return this.mIsStrongBiometric;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UdfpsUiEvent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnrollReason {
    }
}

