/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.hardware.input.VirtualDpadConfig;
import android.hardware.input.VirtualInputDevice;
import android.hardware.input.VirtualKeyEvent;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@SystemApi
public class VirtualDpad
extends VirtualInputDevice {
    private final Set<Integer> mSupportedKeyCodes = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(4, 19, 20, 21, 22, 23)));

    public VirtualDpad(VirtualDpadConfig config, IVirtualDevice virtualDevice, IBinder token) {
        super(config, virtualDevice, token);
    }

    public void sendKeyEvent(@NonNull VirtualKeyEvent event) {
        try {
            if (!this.mSupportedKeyCodes.contains(event.getKeyCode())) {
                throw new IllegalArgumentException("Unsupported key code " + event.getKeyCode() + " sent to a VirtualDpad input device.");
            }
            if (!this.mVirtualDevice.sendDpadKeyEvent(this.mToken, event)) {
                Log.w("VirtualInputDevice", "Failed to send key event to virtual dpad " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

