/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.companion.virtual.IVirtualDevice;
import android.hardware.input.VirtualInputDeviceConfig;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.Closeable;

abstract class VirtualInputDevice
implements Closeable {
    protected static final String TAG = "VirtualInputDevice";
    protected final IVirtualDevice mVirtualDevice;
    protected final IBinder mToken;
    protected final VirtualInputDeviceConfig mConfig;

    VirtualInputDevice(VirtualInputDeviceConfig config, IVirtualDevice virtualDevice, IBinder token) {
        this.mConfig = config;
        this.mVirtualDevice = virtualDevice;
        this.mToken = token;
    }

    public int getInputDeviceId() {
        try {
            return this.mVirtualDevice.getInputDeviceId(this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void close() {
        Log.d(TAG, "Closing virtual input device " + this.mConfig.getInputDeviceName());
        try {
            this.mVirtualDevice.unregisterInputDevice(this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String toString() {
        return this.mConfig.toString();
    }
}

