/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.hardware.input.VirtualInputDevice;
import android.hardware.input.VirtualKeyEvent;
import android.hardware.input.VirtualKeyboardConfig;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

@SystemApi
public class VirtualKeyboard
extends VirtualInputDevice {
    private final int mUnsupportedKeyCode = 23;

    public VirtualKeyboard(VirtualKeyboardConfig config, IVirtualDevice virtualDevice, IBinder token) {
        super(config, virtualDevice, token);
    }

    public void sendKeyEvent(@NonNull VirtualKeyEvent event) {
        try {
            if (23 == event.getKeyCode()) {
                throw new IllegalArgumentException("Unsupported key code " + event.getKeyCode() + " sent to a VirtualKeyboard input device.");
            }
            if (!this.mVirtualDevice.sendKeyEvent(this.mToken, event)) {
                Log.w("VirtualInputDevice", "Failed to send key event to virtual keyboard " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @SuppressLint(value={"UnflaggedApi"})
    public int getInputDeviceId() {
        return super.getInputDeviceId();
    }
}

