/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.hardware.input.VirtualInputDevice;
import android.hardware.input.VirtualRotaryEncoderConfig;
import android.hardware.input.VirtualRotaryEncoderScrollEvent;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

@SystemApi
@FlaggedApi(value="android.companion.virtualdevice.flags.virtual_rotary")
public class VirtualRotaryEncoder
extends VirtualInputDevice {
    public VirtualRotaryEncoder(VirtualRotaryEncoderConfig config, IVirtualDevice virtualDevice, IBinder token) {
        super(config, virtualDevice, token);
    }

    public void sendScrollEvent(@NonNull VirtualRotaryEncoderScrollEvent event) {
        try {
            if (!this.mVirtualDevice.sendRotaryEncoderScrollEvent(this.mToken, event)) {
                Log.w("VirtualInputDevice", "Failed to send scroll event from virtual rotary " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

